#include "point.h"
#include "set.h"
#include "ordcltn.h"

main()
{
    cout << "\nTest class Set\n";
    Point A(1,1);   // create Point object, A
    Point B(1,2);
    Point C(1,3);
    Point D(1,3);
    Point E(1,4);

    Set s(16);      // create Set, s, for 16 elements
    Set t;          // create Set, t, default size

    s.add(A);       // add Points A-D to s
    s.add(B);
    s.add(C);
    s.add(D);

    cout << "s = " << s << "\n";    // print s contents
    t = s;                          // make t a copy of s
    s.reSize(30);                   // expand s to 30 elements

    cout << "s.includes(C): " << s.includes(C) << "\n";
    cout << "t == s: " << (t==s) << "\n";   // equality test
    s.remove(C);
    cout << "s.includes(C): " << s.includes(C) << "\n";
    cout << "t == s: " << (t==s) << "\n";   // equality test
    s.add(E);                       

    cout << "s = " << s << "\n";        // print s contents
    cout << "t = " << t << "\n";        // print t contents
    cout << "s&t = " << (s&t) << "\n";  // intersection of s and t
    cout << "s|t = " << (s|t) << "\n";  // union of s and t
    cout << "s-t = " << (s-t) << "\n";  // difference
    cout << "s.asOrderedCltn: " << (s.asOrderedCltn()) << "\n";
    return 0;
}
