/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _acumos.c $
* Version:      $Revision: 1.2 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for AcuMos SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _acumos.c 1.2 1993/09/24 05:22:02 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _acumos.c $
* Revision 1.2  1993/09/24  05:22:02  kjb
* Fixed a number of bugs.
*
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short ACUMOSModes[] = { 0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5E, 0,        /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grACUMOS_AVGA2,         /* AcuMos AVGA2 SuperVGA chip           */
    } AcuMos_chipsets;

/* Names of chip revision id's. */

char *AcuMosNames[] = {
    "AVGA2",
    };

bool findAcumos(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findAcumos
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Acumos based SuperVGA's.
*
****************************************************************************/
{
    int old,mem;

    old = rdinx(SEQ,6);
    wrinx(SEQ,6,0x0);               /* Lock extended registers          */
    if (tstinx(0x3CE,9,0x30))
        goto NoAcuMos;
    wrinx(SEQ,6,0x12);              /* Unlock extended registers        */
    if (!tstinx(0x3CE,9,0x30))
        goto NoAcuMos;

    /* We have an AcuMos SuperVGA */

    *superVGA = grSVGA_ACUMOS;
    *chipID = grACUMOS_AVGA2;
	*pageFlip = true;

    mem = rdinx(SEQ,0xA) & 3;
    switch (mem) {
        case 0: *memory = 256;  break;
        case 1: *memory = 512;  break;
        case 2: *memory = 1024; break;
        case 3: *memory = 2048; break;
        }
    return true;

NoAcuMos:
    wrinx(SEQ,6,old);
    return false;
}
