/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _ahead.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Ahead SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _ahead.c 1.1 1993/09/19 01:26:00 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _ahead.c $
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short AHEADModes[] = {  0x71, 0,        /* 800x600 16 color     */
                        0x74, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x60, 0,        /* 640x400 256 color    */
                        0x61, 0,        /* 640x480 256 color    */
                        0x62, 0,        /* 800x600 256 color    */
                        0x63, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grAHEAD_A,          /* Ahead A chipset                      */
    grAHEAD_B,          /* Ahead B chipset                      */
    } AHEAD_chipsets;

/* Names of chip revision id's. */

char *AheadNames[] = {
    "A",
    "B",
    };

bool findAhead(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findAhead
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Ahead based SuperVGA's.
*
****************************************************************************/
{
    int     old;

    old = rdinx(GRC,0xF);
    wrinx(GRC,0xF,0);               /* Disable extended registers       */
    if (tstinx(GRC,0xD,0xFB))
        goto NoAhead;
    wrinx(GRC,0xF,0x20);            /* Enable extended registers        */
    if (!tstinx(GRC,0xD,0xFB))
        goto NoAhead;

    /* We have an Ahead based SuperVGA */

    *superVGA = grSVGA_AHEAD;
    *memory = 0;                    /* Don't know how to detect memory  */

    if ((rdinx(GRC,0xF) & 0xF) == 0) {
        *pageFlip = false;
        *chipID = grAHEAD_A;
        unsupportedMode(vbe_1024x768x256,AHEADModes);
        }
    else {
        /* We have an Ahead B SuperVGA */

        *pageFlip = true;
        *chipID = grAHEAD_B;
        }
    return true;

NoAhead:
    wrinx(GRC,0xF,old);
    return false;
}
