;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _avance.asm $
;* Version:     $Revision: 1.2 $
;*
;* Language:    8086 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Assembly language support routines for Avance Logic AL2101
;*              SuperVGA's.
;*
;*              Contains code to perform initialisation, bank switching
;*              and extended page flipping if possible.
;*
;* $Id: _avance.asm 1.2 1993/09/24 05:22:51 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _avance.asm $
;* Revision 1.2  1993/09/24  05:22:51  kjb
;* Fixed a number of bugs.
;*
;* Revision 1.1  1993/09/19  01:26:40  kjb
;* Initial revision
;*
;****************************************************************************

;----------------------------------------------------------------------------
; AVANCE_bank   Change to a new 64k bank (reading and writing)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    AVANCE_bank far

		push    ax
        push    dx
        mov     dx,3D6h
        out     dx,al               ; Set read bank register
        inc     dx
        out     dx,al               ; Set write bank
        pop     dx
        pop     ax
		ret

ENDP    AVANCE_bank

AVANCE_bank_len =   ($-AVANCE_bank)

;----------------------------------------------------------------------------
; AVANCE_rbank Change to a new 64k read bank (reading only)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    AVANCE_rbank   far

		push    ax
        push    dx
        mov     dx,3D6h
        out     dx,al               ; Set read bank register
        pop     ax
        pop     dx
		ret

ENDP    AVANCE_rbank

AVANCE_rbank_len       =   ($-AVANCE_rbank)

;----------------------------------------------------------------------------
; AVANCE_page16  Set the extended CRT starting address.
;----------------------------------------------------------------------------
;
; Entry:        BL  - Index of start address low register
;               BH  - Bits 7-0 of new start address
;               CL  - Index of start address high register
;               CH  - Bits 15-8 of new start address
;               SI  - Bits 16+ for new start address
;
; Registers:    AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------
PROC    AVANCE_page16    far

		SetLowStartAddress
		mov     dx,3D4h             ; DX := CRTC I/O port
		mov     al,20h              ; Index of start address register
		out     dx,al
        inc     dx
        in      al,dx               ; Read old value
		and     al,07h              ; Clear out bits 2-0
		and		bl,07h				; Mask off required bits
		or      al,bl               ; Or in starting address value
        out     dx,al               ; Set the new value
        ret

ENDP    AVANCE_page16

AVANCE_page16_len        =   ($-AVANCE_page16)

;----------------------------------------------------------------------------
; AVANCE_page256  Set the extended CRT starting address.
;----------------------------------------------------------------------------
;
; Entry:        BL  - Index of start address low register
;               BH  - Bits 7-0 of new start address
;               CL  - Index of start address high register
;               CH  - Bits 15-8 of new start address
;               SI  - Bits 16+ for new start address
;
; Registers:    AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------
PROC    AVANCE_page256    far

		SetLowStartAddress256
		mov     dx,3D4h             ; DX := CRTC I/O port
		mov     al,20h              ; Index of start address register
		out     dx,al
        inc     dx
        in      al,dx               ; Read old value
		and     al,07h              ; Clear out bits 2-0
		and		bl,07h				; Mask off required bits
		or      al,bl               ; Or in starting address value
        out     dx,al               ; Set the new value
        ret

ENDP    AVANCE_page256

AVANCE_page256_len        =   ($-AVANCE_page256)

;----------------------------------------------------------------------------
; AVANCE_setup Setup the SuperVGA for correct operation
;----------------------------------------------------------------------------
PROC    AVANCE_setup   near

		modinx	CRTC, 1Ah, 10h, 10h		; Enable extensions
		modinx	CRTC, 19h, 2, 2			; Enable > 256k
		modinx	3CEh, 0Fh, 4, 4			; Enable Read/Write banks
		modinx	CRTC, 20h, 7, 0			; Clear display start
		ret

ENDP    AVANCE_setup

AVANCE_setup_len   =   ($-AVANCE_setup)

;----------------------------------------------------------------------------
; AVANCE_exit  Return the SuperVGA for default operation
;----------------------------------------------------------------------------
PROC    AVANCE_exit    near

		modinx	CRTC, 1Ah, 10h, 0h		; Disable extensions
		ret

ENDP    AVANCE_exit

AVANCE_exit_len    =   ($-AVANCE_exit)

;----------------------------------------------------------------------------
; AVANCE_init
;----------------------------------------------------------------------------
; We have an Advance Logic 2101 SuperVGA, so set up for separate read
; write bank switching.
;----------------------------------------------------------------------------
PROC    AVANCE_init

		mov     [TwoBanks],true
		mov     [WriteBank16],offset AVANCE_bank
		mov     [WriteBank16Len],AVANCE_bank_len
		mov     [WriteBank256],offset AVANCE_bank
		mov     [WriteBank256Len],AVANCE_bank_len
		mov     [ReadBank16],offset AVANCE_rbank
		mov     [ReadBank16Len],AVANCE_rbank_len
		mov     [ReadBank256],offset AVANCE_rbank
		mov     [ReadBank256Len],AVANCE_rbank_len
		mov     [NewPage16],offset AVANCE_page16
		mov     [NewPage16Len],AVANCE_page16_len
		mov     [NewPage256],offset AVANCE_page256
		mov     [NewPage256Len],AVANCE_page256_len
		mov     [SetupSVGA],offset AVANCE_setup
		mov     [SetupSVGALen],AVANCE_setup_len
		mov     [ExitSVGA],offset AVANCE_exit
		mov     [ExitSVGALen],AVANCE_exit_len
		ret

ENDP    AVANCE_init

