/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _genoa.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Genoa SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _genoa.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _genoa.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short GENOAModes[] = {  0x79, 0,        /* 800x600 16 color     */
                        0x5F, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0x5B, 0,        /* 640x350 256 color    */
                        0x7E, 0,        /* 640x400 256 color    */
                        0x5C, 0,        /* 640x480 256 color    */
                        0x5E, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grGENOA_GVGA,           /* Genoa GVGA chipset                       */
    } Genoa_chipsets;

/* Names of chip revision id's. */

char *GenoaNames[] = {
    "GVGA",
    };

bool findGenoa(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findGenoa
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Genoa GVGA based SuperVGA's.
*
****************************************************************************/
{
    int     offset;

    offset = peek(0xC000,0x37);
    if (peekb(0xC000,offset) != 0x77 || peek(0xC000,offset+2) != 0x6699)
        goto NoGenoa;

    /* We have a Genoa based SuperVGA. Note that the newer Genoa cards
     * are based on other SuperVGA chipsets, so we ignore these and let
     * them be handled by the other routines.
     */

    *superVGA = grSVGA_GENOA;
    *pageFlip = false;
    *chipID = grGENOA_GVGA;

    switch(peekb(0xC000,offset+1)) {
        case 0x00:
        case 0x22:
            *memory = 256;
            break;
        case 0x11:
            *memory = 512;
            break;
        default:
            goto NoGenoa;           /* Based on other chipsets          */
        }
    return true;

NoGenoa:
    return false;
}
