/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _primus.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Primus P2000 SuperVGA's.
*               Contains detection code, mode translation tables and chipset
*               names.
*
* $Id: _primus.c 1.1 1993/09/19 01:26:26 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _primus.c $
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short PRIMUSModes[] = { 0x2A, 0,        /* 800x600 16 color     */
                        0x30, 0,        /* 1024x768 16 color    */
                        0x36, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x2C, 0,        /* 640x400 256 color    */
                        0x2D, 0,        /* 640x480 256 color    */
                        0x2B, 0,        /* 800x600 256 color    */
                        0x31, 0,        /* 1024x768 256 color   */
                        0x37, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0x42, 0,        /* 640x350 32k color    */
                        0x43, 0,        /* 640x400 32k color    */
                        0x44, 0,        /* 640x480 32k color    */
                        0x45, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0x42, 0,        /* 640x350 64k color    */
                        0x43, 0,        /* 640x400 64k color    */
                        0x44, 0,        /* 640x480 64k color    */
                        0x45, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grPRIMUS_P2000,         /* Primus P2000 SuperVGA chip               */
    } Primus_chipsets;

/* Names of chip revision id's. */

char *PrimusNames[] = {
    "P2000",
    };

bool findPrimus(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findPrimus
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Primus based SuperVGA's.
*
****************************************************************************/
{
    if (!tstinx(GRC,0x3D,0x3F))     /* Check for status command register */
        goto NoPrimus;
    if (!tstreg(0x3D6,0x1F))        /* Check for bank switch register   */
        goto NoPrimus;
    if (!tstreg(0x3D7,0x1F))        /* Check for bank switch register   */
        goto NoPrimus;

    /* We have a Primus SuperVGA */

    *superVGA = grSVGA_PRIMUS;
    *chipID = grPRIMUS_P2000;
    *pageFlip = true;
    *memory = 0;                    /* Don't know how to detect memory  */
    return true;

NoPrimus:
    return false;
}
