;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _realtek.asm $
;* Version:     $Revision: 1.2 $
;*
;* Language:    8086 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Assembly language support routines for RealTek RT3106
;*              SuperVGA's.
;*
;*              Contains code to perform initialisation, bank switching
;*              and extended page flipping if possible.
;*
;* $Id: _realtek.asm 1.2 1993/09/24 05:23:19 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _realtek.asm $
;* Revision 1.2  1993/09/24  05:23:19  kjb
;* Fixed a number of bugs.
;*
;* Revision 1.1  1993/09/19  01:26:54  kjb
;* Initial revision
;*
;****************************************************************************

;----------------------------------------------------------------------------
; REALTEK_bank  Change to a new 64k bank (reading and writing)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    REALTEK_bank    far

		push    ax
        push    dx
        mov     dx,3D6h
        out     dx,al               ; Set write bank register
        inc     dx
        out     dx,al               ; Set read bank
        pop     dx
        pop     ax
		ret

ENDP    REALTEK_bank

REALTEK_bank_len        =   ($-REALTEK_bank)

;----------------------------------------------------------------------------
; REALTEK_rbank Change to a new 64k read bank (reading only)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    REALTEK_rbank   far

		push    ax
        push    dx
        mov     dx,3D6h
        out     dx,al               ; Set read bank register
        pop     ax
        pop     dx
		ret

ENDP    REALTEK_rbank

REALTEK_rbank_len       =   ($-REALTEK_rbank)

;----------------------------------------------------------------------------
; REALTEK_page16  Set the extended CRT starting address.
;----------------------------------------------------------------------------
;
; Entry:        BL  - Index of start address low register
;               BH  - Bits 7-0 of new start address
;               CL  - Index of start address high register
;               CH  - Bits 15-8 of new start address
;               SI  - Bits 16+ for new start address
;
; Registers:    AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------
PROC    REALTEK_page16    far

        SetLowStartAddress
		mov     dx,3D4h             ; DX := CRTC I/O port
		mov     al,19h              ; Index of start address register
        out     dx,al
        inc     dx
        in      al,dx               ; Read old value
        and     al,050h             ; Clear out bits 4 and 6
        mov     bh,bl
        and     bh,2                ; BH := bit 17 of start address
        shl     bh,1                ; BH := bit 17 in bit pos 2
        and     bl,1                ; BL := bit 16 of start address
        or      bl,bh               ; BL := combined bit 16 and bit 17
        shl     bl,4                ; Put into correct position
        or      al,bl               ; Or in starting address value
        out     dx,al               ; Set the new value
        ret

ENDP    REALTEK_page16

REALTEK_page16_len        =   ($-REALTEK_page16)

;----------------------------------------------------------------------------
; REALTEK_page256  Set the extended CRT starting address.
;----------------------------------------------------------------------------
;
; Entry:        BL  - Index of start address low register
;               BH  - Bits 7-0 of new start address
;               CL  - Index of start address high register
;               CH  - Bits 15-8 of new start address
;               SI  - Bits 16+ for new start address
;
; Registers:    AX,BX,CX,DX,SI
;
;----------------------------------------------------------------------------
PROC    REALTEK_page256    far

		SetLowStartAddress256
		mov     dx,3D4h             ; DX := CRTC I/O port
		mov     al,19h              ; Index of start address register
		out     dx,al
		inc     dx
		in      al,dx               ; Read old value
		and     al,050h             ; Clear out bits 4 and 6
		mov     bh,bl
		and     bh,2                ; BH := bit 17 of start address
		shl     bh,1                ; BH := bit 17 in bit pos 2
		and     bl,1                ; BL := bit 16 of start address
		or      bl,bh               ; BL := combined bit 16 and bit 17
		shl     bl,4                ; Put into correct position
		or      al,bl               ; Or in starting address value
		out     dx,al               ; Set the new value
		ret

ENDP    REALTEK_page256

REALTEK_page256_len        =   ($-REALTEK_page256)

;----------------------------------------------------------------------------
; REALTEK_setup Setup the SuperVGA for correct operation
;----------------------------------------------------------------------------
PROC    REALTEK_setup   near

		modinx  CRTC, 019h, 0A0h, 0A0h  ; Enable display from upper 512k
		modinx  3CEh, 0Fh, 4, 4         ; Setup for dual banking mode
		ret

ENDP    REALTEK_setup

REALTEK_setup_len   =   ($-REALTEK_setup)

;----------------------------------------------------------------------------
; REALTEK_exit  Return the SuperVGA for default operation
;----------------------------------------------------------------------------
PROC    REALTEK_exit    near

        modinx  3CEh, 0Fh, 4, 0 ; Return to single bank mode
        ret

ENDP    REALTEK_exit

REALTEK_exit_len    =   ($-REALTEK_exit)

;----------------------------------------------------------------------------
; REALTEK_init
;----------------------------------------------------------------------------
; We have a REALTEK SuperVGA, so setup the appropriate vectors.
;----------------------------------------------------------------------------
PROC    REALTEK_init

        mov     [TwoBanks],true
        mov     [WriteBank16],offset REALTEK_bank
        mov     [WriteBank16Len],REALTEK_bank_len
        mov     [WriteBank256],offset REALTEK_bank
        mov     [WriteBank256Len],REALTEK_bank_len
        mov     [ReadBank16],offset REALTEK_rbank
        mov     [ReadBank16Len],REALTEK_rbank_len
        mov     [ReadBank256],offset REALTEK_rbank
        mov     [ReadBank256Len],REALTEK_rbank_len
		mov     [NewPage16],offset REALTEK_page16
		mov     [NewPage16Len],REALTEK_page16_len
		mov     [NewPage256],offset REALTEK_page256
		mov     [NewPage256Len],REALTEK_page256_len
		mov     [SetupSVGA],offset REALTEK_setup
        mov     [SetupSVGALen],REALTEK_setup_len
        mov     [ExitSVGA],offset REALTEK_exit
        mov     [ExitSVGALen],REALTEK_exit_len
        ret

ENDP    REALTEK_init
