/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _trident.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Trident SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _trident.c 1.1 1993/09/19 01:26:40 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _trident.c $
* Revision 1.1  1993/09/19  01:26:40  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short TRIDENTModes[] = {0x5B, 0,        /* 800x600 16 color     */
                        0x5F, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5C, 0,        /* 640x400 256 color    */
                        0x5D, 0,        /* 640x480 256 color    */
                        0x5E, 0,        /* 800x600 256 color    */
                        0x62, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x74, 0,        /* 640x480 32k color    */
                        0x76, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x75, 0,        /* 640x480 64k color    */
                        0x77, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grTRIDENT_8800CS,   /* Trident 8800CS SuperVGA              */
    grTRIDENT_8900,     /* Trident 8900 SuperVGA                */
    grTRIDENT_8900C,    /* Trident 8900C SuperVGA               */
    grTRIDENT_9000,     /* Trident 9000 SuperVGA                */
    } TRIDENT_chipsets;

/* Names of chip revision id's. */

char *TridentNames[] = {
    "8800CS",
    "8900",
    "8900C",
    "9000",
    };

bool findTrident(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findTrident
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Trident based SuperVGA's.
*
****************************************************************************/
{
    int chip,old,val;

    wrinx(SEQ,0xB,0);               /* Force old definitions        */
    chip = inp(SEQ+1);              /* Force new definitions        */
    if (chip < 2)
        goto NoTrident;             /* 8800BR only has 128k banks   */
    old = rdinx(SEQ,0xE);
    outp(SEQ+1,0);
    val = inp(SEQ+1);
    outp(SEQ,old);
    if ((val & 0xF) != 2)
        goto NoTrident;

    /* We have a Trident SuperVGA */

    outp(SEQ+1,old ^ 2);            /* Restore register reversed    */
    *superVGA = grSVGA_TRIDENT;
    *pageFlip = true;

    if (chip == 2) {
        *chipID = grTRIDENT_8800CS;
        *memory = 256;
        if (rdinx(CRTC,0x1F) & 2)
            *memory = 512;
        unsupportedMode(vbe_800x600x256,TRIDENTModes);
        unsupportedMode(vbe_1024x768x256,TRIDENTModes);
        }
    else {
        if (chip == 4)
            *chipID = grTRIDENT_8900;
        else if (chip == 0x13 || chip == 0x33 || chip == 0x53 ||
                chip == 0x73 || chip == 0xA3)
            *chipID = grTRIDENT_8900C;
        else
            *chipID = grTRIDENT_9000;
        val = rdinx(CRTC,0x1F) & 3;
        if (val == 0)
            *memory = 256;
        else if (val <= 2)
            *memory = 512;
        else *memory = 1024;
        }
    return true;

NoTrident:
    return false;
}
