/*****************************************************************************/
/* Main                                                                      */
/*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include "video.h"
#include "cmand.h"

char palette[768];

char *FractalSpace;

int drawcount=100;

#define TAB 9
#define ENTER 13
#define ESC 27
#define ESCAPE 27
#define SPACEBAR 32
#define BACKSPACE 8

#define STAB 271
#define LEFT 331
#define RIGHT 333
#define UP 328
#define DOWN 336

#define HOME 71+256
#define PGUP 73+256
#define END 79+256
#define PGDN 81+256
#define DELETE 83+256

#define F1 315
#define F2 316
#define F3 317
#define F4 318
#define F5 319
#define F6 320
#define F7 321
#define F8 322
#define F9 323
#define F10 324

int INLINE=1;

int steps;

void	main(int argc,char **argv);
void	myeplot(int x,int y);
int 	SetPal(char *name);
int keystat(void);
int getkey(void);

int     iter,xmax,ymax;
double  xc,yc,fx,fy,stepx,stepy,xscale,yscale,mag;
double  xleft,xright,ytop,ybot;

int 		dispmode = 0,doxcon = 0,keypres;

void    main(argc,argv)
int     argc;
char  **argv;
{
	FILE *fph;
	int xcon=0,j,keypress,l,review=0;
	int 	x1,y1,x2,y2,ret,i,picno=0,picstart,k,skip;
	double mag4,maginc,xc1,yc1,magend;
	int xloc=0,yloc=0,dirx,diry,key,speed=5;

	if ( argc == 2 )
	{
		review = 1;
		printf("Attempting to open fractal image file '%s'.\n",argv[1]);
		fph = fopen(argv[1], "rb");
		if ( !fph )
		{
			printf("Unable to open fractal image file '%s'\n",argv[1]);
			exit(1);
		}
		fread(&xmax, 2, 1, fph);
		fread(&ymax, 2, 1, fph);
		FractalSpace = malloc(xmax*ymax);
		if ( !FractalSpace )
		{
			printf("Unable to allocate memory for fractal work space.  Needed %ld bytes.\n",xmax*ymax);
			exit(1);
		}
		printf("Reading fractal image into memory...");
		fread(FractalSpace, xmax, ymax, fph);
		printf("Fractal image read.\n");
		fclose(fph);
	}
	else
	{
		if (argc != 6)
		{
			printf("Usage: FRAC xwidth iterations xleft(f) xright(f) ytop(f) (steps) (magout)\n");
			printf("xwidth -> is the screen width of the fractal image.  Max is 320.  Use smaller\n");
			printf("          windows to preview fractals.\n");
			printf("iterations-> maximum number of iterations to perform.  Low counts will execute\n");
			printf("          faster.\n");
			printf("xleft ->  Left location of fractal zoom area.\n");
			printf("xright->  Right location of fractal zoom region.\n");
			printf("ytop->    Top location of fractal zoom region, bottom will be automatically\n");
			printf("          computed.\n");
			printf("or to review a previous fractal image, type FRAC <imagename>\n");
			printf("The fractal program saves the fractal image drawn, out under\n");
			printf("the default name of FRAC.RAW, so to review your last computed\n");
			printf("fractal image, type FRAC FRAC.RAW.\n");
			exit(1);
		}
	}

	if ( !review )
	{
		xmax = atoi(argv[1]);
		ymax = xmax;

		FractalSpace = malloc(xmax*ymax);
		if ( !FractalSpace )
		{
			printf("Unable to allocate memory for fractal work space.  Needed %ld bytes.\n",xmax*ymax);
			exit(1);
		}

		iter = atoi(argv[2]);
		xleft  = atof(argv[3]);
		xright = atof(argv[4]);
		ytop	 = atof(argv[5]);
		mag 	 = (xright-xleft);
		ybot	 = ytop + mag;

		xc	= xleft + mag/2.0;
		yc	= ytop + mag/2.0;


		xscale = mag/(double) xmax;
		yscale = mag/(double) xmax;
	}

	VideoUp();

	SetPal("FRAC.PAL");

	if ( review ) goto ReviewImage;

	x1 = 0;
	y1 = 0;
	x2 = xmax-1;
	y2 = ymax-1;

	VidClearf(x1,y1,x2,y2,0);

	for (i=x1; i<x2 && !xcon; i++)
	{
		for (j=y1; j<y2 && !xcon; j++)
		{
			myeplot(i,j);
			if ( keystat() )
			{
				keypress = getkey();
				switch (keypress)
				{
					case '+': drawcount++;
										break;
					case '-':drawcount--;
									 if ( drawcount < 1 ) drawcount = 1;
									 break;
					case 13: drawcount = 2;
									 break;
					case 32: drawcount = 100;
									 break;
				 case  27: xcon = 1;
									 break;
				}
			}
		}
	}

	if ( !xcon )	// Only if the fractal was completely drawn.
	{
		fph = fopen("FRAC.RAW", "wb");
		if ( fph )
		{
			fwrite(&xmax, 2, 1, fph);
			fwrite(&ymax, 2, 1, fph);
			fwrite(FractalSpace, xmax, ymax, fph);
			fclose(fph);
		}
	}

ReviewImage:
	dirx = 0;
	diry = 0;
	xcon = 0;
	do
	{
		VidDraw(FractalSpace,xmax,ymax,xloc,yloc);
		xloc+=(dirx*speed);
		yloc+=(diry*speed);
		if ( xloc > xmax-320 ) xloc = xmax-320;
		if ( xloc < 0 ) xloc = 0;
		if ( yloc > ymax-200 ) yloc = ymax-200;
		if ( yloc < 0 ) yloc = 0;
		if ( keystat() )
		{
			key = getkey();
			switch ( key )
			{
				case '+': speed++;  break;
				case '-': speed--; if ( speed < 1 ) speed = 1; break;
				case LEFT: dirx = -1; diry = 0; break;
				case RIGHT: dirx = 1; diry = 0; break;
				case UP: dirx = 0; diry = -1; break;
				case DOWN: dirx = 0; diry = 1; break;
				case HOME: dirx=-1; diry = -1; break;
				case PGUP: dirx = 1; diry = -1; break;
				case END: dirx = -1; diry = 1; break;
				case PGDN: dirx = 1; diry = 1; break;
				case 32: dirx = 0; diry = 0; break;
				case 27: xcon = 1; break;
			}
		}
	} while ( !xcon );

	VideoDown();

}

void		myeplot(int x,int y)
{
  int   count;
	double cx,cy;

  cx = x*xscale+xleft;
  cy = ybot-y*yscale;

	if ( INLINE )
		count = MandelbrotPoint(4.0,iter,cx,cy)+1;
	else
		count = CMandelbrotPoint(4.0,iter,cx,cy)+1;

	if (count==iter+1) count=0;

	VidPlotPixel(x,y,count%256);

}

int SetPal(char *fname)
{
	FILE *fph;
	long int size;

	fph = fopen(fname, "rb");
	if ( fph )
	{
		fread(palette, 768, 1, fph);
		fclose(fph);
		VidSetPal(palette, 0, 256 );
		return(1);
	}
	return(0);
}

int keystat(void)
{
	return( kbhit() );
}

int getkey(void)
{
	int ch;

	ch = getch();
	if ( ch == 0 ) ch = getch()+256;
	return(ch);
}
