#include "vp.h" // Include video primatives header file.

static int lastx=0,lasty=0;
static int count=0;

extern char *FractalSpace;
extern int xmax,ymax;
extern int drawcount;

void VideoUp(void)
{
	VidOn();
}

void VideoDown(void)
{
	VidOff();
}

void VidClearf(int x1,int y1,int x2,int y2,int color)
{
	char *dest;
	int i,j;

	for (i=y1; i<=y2; i++)
	{
		for (j=x1; j<=x2; j++)
		{
			dest = i*xmax+j+FractalSpace;
			*dest = color;
		}
	}
}

void VidPlotPixel(int x,int y,int color)
{
	int dx,dy;
	int xoff,yoff;
	char *dest;

	dest = y*xmax+x+FractalSpace;
	*dest = color;
	xoff = x-160;
	yoff = y-160;
	if ( xoff < 0 ) xoff = 0;
	if ( yoff < 0 ) yoff = 0;
	if ( xoff+320 > xmax ) xoff = xmax-320;
	if ( yoff+200 > ymax ) yoff = ymax-200;

	count++;
	if ( count >= drawcount )
	{
		DumpImage(FractalSpace,xmax,ymax,xoff,yoff);
		count = 0;
	}
}

int  VidGetPixel(int x,int y)
{
	unsigned char *dest;

	dest = y*xmax+x+FractalSpace;
	return(*dest);
}

void VidSetPal(char *pal,int start,int colors)
{
	VGAP(pal,0,colors);
}

void VidDraw(char *image,int wid,int hit,int xloc,int yloc)
{
	DumpImage(image,wid,hit,xloc,yloc);
}
