
	IDEAL
	JUMPS
	include "prologue.mac"
	P386			; 386 specific opcodes and shit allowed.
	P387		; Allow 386 processor


	MASM
	.MODEL FLAT,C		;32-bit OS/2 model
	.CODE
	IDEAL

	public	VidOn
	public	VidOff
	public	PlotPixel
	public	VGAP
	public	DumpImage
	public	MandelbrotPoint
	public	vwait

Proc	C vwait near
	mov	dx,03dah		; wait for no retrace
@@rt1:  in      al,dx                   ;  ...
	and	al,8			; this bit is high during a retrace
	jnz	@@rt1			;  so loop until it goes low
@@rt2:	in	al,dx			; wait for no retrace
	and	al,8			; this bit is high during a retrace
	jz	@@rt2			;  so loop until it goes high
	ret
	endp

Proc	C VidOn near
	mov	ax,13h
	int	10h
	ret
	endp

Proc	C	VidOff near
	mov	ax,03
	int	10h
	ret
	endp

xoff	equ	8
yoff	equ	12
coff	equ	16

;;
Proc	C	PlotPixel	near
	ARG	XLOC:DWORD,YLOC:DWORD,COLOR:DWORD
	push	ebx

	mov	ax,320
	mul	[word ebp+yoff]
	add	ax,[ebp+xoff]
	mov	ebx,0A0000h	; Base address of screen ram.
	add	bx,ax
	mov	ax,[ebp+coff]
	mov	[ebx],al

	pop	ebx
	ret
	endp


pal	db	768 dup(?)

;;
Proc	C VGAP	near
	ARG	POFF:DWORD
	push	esi

	mov	esi,[POFF]
	mov	ecx,768
	lea	edi,[pal]

@@GO:   lodsb
	shr	al,2
	stosb
	loop	@@GO


	mov	dx,03dah		; wait for no retrace
@@rt1:  in      al,dx                   ;  ...
	and	al,8			; this bit is high during a retrace
	jnz	@@rt1			;  so loop until it goes low
@@rt2:	in	al,dx			; wait for no retrace
	and	al,8			; this bit is high during a retrace
	jz	@@rt2			;  so loop until it goes high

	mov	dx,03c8h		; set up for a blitz-write
	mov	ax,bx			; from this register
	lea	esi,[pal]
	cli				; critical section:  no ints
	out	dx,al			; starting register
	inc	dx			; set up to update colors
	mov	cx,768
	rep	outsb			; whap!  Zango!  They're updated!
	sti				; end of critical section

	pop	esi
	ret
	endp


image	equ	8
iwid	equ	12
ihit	equ	16
ixloc	 equ	 20
iyloc	 equ	 24

;;
Proc	C DumpImage	near
	ARG	IMG:DWORD,W:DWORD,H:DWORD,X:DWORD,Y:DWORD
	push	esi
	push	edi

	mov	esi,[ebp+image]
	mov	ax,[word ebp+iyloc]	    ; Get the ylocation.
	mul	[word ebp+iwid]  ; Times image width.
	push	dx
	push	ax
	pop	eax			;

	add	eax,[dword ebp+ixloc]	 ; now have base address.
	add	esi,eax 		; Compute starting address.
	mov	edi,0A0000h	; Base address of screen ram.
	mov	dx,200	; for 200 scan-lines.
@@GO:	push	esi
	mov	cx,320/4
	rep	movsd
	pop	esi
	add	esi,[ebp+iwid]
	dec	dx
	jnz	@@GO


	pop	edi
	pop	esi
	ret
	endp


limit	equ	8
iter	equ	16
real	equ	20
imag	 equ	28

;; This is the Mandelbrot point computation procedure.
Proc	C MandelbrotPoint near
	ARG	L:QWORD,I:WORD,R:QWORD,IM:QWORD

	mov	ecx,[ebp+iter]
	mov	bx,cx
	finit
	fld	[qword ebp+limit]	  ; 7 Load floating point limit
	fld	[qword ebp+real]	  ; 6 load floating point real.
	fld	[qword ebp+imag]     ; 5 load floating point imaginary.
	fld	[qword ebp+real]	  ; 4 fx store 0.0 real accum.
	fld	[qword ebp+imag]     ; 3 fy store 0.0 imaginary accum
	fldz			; 2 xs store 0.0 holds real squared
	fldz			; 1 ys store 0.0 holds imaginary squared
	fldz			; 0 store 0.0, clear accum.

@@GO:
;;    xs = fx*fx;
	fxch	st(4)		; get FX
	fst	st(4)		; save it back.
	fmul	st,st		; Square it.
	fst	st(2)		; Save in XS xsquared.

;;    ys = fy*fy;
	fxch	st(3)		; Get FY
	fst	st(3)		; save it back.
	fmul	st,st		; sqare it.
	fst	st(1)		; Save it.

;;  fy = (2*fx*fy)+imaginary;
	fxch	st(4)		; get FX
	fadd	st,st		; *2
	fmul	st,st(3)	; * fy
	fadd	st,st(5)	; plus imaginary portion.
	fst	st(3)		; Store result back into FY!

;;    fx = xs-ys+real;

	fxch	st(2)		; Get xsquared.
	fst	st(2)		; Save it back again for loop test!
	fsub	st,st(1)	; less ysquared.
	fadd	st,st(6)	; Plus real portion.
	fst	st(4)		; Store result back into FX

;; while ( xs+ys < limit && count < iterations);
	fxch	st(2)		; Get x squared.
	fadd	st,st(1)	; Add y sqaured

	fcom	st(7)		; is it < limit?
	fstsw   ax              ;sw till ax
	shr	ah,1
	jnc	@@exit		; exit if >= limit
	dec	cx
	jnz	@@GO		; Next iteration.

@@exit: mov     ax,bx
	sub	ax,cx
	finit                   ;Initialisera coprocessorn!!

	ret
	endp

	END
