/* MOIRE8.C */


#include <stdio.h>      /* Standard input/output libraries */
#include <conio.h>      /* For kbhit */
#include <graph.h>      /* Microsoft graphics library */
#include <time.h>       /* Used in delays */
#include "sound.h"      /* Used in sound function*/

int speed;                        /*                  */
int rate;                         /*                  */
int shift;                        /*    parameters    */
int size;                         /*                  */
int zoom;                         /*                  */
int explode;                      /* flag for exploding toggle*/
int autoclear;                    /* flag for automatic screan clearing*/
int soundon;                      /* flag for sound toggle*/
int status_flag;                  /* flag for parameter updating*/

static unsigned control;          /*used by sound function*/
static int control_flag=1;

FILE *fp;                         /*used by binary storage file 'save.bin'*/
int param[9];
int array;

char text[64];

time_t current_time, start_time;  /* used for delay */

void status(void);
int menu(int);
void sound(long frequency);
void silence(void);

int main(void)
{


   int a, i, j, k,         /* counters for looping */
	   cx, cy;         /* x,y center of the screen */
   int option;             /* used in menu switch */
   int exp;                /* used in exploding toggle*/
   long x, y, z;

   if(( fp = fopen("save.bin", "rb")) != NULL)
   {
      rewind(fp);
      fread(param, sizeof(param), 1, fp);

   fclose(fp);
   }
   else
   {
      perror("Read error");
      return(0);
   }

   speed=param[0];
   rate=param[1];
   shift=param[2];
   size=param[3];
   zoom=param[4];
   explode=param[5];
   autoclear=param[6];
   soundon=param[7];
   status_flag=param[8];

   _setvideomode(_MRES256COLOR);

   printf("\n\n\n\n\n\n\n\n               MOIRE8");
   printf("\n\n           Hit H for help");

   time(&start_time);                           /* delay          */
   do                                           /*       3        */

	 time(&current_time);                   /*         seconds*/
   while (current_time - start_time < 3);

   _clearscreen(_GCLEARSCREEN);

   cx = 160; cy = 100;     /* set screen center */

   while(1)
   {
       for (a = 1; a <10000000; a+=rate)
       {
	   for(k=1; k<=zoom; k++)
	   {
	       if (kbhit())
		       {
			    option=getch();
			    if (menu(option) == 1)
				return(0);
		       }
	       if (explode==0)
		       exp=1;
	       else
		       exp=k;
	       if (autoclear==1)
		       _clearscreen(_GCLEARSCREEN);

	       for (x = a, z = 1, i = 0; i <=((size*k)%200); x += a, z+=1,i += speed*exp)
	       {
		   for (y = x, j = i; j <= (size*k)%200; y += a, j += speed*exp)
		   {
		       _setcolor((( x * x) + (y * y)>>shift)%255);
		       _setpixel(cx + i - k, cy - j + k);
		       _setpixel(cx + j - k, cy - i + k);
		       _setpixel(cx + j - k, cy + i - k);
		       _setpixel(cx + i - k, cy + j - k);
		       _setpixel(cx - i + k, cy + j - k);
		       _setpixel(cx - j + k, cy + i - k);
		       _setpixel(cx - j + k, cy - i + k);
		       _setpixel(cx - i + k, cy - j + k);

		    if (soundon==1)
			{
			sound(((k*i)+x)+1);
			sound(((k*j)+y)+1);
			}
		    else
			{
			silence();
			}
		   }
	       }
	       for (x = z * a, i = (size*k)%200; i >=0; x -=a, i -= speed*exp)
	       {
		   for (y = x, j = i; j >= 0; y -=a, j -= speed*exp)
		   {
		       _setcolor((( x * x ) + (y * y)>>shift)%255);
		       _setpixel(cx + i - k, cy - j + k);
		       _setpixel(cx + j - k, cy - i + k);
		       _setpixel(cx + j - k, cy + i - k);
		       _setpixel(cx + i - k, cy + j - k);
		       _setpixel(cx - i + k, cy + j - k);
		       _setpixel(cx - j + k, cy + i - k);
		       _setpixel(cx - j + k, cy - i + k);
		       _setpixel(cx - i + k, cy - j + k);

		    if (soundon==1)
			{
			sound(((k*j)+y)+1);
			sound(((k*i)+x)+1);
			}
		    else
			{
			silence();
			}
		   }
	       }
	   }
       }
   }
}

void status(void)
{
	_settextwindow(2,1,12,9);
	_clearscreen(_GWINDOW);
	sprintf(text, "Size  %d\n",size);
	_outtext(text);
	sprintf(text, "Speed %d\n",speed);
	_outtext(text);
	sprintf(text, "Rate  %d\n",rate);
	_outtext(text);
	sprintf(text, "Zoom  %d\n",zoom);
	_outtext(text);
	sprintf(text, "Shift %d\n",shift);
	_outtext(text);
	sprintf(text, "Expld %d\n",explode);
	_outtext(text);
	sprintf(text, "Clear %d\n",autoclear);
	_outtext(text);
	sprintf(text, "Sound %d\n",soundon);
	_outtext(text);
}
int menu(int option)
{
	switch(option)
	{
		case 'H':
		case 'h':
			silence();
			_settextwindow(1,10,34,70);
			_clearscreen(_GCLEARSCREEN);
			sprintf(text, " HOT KEYS\n");
			_outtext(text);
			sprintf(text, " ) increase size\n");
			_outtext(text);
			sprintf(text, " ( decrease size\n");
			_outtext(text);
			sprintf(text, " + speed it up\n");
			_outtext(text);
			sprintf(text, " - slow it down\n");
			_outtext(text);
			sprintf(text, " P increase rate\n");
			_outtext(text);
			sprintf(text, " O decrease rate\n");
			_outtext(text);
			sprintf(text, " ] increase zoom\n");
			_outtext(text);
			sprintf(text, " [ decrease zoom\n");
			_outtext(text);
			sprintf(text, " > increase shift\n");
			_outtext(text);
			sprintf(text, " < decrease shift\n");
			_outtext(text);
			sprintf(text, " X exploding zoom\n");
			_outtext(text);
			sprintf(text, " Z straight zoom\n");
			_outtext(text);
			sprintf(text, " A autoclear\n");
			_outtext(text);
			sprintf(text, " S static\n");
			_outtext(text);
			sprintf(text, " Q quiet\n");
			_outtext(text);
			sprintf(text, " W with sound\n\n");
			_outtext(text);

			sprintf(text, " D disable autolist \n");
			_outtext(text);
			sprintf(text, " E enable autolist \n");
			_outtext(text);
			sprintf(text, " C clear the screen\n");
			_outtext(text);
			sprintf(text, " L list parameters \n\n");
			_outtext(text);

			sprintf(text, " ESC quit \n");
			_outtext(text);
			time(&start_time);
			do
			   time(&current_time);
			while (current_time - start_time < 10);
			_clearscreen(_GCLEARSCREEN);
			return(0);
			break;
		case 'C':
		case 'c':
			_clearscreen(_GCLEARSCREEN);
			return(0);
			break;
		case 'E':
		case 'e':
			status_flag=1;
			return(0);
			break;
		case 'D':
		case 'd':
			status_flag=0;
			return(0);
			break;
		case 'L':
		case 'l':
			status();
			return(0);
			break;
		case '=':
		case '+':
			speed+=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case '_':
		case '-':
			if(speed >= 2)
			   speed-=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case ']':
		case '}':
			zoom+=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case '[':
		case '{':
			if(zoom > 1)
			   zoom-=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case '.':
		case '>':
			if(shift<30)
			   shift+=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case ',':
		case '<':
			if(shift >= 1)
			   shift-=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'p':
		case 'P':
			rate+=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'o':
		case 'O':
			if(rate >= 1)
			   rate-=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case ')':
		case '0':
			size++;
			   if(status_flag)
			status();
			   return(0);
			break;
		case '(':
		case '9':
			if(size >= 2)
			   size--;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'x':
		case 'X':
			explode=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'z':
		case 'Z':
			explode=0;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'a':
		case 'A':
			autoclear=1;
			if(status_flag)
			   status();
			return(0);
			break;
		case 's':
		case 'S':
			autoclear=0;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'q':
		case 'Q':
			soundon=0;
			if(status_flag)
			   status();
			return(0);
			break;
		case 'w':
		case 'W':
			soundon=1;
			if(status_flag)
			   status();
			return(0);
			break;

		case 27:
			silence();
			printf("BYE");

			param[0]=speed;
			param[1]=rate;
			param[2]=shift;
			param[3]=size;
			param[4]=zoom;
			param[5]=explode;
			param[6]=autoclear;
			param[7]=soundon;
			param[8]=status_flag;

			if((fp=fopen("save.bin", "wb"))!=NULL)
			{
			   fwrite(param, sizeof(param), 1, fp);
			   fclose(fp);
			}
			else
			   perror("Write error");

			time(&start_time);              /* delay */
			do
			    time(&current_time);
			while (current_time - start_time < 1);
			_setvideomode(_DEFAULTMODE);
			return(1);
	}
}

void sound(long frequency)
{
    long divisor;

    divisor = (unsigned)(1193180L/frequency);
    if(control_flag)
	{
	outp(0x43, 0xB6);
	outp(0x42, divisor % 51);
	outp(0x42, divisor / 51);
	control=inp(0x61);
	control_flag=0;
	}
    else
	{
	divisor=(unsigned)(1193280 / frequency);
	outp(0x42, divisor % 51);
	outp(0x42, divisor / 51);
	}
    outp(0x61, control | 3);
}

void silence(void)
{
    outp(0x61, control);
    control_flag=1;
}
