{************************************************************************}
{************************************************************************}
{* Modul:	adcolstr.pas						*}
{************************************************************************}
{* Inhalt:	TextStrings fr National-Language Support in ADIRCOL	*}
{************************************************************************}
{* Funktion:	Bestimmung der richtigen Textstrings in Abhngigkeit	*}
{*              der Country-Information bzw. der Enviromentvar. ADIRLANG*}
{************************************************************************}
{* Version:	0.10							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	18.Jan.1994						*}
{* Vernderung:	Erste Version						*}
{************************************************************************}
{* Revision:	0.10 Erste Version					*}
{************************************************************************}
{* Routinen:	-							*}
{************************************************************************}
Unit ADColStr;
interface

Var      StrTitLin : String;
         StrTypLin : Array[1..10] of String;
         StrColLin : Array[1..10] of String;
         StrTxtCol : String;
         StrHGrCol : String;
         StrFilNam : String;
         StrExeTit : String;
         StrSngTit : String;
         StrHlpTit : String;
         StrDbfSat : String;
         StrDbfFel : String;
         StrArcFil : String;
         Language  : String[3];

implementation
uses nls,dos;

Var      S         : String;

begin   
   if Country=$2e then Language:='SWE'
   else if Country=$01 then Language:='ENG'
   else Language:='GER';

   S:=GetEnv('ADIRLANG');
   if S<>'' then Language:=Copy(S,1,3);

   if Language='SWE' then begin
     StrTitLin := '>>> Farg-instllning fr Advanced-Dir <<<';
     StrTypLin [1]:= 'Oknda filer';
     StrTypLin [2]:= 'Grafik-filer';
     StrTypLin [3]:= 'Program-filer';
     StrTypLin [4]:= 'Ljud-filer';
     StrTypLin [5]:= 'Databs-filer';
     StrTypLin [6]:= 'Text-filer';
     StrTypLin [7]:= 'Packade filer';
     StrTypLin [9]:= 'Spara';
     StrTypLin[10]:= 'Avsluta';
     StrColLin[ 1]:= 'Namn';
     StrColLin[ 2]:= 'Tillgg';
     StrColLin[ 3]:= 'Storlek';
     StrColLin[ 4]:= 'Datum';
     StrColLin[ 5]:= 'Tid';
     StrColLin[ 6]:= 'Filtyp';
     StrColLin[ 7]:= 'Utokning 1';
     StrColLin[ 8]:= 'Utokning 2';
     StrColLin[ 9]:= 'Utokning 3';
     StrColLin[10]:= 'treg';
     StrTxtCol := 'Text       ';
     StrHGrCol := 'Bakgrund   ';
     StrFilNam := 'Exempel ';
     StrExeTit := 'Exempelprogram      ';
     StrSngTit := 'Exempelljud         ';
     StrHlpTit := 'Exempelhjlp        ';
     StrDbfSat := ' sats. ';
     StrDbfFel := ' flt  ';
     StrArcFil := ' filer';
   end
   else if Language='ENG' then begin
     StrTitLin := '>>> Colour configuration for Advanced-Dir <<<';
     StrTypLin [1]:= 'unrecognized files';
     StrTypLin [2]:= 'graphic files';
     StrTypLin [3]:= 'programm files';
     StrTypLin [4]:= 'sound files';
     StrTypLin [5]:= 'database files';
     StrTypLin [6]:= 'text files';
     StrTypLin [7]:= 'packed files';
     StrTypLin [9]:= 'store';
     StrTypLin[10]:= 'quit';
     StrColLin[ 1]:= 'name';
     StrColLin[ 2]:= 'extension';
     StrColLin[ 3]:= 'size';
     StrColLin[ 4]:= 'date';
     StrColLin[ 5]:= 'time';
     StrColLin[ 6]:= 'type';
     StrColLin[ 7]:= 'ext.1';
     StrColLin[ 8]:= 'ext.2';
     StrColLin[ 9]:= 'ext.3';
     StrColLin[10]:= 'back';
     StrTxtCol := 'text       ';
     StrHGrCol := 'background ';
     StrFilNam := 'example ';
     StrExeTit := 'Exampleprogram      ';
     StrSngTit := 'Example sound       ';
     StrHlpTit := 'Example helpfile    ';
     StrDbfSat := ' Record';
     StrDbfFel := ' Fields';
     StrArcFil := ' Files';
   end
   else begin
     StrTitLin := '>>> Farb-Konfiguration fr Advanced-Dir <<<';
     StrTypLin [1]:= 'Unbekannte Dateien';
     StrTypLin [2]:= 'Graphik-Dateien';
     StrTypLin [3]:= 'Programm-Dateien';
     StrTypLin [4]:= 'Sound-Dateien';
     StrTypLin [5]:= 'Datenbank-Dateien';
     StrTypLin [6]:= 'Text-Dateien';
     StrTypLin [7]:= 'Gepackte Dateien';
     StrTypLin [9]:= 'Speichern';
     StrTypLin[10]:= 'Ende';
     StrColLin[ 1]:= 'Name';
     StrColLin[ 2]:= 'Extension';
     StrColLin[ 3]:= 'Gre';
     StrColLin[ 4]:= 'Datum';
     StrColLin[ 5]:= 'Uhrzeit';
     StrColLin[ 6]:= 'Dateityp';
     StrColLin[ 7]:= 'Erweit.1';
     StrColLin[ 8]:= 'Erweit.2';
     StrColLin[ 9]:= 'Erweit.3';
     StrColLin[10]:= 'Zurck';
     StrTxtCol := 'Text       ';
     StrHGrCol := 'Hintergrund';
     StrFilNam := 'Beispiel';
     StrExeTit := 'Beispielprogramm    ';
     StrSngTit := 'Beispielsound       ';
     StrHlpTit := 'Beispiel-Hilfe      ';
     StrDbfSat := ' Stze ';
     StrDbfFel := ' Felder';
     StrArcFil := ' Files';
   end;
end.
