{************************************************************************}
{* Programm:	AdvDir	(Advanced Dir-Befehl)				*}
{************************************************************************}
{* Autor:	Thomas Mainka						*}
{* Stand:	18.Jan.1994						*}
{* Version:	0.50a							*}
{************************************************************************}
{* Support-BBS:	MOEBIUS MAIL +49-911-4712969 (FIDO 2:2490/1517)		*}
{************************************************************************}
{* Module:	adir.pas	0.50					*}
{*		adsort.pas	0.50					*}
{*		adinfo.pas	0.50					*}
{*		adhelp.pas	0.50					*}
{*		adstring.pas	0.50					*}
{*		adansi.pas	0.50					*}
{*		nls.pas		0.20					*}
{************************************************************************}
{************************************************************************}
{* Modul:	adir.pas						*}
{************************************************************************}
{* Inhalt:	Hauptprogramm des Advanced Directory			*}
{************************************************************************}
{* Funktion:	Suchen von Dateien gem Suchmuster, Extraktion von	*}
{*		Zusatzinformationen, Sortierung der Dateien nach whlb.	*}
{*		Ordnungskriterien und Ausgabe des Direktories mit den	*}
{*		oben ermittelten Zusatzkriterien.			*}
{************************************************************************}
{* Version:	0.50							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	10.Jan.1994						*}
{* Vernderung:	Korrektur der Speicherverwaltung.			*}
{*		Sperrung der Volume-Namen in der /A Option.		*}
{*		Sperrung der "Dot"-Verzeichnisse bei /XD und /XF.	*}
{*		Durchfhrung der Datei-Tests auch bei /B bzw /W bei	*}
{*		farbiger Ausgabe.					*}
{************************************************************************}
{* Revision:	0.10 Erste Public Beta-Version				*}
{*		0.12 Integration eines Hilfsbildschirms als Option und	*}
{*		     bei fehlerhaftem Aufruf von ADir.			*}
{*		     Unterstuetzung der Auswahl von Dateien ber Datei-	*}
{*		     Attribut.						*}
{*                   Herausnahme der Informations-Routinen aus dem Modul*}
{*                   (siehe adinfo.pas).				*}
{*		     berarbeitung der Sortier-Steuerung auf Grund der	*}
{*		     Zusammenfassung und Verbesserung der Vergleichs-	*}
{*		     routine (siehe adsort.pas).			*}
{*		0.14 Integration der Ausgabe-Switches /b und /w.	*}
{*		     Ausgabe von Soundlngen (sofern bestimmt).		*}
{*		0.22 Ausgabe farbig ber ANSI-Treiber wenn dieser vor-	*}
{*		     handen ist und die Ausgabe nicht umgeleitet wird.	*}
{*		0.24 Integration der Ausgabe von gepackten Dateien als	*}
{*		     eigener File-Typ					*}
{*		0.30 Integration der Ausgabe von Datenbank Dateien als	*}
{*		     eigener File-Typ.					*}
{*		     Integration des Color-Switch /c zur Farbabschaltung*}
{*		0.32 Integration der Ausgabe von Text-Dateien als	*}
{*		     eigener File-Typ.					*}
{*		     Integration des Unterverzeichnis-Switch /S zur	*}
{*		     Suche in Unterverzeichnissen.			*}
{*		0.34 Verbesserung der Sortierung beim /S-Switch.	*}
{*		     Ausgabe von Minuten bei lngeren Sound-Samples.	*}
{*		0.40 Ausgabe im DESCRIPT.ION und FILES.BBS-Format ber 	*}
{*		     /XD und /XF-Switch.				*}
{*		     Umbenennung des /C-Switch auf /D (wie 4DOS).	*}
{*		     Verbesserung der Pausenfunktion (/P) bei der Suche	*}
{*		     in Unterverzeichnissen (/S).			*}
{*		0.42 Integration der Trouble-Shooting-Ausgabe ber /XT- *}
{*		     und der erweiterten DateiTyp-Suche ber /XX-Switch.*}
{*		     Korrektur der Verzeichnis-Gren-Ausgabe.		*}
{*		0.44 Erweiterung des National-Language Supports durch	*}
{*		     Ausgabe der Texte in Benutzersprache.		*}
{*		     Erweiterung der Ausgabe um Volume-Namen.		*}
{************************************************************************}
{* Routinen:	GetCommand						*}
{*		FindVolume						*}
{*		FindFiles						*}
{*		SortFiles						*}
{*		PrintFiles						*}
{************************************************************************}

program AdvDir;
{$I-,S-}
{$M 8192,8192,655360}

uses Dos,NLS,crt,adsort,adinfo,adansi,adhelp,adstring;

Var      AttrO     : Boolean;
         AttrM     : Boolean;
         AttrF     : Boolean;
         Color     : Boolean;
         PrntO     : Boolean;
         PrntD     : Boolean;
         PrntF     : Boolean;
         Attrib    : Array[1..6] of Char;
         SAttrib   : Byte;
         TAttrib   : Byte;
         EAttrib   : Byte;

{************************************************************************}
{* Routine:	GetCommand						*}
{************************************************************************}
{* Inhalt:	Untersuchung der Kommandozeile auf Datei-Pfad-Angabe	*}
{*		und Programm-Switches. Setzen der Steuerflags fr das	*}
{*		Sortieren, die Datei-Attribute und die Pausenfunktion   *}
{*		sowie Ausgabe des Hilfe-Bildschirms bei Falscheingaben.	*}
{* Definition:	Procedure GetCommand;					*}
{************************************************************************}

Procedure GetCommand;
Var      I,J       : Integer;
         Attr      : Word;
         S         : PathStr;
         N         : NameStr;
         E         : ExtStr;

begin
   Color := True;
   DSLast:=1;
   PrntB := False;
   PrntW := False;
   PrntD := False;
   PrntF := False;
   PrntT := False;
   SortH := 0;
   SortD := False;
   SortM := False;
   Pause := False;
   AttrM := False;
   AttrF := False;
   Attrib := '???-??';
   SAttrib:= Directory + ReadOnly + Archive;
   SSearch:= False;
   Path := '';
   for I := 1 to ParamCount do begin
     S := ParamStr(I);
     SortO := False;
     AttrO := False;
     PrntO := False;
     if S[1] = SwiChar then
       for J := 2 to Length(S) do
         if SortO then begin
           SortF := True;
           case UpCase(S[J]) of
             'N': begin
                    SortH := (SortH and $0f8) + 2;
                    if SortM then begin
                      SortM:=False;
                      Inc(SortH);
                    end;
                  end;
             'D': begin
                    SortH := (SortH and $0f8) + 4;
                    if SortM then begin
                      SortM:=False;
                      Inc(SortH);
                    end;
                  end;
             'S': begin
                    SortH := (SortH and $0f8) + 6;
                    if SortM then begin
                      SortM:=False;
                      Inc(SortH);
                    end;
                  end;
             'K': begin
                    SortH := (SortH and $0e7) + $10;
                    if SortM then begin
                      SortM:=False;
                      SortH:=SortH+$08;
                    end;
                  end;
             'T': begin
                    SortH := (SortH and $09f) + $40;
                    if SortM then begin
                      SortM:=False;
                      SortH:=SortH+$20;
                    end;
                  end;
             'G': SortD := True;
             '-': SortM := True;
             ':': begin end;
           else
             Help;
             Writeln;
             WriteLn(StrInvSOp, S[J]);
             Halt(1);
           end
         end
         else if AttrO then begin
           case UpCase(S[J]) of
             'A': begin
                    AttrF := True;
                    if AttrM then begin
                      AttrM := False;
                      Attrib[6]:='-';
                    end
                    else Attrib[6]:='+';
                  end;
             'D': begin
                    AttrF := True;
                    if AttrM then begin
                      AttrM := False;
                      Attrib[5]:='-';
                    end
                    else Attrib[5]:='+';
                  end;
             'S': begin
                    AttrF := True;
                    if AttrM then begin
                      AttrM := False;
                      Attrib[3]:='-';
                    end
                    else Attrib[3]:='+';
                  end;
             'H': begin
                    AttrF := True;
                    if AttrM then begin
                      AttrM := False;
                      Attrib[2]:='-';
                    end
                    else Attrib[2]:='+';
                  end;
             'R': begin
                    AttrF := True;
                    if AttrM then begin
                      AttrM := False;
                      Attrib[1]:='-';
                    end
                    else Attrib[1]:='+';
                  end;
             '-': AttrM := True;
             ':': begin end;
           else
             Help;
             Writeln;
             WriteLn(StrInvAOp, S[J]);
             Halt(1);
           end
         end
         else if PrntO then begin
           case UpCase(S[J]) of
             'D': begin
                    PrntD := True;
                    Color := False;
                  end;
             'F': begin
                    PrntF := True;
                    Color := False;
                  end;
             'T': PrntT := True;
             'X': SSearch := True;
             ':': begin end;
           else
             Help;
             Writeln;
             WriteLn(StrInvDOp, S[J]);
             Halt(1);
           end
         end
         else
           case UpCase(S[J]) of
             'D': Color := False;
             'P': Pause := True;
             'O': SortO := True;
             'B': PrntB := True;
             'W': PrntW := True;
	     'S': UDirS := True;
             'X': PrntO := True;
             'A': begin
                    AttrO := True;
                    SAttrib:=AnyFile-VolumeId+$80;
                  end;
             '?': begin
                    Help;
                    Halt(0);
                  end;
           else
             Help;
             Writeln;
             WriteLn(StrInvOpt, S[J]);
             Halt(1);
           end
     else
       Path := S;
   end;
   Path := FExpand(Path);
   if Path[Length(Path)] <> '\' then begin
     Assign(F, Path);
     GetFAttr(F, Attr);
     if (DosError = 0) and (Attr and Directory <> 0) then
       Path := Path + '\';
   end;
   FSplit(Path, D, N, E);
   if N = '' then N := '*';
   if E = '' then E := '.*';
   Path := D + N + E;
   if UDirS then begin
     DirStack[0]:=D;
     DirStack[1]:=D;
   end;
   if PrntB then PrntW := False;
   if AttrF then begin
     SAttrib:=$80;
     TAttrib:=0;
     EAttrib:=0;
     for i:=1 to 6 do
       case Attrib[i] of
         '+': begin
                SAttrib:=SAttrib + 1 shl (i-1);
                TAttrib:=TAttrib + 1 shl (i-1);
                EAttrib:=EAttrib + 1 shl (i-1);
              end;
         '-': begin
                TAttrib:=TAttrib + 1 shl (i-1);
              end;
         '?': begin
                SAttrib:=SAttrib + 1 shl (i-1);
              end;
       end;
   end;
end;

{************************************************************************}
{* Routine:	FindVolume						*}
{************************************************************************}
{* Inhalt:	Suche nach Volume-Name und Bestimmung des Laufwerks-	*}
{*		Buchstaben						*}
{* Definition:	Procedure FindVolume;					*}
{************************************************************************}

Procedure FindVolume;
Var      FS1       : SearchRec;
         Path1     : PathStr;
         N         : NameStr;
         E         : ExtStr;
begin
   VolNam:='';
   FSplit(Path,D,N,E);
   if Pos(':',D)=2 then Path1:=Copy(D,1,3)+'*.*'
   else begin
     Path1:='\*.*';
     GetDir(0,D);
   end;
   VolChar:=D[1];
   FindFirst(Path1,$08,FS1);
   if DOSError = 0 then begin
     VolNam:=FS1.Name;
     Delete(VolNam,9,1);
   end;
end;

{************************************************************************}
{* Routine:	FindFiles						*}
{************************************************************************}
{* Inhalt:	Datei-Suche mit Datei-Attributen und Speicherung der	*}
{*		Standard-Informationen im Sortier-Array.		*}
{* Definition:	Procedure FindFiles;					*}
{************************************************************************}

Procedure FindFiles;
Var      FS        : SearchRec;
         FS1       : SearchRec;
         Path1     : PathStr;
         i         : Integer;
         N         : NameStr;
         E         : ExtStr;
begin
   Count := 0;
   if UDirS then begin
     DSFrst:=1;
     Path1:=DirStack[0]+'*.*';
     FindFirst(Path1,$10,FS1);
     while (DosError = 0) do begin
       if ((FS1.Attr and $10)=$10) and (FS1.Name[1]<>'.') then begin
         for i:=DSLast downto DSFrst do
           DirStack[i+1]:=DirStack[i];
         Inc(DSLast);
         DirStack[DSFrst]:=DirStack[0]+FS1.Name+'\';
         Inc(DSFrst);
       end;
       FindNext(FS1);
     end;     
     FSplit(Path, D, N, E);
     D:=DirStack[0];
     Path:=D + N + E;
     i:=IOResult;
   end;
   FindFirst(Path, SAttrib, FS);
   while (DosError = 0) and (Count < MaxDirSize) do begin
     if ((not AttrF) or ((FS.Attr and TAttrib) = EAttrib)) then begin
       GetMem(Dir[Count], 53);
       Move(FS.Attr, Dir[Count]^, 53);
       if (AnsiDetect and Color) or (not (PrntB or PrntW)) then GetInfo;
       Inc(Count);
     end;
     FindNext(FS);
   end;
   for i:=1 to DSLast do
     DirStack[i-1]:=DirStack[i];
   Dec(DSLast);
end;

{************************************************************************}
{* Routine:	SortFiles						*}
{************************************************************************}
{* Inhalt:	Sortierung der Dateien nach vorher gewhltem Kriterium	*}
{* Definition:	Procedure SortFiles;					*}
{************************************************************************}

procedure SortFiles;
begin
  if (Count <> 0) then
    QuickSort(0, Count - 1);
end;

{************************************************************************}
{* Routine:	PrintFiles						*}
{************************************************************************}
{* Inhalt:	Ausdruck des Verzeichnisses mit entsprechenden Zusatz-  *}
{*		Informationen und Untersttzung der Pausenfunktion.	*}
{* Definition:	Procedure PrintFiles;					*}
{************************************************************************}

Procedure PrintFiles;
Var      I, P, J   : Integer;
         Total     : Longint;
         T         : DateTime;
         N         : NameStr;
         E         : ExtStr;
         Test      : Word;
         C         : Char;

begin
   if (AnsiDetect and Color) then AnsiPrint
   else begin
     if ((not (PrntB or PrntF or PrntD)) and 
        ((not UDirF) or (not UdirS))) then begin
       Write(StrVolNam,VolChar);
       if VolNam<>'' then Writeln(StrVolVer,VolNam)
       else Writeln(StrVolNoN);
       Lines := Succ(Lines);
     end;
     if UDirS and (Count = 0) then begin
       if (not UDirF) and (DSLast = 0) then begin
         FSplit(Path,D,N,E);
         Path:=DirStack[0]+N+E;
         if not ((PrntB) or (PrntF) or (PrntD)) then begin
           WriteLn(StrDirHea, Path);
           Lines := Succ(Lines);
         end;
         WriteLn(StrNoFile);
         Lines := Succ(Lines);
       end;
       Exit;
     end
     else begin
       if not ((PrntB) or (PrntF) or (PrntD)) then begin
         WriteLn(StrDirHea, Path);
         Lines := Succ(Lines);
       end;
       if Count = 0 then begin
         WriteLn;
         WriteLn(StrNoFile);
         Exit;
       end;
       UDirF:=True;
     end;
     Total := 0;
     for I := 0 to Count-1 do begin
       with Dir[I]^ do begin
         if ((not (PrntD or PrntF)) or ((Name<>'.') and (Name <>'..'))) then begin
           if PrntB then begin
             Writeln(Name);
             Lines := Succ(Lines);
           end
           else if PrntW then begin
             Write(Name);
             if (I Mod 5) = 4 then begin
               Writeln;
               Lines := Succ(Lines);
             end
             else Write(' ':16-Length(Name));
           end
           else begin
             if (PrntD) then Write(Name)
             else if (PrntF) then Write(Name,' ':13-Length(Name))
             else begin
               P := Pos('.', Name);
               if P > 1 then begin
                 N := Copy(Name, 1, P - 1);
                 E := Copy(Name, P + 1, 3);
               end
               else begin
                 N := Name;
                 E := '';
               end;
               Write(N, ' ': 9 - Length(N), E, ' ': 4 - Length(E));
               if Attr and Directory <> 0 then Write('<DIR>   ')
               else Write(Size: 8);
               UnpackTime(Time, T);
               Write(DateStr(T):10,TimeStr(T):8);
             end;
             if FTyp=1 then begin
               Write(Kurz:5,GHor:6,' x',GVer:4,' x',GCol:4);
               if GPal>0 then Write(GPal:10)
               else Write('          ');
               Write(GPac:5);
               Write(GGSI:2);
             end;
             if FTyp=2 then begin
               Write(Kurz:5,ETit:22);
               if (Kurz='WIN ') then begin
                 Write(Hi(EVer):3,'.',Numstr(Lo(EVer),2),'  ');
                 if ((EFlg and 2)=2) then Write('3')
                 else Write(' ');
                 if ((EFlg and 4)=4) then Write('P')
                 else Write(' ');
                 if ((EFlg and 8)=8) then Write('F')
                 else Write(' ');
               end;
             end;
             if FTyp=3 then begin
               Write(Kurz:5,STit:22,SIns:4);
               if SLen > 0 then Write (SLen div 60:4,':',NumStr(SLen mod 60,2));
               if SLen < 0 then begin
                 Write ((-SLen div 600):4,':',NumStr((-SLen div 10) mod 60,2));
                 Write (NLSDat.DecPoin,(-SLen mod 10));
               end;
             end;
             if FTyp=4 then begin
               if Kurz='DBF ' then
                 Write(Kurz:5,DLen:4,StrDbfFel,DSat:6,StrDbfSat)
               else
                 Write(Kurz:5,DLen:4,StrWksCol,DSat:6,StrWksRow);
             end;
             if FTyp=5 then begin
               Write(Kurz:5);
               Write(TTit:22);
             end;
             if FTyp=6 then begin
               Write(Kurz:5,PFil:4,StrArcFil,PPro:4,' % ',PTyp);
             end;
             WriteLn;
           Lines := Succ(Lines);
           end;
           if (Pause and (Lines>=24)) then begin
             Writeln(Error,StrPreKey);
             repeat until KeyPressed;
             c:=ReadKey;
             Lines:=1;
           end;
           if (Attr and Directory) = 0 then Inc(Total, Size);
         end;
       end;
       FreeMem(Dir[I], 53);
     end;
     if (PrntW) and ((I mod 5)<>4) then Writeln;
     if not ((PrntB) or (PrntD) or (PrntF)) then begin
       WriteLn(Count:5, StrNrFile, Total, StrFilSpc,
               DiskFree(Ord(Path[1])-64), StrDskSpc);
       if DSLast>0 then WriteLn;
       Lines:=Lines+2;
     end;
   end;
end;

{************************************************************************}
{* Routine:	Hauptprogramm						*}
{************************************************************************}
{* Inhalt:	Aufruf der Programmschritte				*}
{************************************************************************}

begin
   SortF:=False;
   UDirS:=False;
   UDirF:=False;
   Assign(Output,'');
   Rewrite(Output);
   GetSwChar;
   GetCommand;
   if Pause then begin
     AssignCrt(Error);
     Rewrite(Error);
   end;
   Lines := 1;
   FindVolume;
   while DSLast>0 do begin
     FileMode:=0;
     FindFiles;
     if SortF then SortFiles;
     FileMode:=2;
     PrintFiles;
   end;
   if Pause then Close(Error);
end.
