/* CFF.H	-- user api include file for the cff library */


#ifdef __GNUC__
typedef unsigned long long  KeyItem;   /* type for a key's associated item */
#endif


typedef union 			/* 2 BYTES */
	{
		unsigned short val;
		unsigned char b[2];
} SVAL;

typedef union			/* 4 BYTES */
	{
	unsigned long a0;
	void *a1;
	struct
		{
		SVAL	lo_word;
		SVAL	hi_word;
		} a2;
	struct
		{
			unsigned int pad :28;
			unsigned int type :4;
		} a3;
	struct
		{
			unsigned char b[4];
		} a4;
} ADDR;

typedef union _stor	/* 8 BYTES */
	{
	unsigned long	a0;
	void *a1;
#ifdef __GNUC__
	KeyItem item;
#endif
	struct
		{
		unsigned short	lo_word;
		unsigned short	hi_word;
		unsigned int size :28;		/* in bytes or nibbles */
		unsigned int type :4;	    /* describes the STOR type */
		} a2;
	struct
		{
			short s0;
			short s1;
			short s2;
			short s3;
		} a3;
	struct
		{
			unsigned long	s0;
			unsigned long	s1;
		} a4;
	struct
		{
			unsigned char	b[8];
		} a5;
#ifdef __GNUC__
	struct
		{
			unsigned long long dupname :48;
			unsigned long long dupid :16;
		} a6;
#endif
	struct
		{
			unsigned int home : 30;
			unsigned int full : 2;
		} a7;
} STOR, Item;

/* DEFINITIONS FOR "a2.type */
#define STO_INACTIVE (0)
#define STO_NIL  (1)
#define STO_VALUE (2)	
#define STO_CHUNK (3)
#define STO_KEYINFO (4)
#define STO_NILCHUNK (5)
#define STO_COMPCHUNK (6)
#define STO_ALLOCATED (7)
#define STO_DELETED (8)	/* always ored with non zero */
#define STOMASK (7)

typedef struct {
	unsigned long	name;
	unsigned short	xname;
	unsigned short	id;
} DupName;

typedef struct			/* 12 BYTES */
	{
		STOR c0;
		ADDR c1;
	} CAT;
#define CATEXACT  (8)
#define CATHASH (cat.c1.a0)

typedef struct	/* 20 bytes */
	{
		STOR	stor;
		CAT		cat;
} SDB;


/* DEFINE CFF OPEN MODES */

#define F_RDONLY	(0x0001)
#define F_WRONLY	(0x0002)
#define F_RDWR		(0x0003)
#define F_CREAT		(0x0004)
#define F_TEMP		(0x0008)
#define F_UNIQ		(0x0010)
#define F_EXCL		(0x0020)
#define F_BITMAP	(0x0040)
#define F_TRUNC		(0x0080)
#define F_APPEND	(0x0100)
#define F_DELETING	(0x0200)
#define F_FILEONLY	(0x0400)
#define F_BIGDIR	(0x0800)
#define F_HUGEDIR	(0x1000)
#define F_SETUP		(0x4000)
#define F_PARENTS	(0x4000)
#define F_SORTED	(0x8000)
#define F_UNTAGGED	(0x10000)
#define F_STAT		(0x20000)	/* TRULY READONLY */

/* BUFFER RELEASE MODES */
#define R_DIRTY		(0x80000000)
#define R_CLEAN		(0x40000000)
#define R_FLUSH		(0x20000000)

/* DEFINE SOME SYSTEM CALL VALUES */
#define S_READBLK (1)
#define S_WRITEBLK (2)
#define S_GETSPACE (3)
#define S_GIVESPACE (4)
#define S_CLOSE (5)
#define S_OPEN (6)
#define S_CREATE (7)
#define S_UNLINK (8)
#define S_SEEK (9)
#define S_FLUSH (10)
#define S_CLOSETRUNC (11)

#define S_SET (100)
#define S_CUR (200)
#define S_END (300)

/* DEFINE CFF OBJECT PROPERTIES -- returned by cfobtype(void *something) */
#define OB_SHARE	(0x00000001)
#define OB_ISDIR	(0x00000002)
#define OB_BMOK		(0x00000004)
#define OB_SMOK		(0x00000008)
#define OB_MEM		(0x00000010)
#define OB_RAWDEV	(0x00000020)
#define OB_CFILE	(0x00000040)
#define OB_SETUP	(0x00000080)
#define OB_FOD		(0x00000100)
#define OB_ROOTDIR	(0x00000200)
#define OB_DIRTY	(0x00000400)
#define OB_DELCLOSE	(0x00000800)
#define OB_WRITE	(0x00001000)
#define OB_BITMAP	(0x00002000)
#define OB_XFILE	(0x00004000)
#define OB_ISNEW	(0x00008000)
#define OB_SMEM		(0x00010000)
#define OB_FILEONLY	(0x40000000)
#define OB_HASHDIR	(0x20000000)
#define OB_TREEDIR	(0x10000000)
#define OB_UNTAGGED (0x08000000)
#define OB_PREALLOC (0x01000000)

#ifndef NULL
#define NULL ((void *)0)
#endif
#ifndef EOF
#define EOF     (-1)
#endif
#define YES     (1)
#define NO      (0)
#define OK      (1)
#define NODUPS	(0)
#define OKDUPS	(1)
#define CNTDUPS (2)
#define DUPNAMES (4)

#define PREALLOC1 (8)
#define PREALLOC2 (16)
#define PREALLOC3 (32)

#define ERROR   (-1)
#define FOUND	(1)
#define NOTFOUND (0)
#define NONE	(-1)	/* no value */
#define INVALID (-4)	/* invalid value */
#define LESS	(-1)	/* a is less than b */
#define EQUAL	(0)		/* a and b are equal */
#define GREATER	(2)		/* a is greater than b */
#define	BOI	(-2)		/* beginning of index */
#define	EOI	(-3)		/* end of index */

typedef struct opninfo {
	long initial_entries;
	unsigned long bitmap_prealloc;
	long data_prealloc;
} OPNINFO;

typedef struct cfdirent {
	int d_namlen;
	char *d_name;
	unsigned long d_bytesalloc;
	unsigned long d_bytesused;
	unsigned long d_mode;
	unsigned long d_entrycnt;
	void *d_fpt;
} CFDIRENT;

/* Function codes for the cfmisc instruction */
enum CfMisc {
	CF_ALLOC,CF_USED,CF_DEPTH,CF_MARK,CF_HEAD,CF_TAIL,CF_NEXT,
	CF_PREV,CF_KEYLEN,CF_DATALEN,CF_MODBUFS,
	CF_CURBUFS,CF_SETKEYCMP,CF_SETITEMCMP,CF_SETERRFUNC,
	CF_LAZY,CF_VERYLAZY,CF_CLRLAZY,CF_ISNEW,CF_FLUSH,
	CF_FILESIZE,CF_FILEALLOC,CF_PREALLOC,CF_ALIGNMENT,
	CF_MAPSIZE,CF_ISSORTED,CF_KEY,CF_ITEM,CF_CREEP,
	CF_SETPRINTFUNC,CF_DATA
};

typedef struct cffstat {
		unsigned long	st_smhead;
		unsigned long	st_smtail;
		unsigned short	st_id;
		unsigned short	st_keysize;

		STOR		   st_dups;
		unsigned long  st_bmhead;
		unsigned long  st_bmtail;
        unsigned long  st_mode;
        short st_uid;
        short st_gid;
        long  st_mtime;
        long  st_ctime;

		unsigned long  st_highleaf;
        unsigned long  st_size;
		unsigned long  st_alloc;
		unsigned long  st_entrycnt;
		short 		   st_mapsize;
		unsigned short st_dupids;

        long  st_atime;
		long  st_filesize;
		long  st_filealloc;
		long  st_obtype;
		unsigned int st_filedups;
        long  st_ino;
        short st_blksize;
        short st_dev;
        short st_nlink;
        short st_rdev;
} CFSTAT;

/* MODE BITS */
#define M_ROOTDIR	(0x80000000)
#define M_FILEONLY	(0x40000000)
#define M_HASHDIR	(0x20000000)
#define M_TREEDIR	(0x10000000)
#define M_UNTAGGED	(0x08000000)
#define M_BITMAP	(0x04000000)
#define M_EXTRNFILE	(0x02000000)
#define M_PREALLOC	(0x01000000)
#define M_IFMT		(0x000F0000)
#define M_IFDIR		(0x00004000)
#define M_IFIFO		(0x00002000)
#define M_IFCHR		(0x00001000)
#define M_IFBLK		(0x00003000)
#define M_IFREG		(0x00008000)
#define M_IREAD		(0x00000100)
#define M_IWRITE	(0x00000080)
#define M_IEXEC		(0x00000040)


extern void *PERMCAT;
extern void *PERMINFO;
extern void *PERMFILE;

extern char *cff_version;
extern char *cff_copyright;

#ifdef __cplusplus
extern "C" {
#endif

void cfinit(char *appname, int lbufpages, char *permfile);
void cfexit();
void cfport_settestflags(int flags);

void key_hash(void *keyptr, int keysize, CAT *cat);
long rdwr_object(void *handle, void *userbuffer, long amount, int mode);
long seek_object(void *handle, long amount, int mode);

#define cfhash(a,b,c) \
key_hash(a,b,c)

int cfprintf(void *format, ...);
void cfprintbitmaps(void *something);
void cfprintentries(void *something);
void *cfopen(char *path, long mode, void *info);
void *cfsubopen(void *handle, char *name, long mode, void *info);
void *cfopen_chunk(void *handle, void *item);
void cfclose(void *handle);
int cfunlink(void *something, ... );
int cfstat(void *something, void *stbuf);
void *cfcopy(void *something_dst, void *something_src);
long cfcopy_file(void *handle_dst, void *handle_src);
int cfcopy_object(void *handle_dst, void *handle_src);
void cftotalloc(void *something, unsigned long *used, unsigned long *alloc);
void *cflocalize(void *handle, void *item);
void cfrelease(void *ptr, long mode);

#define cfread(a,b,c) \
rdwr_object(a,b,c,S_READBLK)
#define cfwrite(a,b,c) \
rdwr_object(a,b,c,S_WRITEBLK)
#define cfseek(a,b,c) \
seek_object(a,b,c)

int cfdef(char *key, char *def);
int cfsysdef(char *key, char *def);
int cfappdef(char *key, char *def);
int cfundef(char *key);
int cfsysundef(char *key); 
int cfappundef(char *key);
int cftrn(char *strn, char **newstrn);
int cfpathtrn(char *strn, char **newstrn);
void cfflush(void *handle);
void cfsync(void);
int cftruncate(void *something, unsigned long size);

int cfinsertx(void *handle,void *key,int len,void *item,int dups,void *adup);
#define cfinsert(handle,keyptr,keylen,itemptr) \
cfinsertx(handle,keyptr,keylen,itemptr,NODUPS,NULL)
#define cfinsert_dupnum(handle,keyptr,keylen,itemptr,dupnum) \
cfinsertx(handle,keyptr,keylen,itemptr,OKDUPS,dupnum)
#define cfinsert_dupname(handle,keyptr,keylen,itemptr,dupname) \
cfinsertx(handle,keyptr,keylen,itemptr,DUPNAMES,dupname)

int cffindx(void *handle, void *keyptr, int keylen, void *itemptr, void *adup);
#define cffind(handle,key,len,item) \
cffindx(handle,key,len,item,NULL)
#define cffind_dupnum(handle,key,len,item,dupnum) \
cffindx(handle,key,len,item,dupnum)
#define cffind_dupname(handle,dupname,itemptr) \
cffindx(handle,dupname,8,itemptr,(void *)0xffffffff)
#define cfreinsert(handle,key,len,item) \
cffindx(handle,key,-len,item,NULL)
#define cfreinsert_dupnum(handle,key,len,item,dupnum) \
cffindx(handle,key,-len,item,dupnum)
#define cfreinsert_dupname(handle,key,len,itemptr,dupname) \
cffindx(handle,dupname,-8,itemptr,(void *)0xffffffff)

int cffind_item(void *handle, void *key, int keylen, void *itemptr);
int cffind_mark(void *handle, void *itemptr);

#define cfdelete(a,b,c) \
cfdelete_item(a,b,c,NULL)
int cfdelete_item(void *handle, void *key, int keylen, void *itemptr);
int cfdelete_dupnum(void *handle, void *key, int keylen, long dupnum);
#define cfdelete_lastdupnum(a,b,c) \
cfdelete_dupnum(a,b,c,-1)
int cfdelete_dupname(void *handle, void *key, int keylen, void *dupname);
int cfdelete_lastdupname(void *handle, void *key, int keylen);
int cfdelete_alldupnames(void *handle, void *key, int keylen);
int cfdelete_alldupnums(void *handle, void *key, int keylen);
int cflastdupname(void *handle, void *key, int keylen, void *dupname);

long cfpush_item(void *handle, void *itemptr);
long cfpush_data(void *handle, void *datptr, int datsize);
long cfpop_item(void *handle, void *itemptr);
long cfpop_data(void *handle, void *datptr, int datsize);
long cfstackdepth(void *handle);

long cfcountdups(void *handle, void *key, int keylen);
long cfmisc(void *something, int func, ...);

void *cfopendir(void *path, long *mode);
void cfclosedir(void *it);
CFDIRENT *cfreaddir(void *it);
void cfrewinddir(void *it);
void cftelldir(void *it, STOR *entry);
void cfseekdir(void *it, STOR *entry);
long cfentrycnt(void *something);

int cfseq_dupnum(void *handle, void *key, int len, void *itemptr, int mode);
#define cfhead_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_HEAD)
#define cftail_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_TAIL)
#define cfnext_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_NEXT)
#define cfprev_dupnum(a,b,c,d) cfseq_dupnum(a,b,c,d,CF_PREV)

int cfseq_dupname(void *handle, void *key, int len, void *itemptr, int mode);
#define cfhead_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_HEAD)
#define cftail_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_TAIL)
#define cfnext_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_NEXT)
#define cfprev_dupname(a,b,c,d) cfseq_dupname(a,b,c,d,CF_PREV)


#define cfdepth(a) \
cfmisc(a, CF_DEPTH)
#define cfmark(a) \
cfmisc(a, CF_MARK)
#define cfhead(a,b) \
cfmisc(a, CF_HEAD, b)
#define cftail(a,b) \
cfmisc(a, CF_TAIL, b)
#define cfnext(a,b) \
cfmisc(a, CF_NEXT, b)
#define cfprev(a,b) \
cfmisc(a, CF_PREV, b)
#define cfkeycmp(a,b,c,d) \
default_keycmp(a,b,c,d)
#define cfitemcmp(a,b) \
default_itemcmp(a,b)
#define cfkeylen(a,b) \
cfmisc(a, CF_KEYLEN, b)
#define cfdatalen(a,b) \
cfmisc(a, CF_DATALEN, b)
#define cfbytesused(a) \
cfmisc(a, CF_USED)
#define cfbytesalloc(a) \
cfmisc(a, CF_ALLOC)
#define cfmodbufs(a) \
cfmisc(NULL, CF_MODBUFS, a)
#define cfcurbufs() \
cfmisc(NULL, CF_CURBUFS)
#define cfsetkeycmp(a,b) \
cfmisc(a, CF_SETKEYCMP, b)
#define cfsetitemcmp(a,b) \
cfmisc(a, CF_SETITEMCMP, b)
#define cfseterrfunc(a) \
cfmisc(NULL, CF_SETERRFUNC, a)
#define cfsetprintfunc(a) \
cfmisc(NULL, CF_SETPRINTFUNC, a)
#define cfisnew(a) \
cfmisc(a,CF_ISNEW)
void cfpflags(char *name, void *handle);
long cfobtype(void *handle);
#define cfsetverylazy(a) \
cfmisc(a, CF_LAZY)
#define cfsetlazy(a) \
cfmisc(a, CF_VERYLAZY)
#define cfclrlazy(a) \
cfmisc(a, CF_CLRLAZY)
#define cffilesize(a) \
cfmisc(a, CF_FILESIZE)
#define cffilealloc(a) \
cfmisc(a, CF_FILEALLOC)
#define cfprealloc(a) \
cfmisc(a, CF_PREALLOC)
#define cfalignment(a) \
cfmisc(a, CF_ALIGNMENT)
#define cfmapsize(a) \
cfmisc(a, CF_MAPSIZE)
#define cfissorted(a) \
cfmisc(a, CF_ISSORTED)
#define cfkey(ccb,key,len) \
cfmisc(ccb, CF_KEY, key, len)
#define cfitem(ccb, item) \
cfmisc(ccb, CF_ITEM, item)
#define cfdata(ccb, buf, len) \
cfmisc(ccb, CF_DATA, buf, len)

void *cfgetspace(void *handle, long amount, void *addr);
int cfretspace(void *handle, void *addr);

void *cfputx(void *handle, void *keyptr, int keylen, void *itemptr,
					int dupflg, void *adup, void *bufptr, long buflen);
#define cfput(handle,key,len,buf,buflen,itemptr) \
cfputx(handle,key,len,itemptr,NODUPS,NULL,buf,buflen)
#define cfput_dupnum(handle,key,len,buf,buflen,itemptr,dupnum) \
cfputx(handle,key,len,itemptr,OKDUPS,dupnum,buf,buflen)
#define cfput_dupname(handle,key,len,buf,buflen,itemptr,dupname) \
cfputx(handle,key,len,itemptr,DUPNAMES,dupname,buf,buflen)
#define cfreput(handle,key,len,buf,buflen,itemptr) \
cfputx(handle,key,len,itemptr,NODUPS,NULL,buf,-buflen)
#define cfreput_dupnum(handle,key,len,buf,buflen,itemptr,dupnum) \
cfputx(handle,key,len,itemptr,OKDUPS,dupnum,buf,-buflen)
#define cfreput_dupname(handle,key,len,buf,buflen,itemptr,dupname) \
cfputx(handle,key,len,itemptr,DUPNAMES,dupname,buf,-buflen)


int cfgetx(void *handle, void *keyptr, int keylen,
					void *bufptr, long buflen, void *adup);
#define cfget(handle,key,len,buf,buflen) \
cfgetx(handle,key,len,buf,buflen,NULL)
#define cfget_dupnum(handle,key,len,buf,buflen,dupnum) \
cfgetx(handle,key,len,buf,buflen,dupnum)
#define cfget_dupname(handle,dupname,buf,buflen) \
cfgetx(handle,dupname,8,buf,buflen,(void *)0xffffffff)


void *malloc(size_t);
void free(void *);
unsigned mallocsize(const void *);

#if 0 /* some include files use size_t for these functions */
void *calloc(unsigned, unsigned);
void *realloc(void *, unsigned);
void *memalign(unsigned, unsigned);
void *valloc(unsigned);
#endif

void *mallocC(long, unsigned);
void *callocC(long, unsigned, unsigned);
void *reallocC(long, void *, unsigned);
void *vallocC(long, unsigned);
void *memalignC(long, unsigned, unsigned);
void freeC(long, void *);
void freecat(long);
void *cfmalloc(unsigned, STOR *);
void cffree(STOR *);

#ifdef __cplusplus
}
#endif

