/* BLOBTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

#define CLOCKS_PER_SECOND 1000000L

/* TEST CHOICES */
#define PFLAGS 0
#define MEMFILE 1
#define EXTDMEM 1
#define CFFFILE 1

extern int errno;
extern long clock();
extern int rand();
OPNINFO info;

static void blob_test(void *hd);

void
main()
{
void *hxxx;
void *huniq;
void *hcfile;
void *hsxxx;
void *hcxxx;

	cfport_settestflags(1);
	cfinit("blobtest",1024,NULL);
	cfprintf("TEST OF LARGE CHUNK ACCESS -- 128K per chunk\n");

	
#if MEMFILE
	cfprintf("MEMORY FILE\n");
	hxxx = cfopen("MEMORY/XXX",F_RDWR|F_CREAT,NULL);
	if(!hxxx) {
		cfprintf("ERROR: create XXX err=%d\n", errno);
		exit(0);
	}
	huniq = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, &info);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxxx", hxxx);
	cfpflags("huniq", huniq);
#endif
	blob_test(huniq);
cfprintf("NOW CLOSING\n");
	cfclose(huniq);
#endif /* MEMFILE */

#if EXTDMEM
	cfprintf("EXTDMEM FILE\n");
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hsxxx) {
		cfprintf("ERROR: create EXTDMEM/XXX err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hsxxx", hsxxx);
#endif
	cfsetlazy(hsxxx);
	blob_test(hsxxx);
cfprintf("NOW CLOSING\n");
	cfclose(hsxxx);

	cfprintf("REOPEN EXTDMEM FILE\n");	
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX err=%d\n", errno);
		exit(0);
	}
	cfsetlazy(hsxxx);
	blob_test(hsxxx);
cfprintf("NOW CLOSING\n");
	cfunlink(hsxxx, NULL);
#endif /* EXTDMEM */

#if CFFFILE
	cfprintf("CFF DISK FILE\n");
	hcfile = cfopen("testfile.cff", F_RDWR|F_CREAT, NULL);
	if(!hcfile) {	
		cfprintf("ERROR: create testfile.cff err=%d\n", errno);
		exit(0);
	}
	hcxxx = cfopen("testfile.cff/XXX",
						F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hcxxx) {	
		cfprintf("ERROR: create testfile.cff/XXX err=%d\n", errno);
		exit(0);
	}
#if 0
	cfpflags("hcfile", hcfile);
	cfpflags("hcxxx", hcxxx);
#endif
	cfsetlazy(hcxxx);
	blob_test(hcxxx);
cfprintf("NOW CLOSING\n");
	cfclose(hcxxx);
	cfclose(hcfile);

	cfprintf("REOPEN CFF DISK FILE\n");	
	hcfile = cfopen("testfile.cff", F_RDWR, NULL);
	if(!hcfile) {	
		cfprintf("ERROR: reopen testfile.cff err=%d\n", errno);
		exit(0);
	}
	hcxxx = cfopen("testfile.cff/XXX", F_RDWR, NULL);
	if(!hcxxx) {	
		cfprintf("ERROR: reopen testfile.cff/XXX err=%d\n", errno);
		exit(0);
	}
	cfsetlazy(hcxxx);
	blob_test(hcxxx);
cfprintf("NOW CLOSING\n");
	cfclose(hcxxx);
	cfclose(hcfile);
	cfunlink("testfile.cff");
#endif /* CFF FILE */

	cfexit();
} /* MAIN */


static void
blob_test(void *hd)
{
long i, start, end, diff;
int result;

	if(cfisnew(hd)) {
		start = clock();
		for(i = 0; i < 20; ++i)
		{
		STOR addr;
		  if((result=cfinsert(hd, &i, 4, cfgetspace(hd, 128*1024, &addr))) < OK)
		  {
			cfprintf("CFINSERT FAILED at i=%d result=%d\n", i, result);
				break;
		  }
		  else 
		  { /* Put some data in the chunk */
		  long *lp = cflocalize(hd, &addr);
			if(lp == NULL) {
				cfprintf("INSERT FAILED TO LOCALIZE CHUNK i=%d loc=%lx\n", i, addr.a0);
			}
			lp[0] = i;
			lp[100] = (100<<8)+i;
			lp[32000] = (32000<<8)+i;
			cfrelease(lp, R_DIRTY);
		  }
			if(i == 0)
				cfprintf("  First chunk at loc=%lx size=%lu\n", addr.a0, addr.a2.size);
		}			
		end = clock();
		diff = end - start;
		diff /= CLOCKS_PER_SECOND/10;
		if(diff == 0) diff = 1;
		cfprintf("  CHUNKCREATES PER SEC = %ld\n", (i*10) / diff);
	}


	/* FIND CHUNKS */
	start = clock();
	for(i = 0; i < 20; ++i)
	{
	STOR addr;
	  if((result=cffind(hd, &i, 4, &addr)) < FOUND)
	  {
		cfprintf("CFFIND FAILED at i=%d result=%d\n", i, result);
			break;
	  }
	  else 
	  { /* Check the data in the chunk */
	  long *lp = cflocalize(hd, &addr);
		if(lp == NULL) {
			cfprintf("FIND FAILED TO LOCALIZE CHUNK i=%d loc=%lx size=%lu\n",
			i, addr.a0, addr.a2.size);
			break;
		}
		if(		lp[0] != i
			||	lp[100] != (100<<8)+i
			||	lp[32000] != (32000<<8)+i)
			cfprintf("BAD DATA IN CHUNK at loc=%lx i=%d\n", addr.a0, i);
		cfrelease(lp, R_CLEAN);
	  }
	}			
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  CHUNKACCESSES PER SEC = %ld\n", (i*10) / diff);


	/* RDWR CHUNKS */
	start = clock();
	for(i = 0; i < 20; ++i)
	{
	STOR addr;
	void *handle;
	long buf[1024];
	long j,k;
	  if((result=cffind(hd, &i, 4, &addr)) < FOUND)
	  {
		cfprintf("CFFIND FAILED at i=%d result=%d\n", i, result);
			break;
	  }
	  if(!(handle = cfopen_chunk(hd, &addr)))
	  {
	  	cfprintf("COULD NOT OPEN CHUNK at loc=%lx i=%d\n", addr.a0, i);
	  	break;
	  }
	  for(j = 0; j < (128*1024)/sizeof(buf); ++j)
	  {
		for(k = 0; k < 1024; ++k)
		{
			buf[k] = (((j*1024)+k)<<8)+i;
		}
		if((result = cfwrite(handle, buf, sizeof(buf))) != sizeof(buf)) {
			cfprintf("WRITE ERROR = %d at i=%d j=%d k=%d\n", result,i,j,k);
			break;
		}
	  }
	  cfseek(handle, 0, S_SET);
	  for(j = 0; j < (128*1024)/sizeof(buf); ++j)
	  {
		if((result = cfread(handle, buf, sizeof(buf))) == sizeof(buf)) {
			for(k = 0; k < 1024; ++k)
			{
				if(buf[k] != (((j*1024)+k)<<8)+i) {
					cfprintf("BAD DATA in RDWR chunk at i=%d j=%d k=%d\n", i,j,k);
					break;
				}
			}
		} else {
			cfprintf("READ ERROR = %d at i=%d j=%d k=%d\n", result,i,j,k);
			break;
		}
	  }
	  cfclose(handle);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  CHUNKRDWR BYTES PER SEC = %ld\n", (i*128*1024*10) / diff);
}

