/* COPYEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */


#include <stdlib.h>
#include "../cff.h"

static void test1(void);
static void test2(void);
static void test3(void);

void
main()
{

	cfport_settestflags(1);
	cfinit("copytest",512,NULL);

	cfprintf("TEST THE COPY FUNCTION\n");

	test1();
	test2();
	test3();

	cfexit();
}
static void
test1()
{
void *h1, *h2, *h3;
long i, err;
long buf[50000];

	cfprintf("  Begin test1  -- file property\n");
	if((h1 = cfopen("EXTDMEM/testfile", F_RDWR|F_CREAT|F_TEMP, NULL)) == NULL)
	{
		cfprintf("Failed to open first testfile\n");
		return;
	}

	for(i = 0; i < 50000; ++i)
		buf[i] = i;

	if((err = cfwrite(h1, buf, sizeof(buf))) != sizeof(buf))
	{
		cfprintf("First buffer failed to write err=%d\n", err);
		cfclose(h1);
		return;
	}

	if((h2 = cfcopy("EXTDMEM/newfile", h1)) == NULL)
	{
		cfprintf("Object copy #1 failed\n");
		cfclose(h1);
		return;
	}
	cfclose(h1);

	cfseek(h2, 0, S_SET);
	for(i = 0; i < 50000; ++i)
	{
	long result;
		if((err = cfread(h2, &result, sizeof(long))) != sizeof(long))
		{
			cfprintf("Read #1 failed at i=%d err=%d\n", i, err);
			break;
		}
		else if(result != i) {
			cfprintf("File read #1 failed at i=%d result=%d\n", i, result);
			break;
		}
	}

	if((h1 = cfopen("tempfile.xxx", F_RDWR|F_CREAT|F_TEMP, NULL)) == NULL)
	{
		cfprintf("Failed to open tempfile.xxx\n");
		cfunlink(h2, NULL);
		return;
	}

	for(i = 0; i < 50000; ++i)
		buf[i] = 50000 - i;

	if((err = cfwrite(h1, buf, sizeof(buf))) != sizeof(buf))
	{
		cfprintf("Write #2 failed err=%d\n", err);
		cfclose(h1);
	}


	if((h2 = cfcopy(h2, h1)) == NULL)
	{
		cfprintf("Failed to copy from tempfile.xxx to EXTDMEM/newfile\n");
		cfclose(h1);
		return;
	}
	cfclose(h1);

	cfseek(h2, 0, S_SET);
	for(i = 50000; i > 0; --i)
	{
	long result;
		if((err = cfread(h2, &result, sizeof(long))) != sizeof(long))
		{
			cfprintf("Read #2 failed at i=%d err=%d\n", i, err);
			return;
		}
		if(result != i) {
			cfprintf("File read #2 failed at i=%d result=%d\n", i, result);
			break;
		}
	}


	cfclose(cfcopy("testfile.cff", h2));
	cfunlink(h2, NULL);

	if((h3 = cfopen("testfile.cff", F_RDWR, NULL)) == NULL)
	{
		cfprintf("Failed to open testfile.cff\n");
		return;
	}
	for(i = 50000; i > 0; --i)
	{
	long result;
		if((err = cfread(h3, &result, sizeof(long))) != sizeof(long))
		{
			cfprintf("Read #3 failed at i=%d\n", i);
			break;
		}
		if(result != i) {
			cfprintf("File read #3 failed at i=%d result=%d\n", i, result);
			break;
		}
	}	


	if((h1 = cfcopy("MEMORY/afile", h3)) == NULL)
	{
		cfprintf("Failed to copy to MEMORY/afile\n");
		cfunlink(h3, NULL);
		return;
	}
	for(i = 50000; i > 0; --i)
	{
	long result;
		if((err = cfread(h1, &result, sizeof(long))) != sizeof(long))
		{
			cfprintf("Read #4 failed at i=%d\n", i);
			break;
		}
		if(result != i) {
			cfprintf("File read #4 failed at i=%d result=%d\n", i, result);
			break;
		}
	}	
	cfunlink(h3, NULL);
	cfunlink(h1, NULL);
	cfprintf("  End test1\n");

}
static void
test2()
{
void *h1, *h2, *h3, *h4;
OPNINFO info;
short buf[16];
DupName dupname3, dupname4;
int i,j;
unsigned long alloc, used;

	cfprintf("  Begin test2 -- complex objects\n");
	cftotalloc("EXTDMEM/", &used, &alloc);
	cfprintf("  EXTDMEM bytesalloc=%d bytesused=%d\n", alloc*1000, used*1000);
	if(!(h1 = cfopen("MEMORY/tfile", F_RDWR|F_CREAT|F_SORTED|F_TEMP, NULL)))
	{
		cfprintf("Failed to open sorted memory file.\n");
		return;
	}
	info.initial_entries = 10000;
	info.bitmap_prealloc = 32*10000;
	info.data_prealloc = 32;
	if(!(h2 = cfopen("MEMORY/hfile", F_RDWR|F_CREAT|F_BITMAP|F_TEMP, &info)))
	{
		cfprintf("Failed to open bitmapped memory file.\n");
		return;
	}
	cfprintf("  Push data to hash and tree objects.\n");
	for(i = 0; i < 20; ++i)
	{
		for(j = 0; j < 16; ++j)
			buf[j] = i;
		if(cfpush_data(h1, buf, 32) == ERROR)
			cfprintf("Push h1 data failed at i=%d\n", i);
		if(cfpush_data(h2, buf, 32) == ERROR)
			cfprintf("Push h2 data failed at i=%d\n", i);
	}
	cfprintf("    Put a lot of data to hash and tree objects, using dupnames.\n");
	for(i = 0; i < 3000; ++i)
	{
		for(j = 0; j < 16; ++j)
			buf[j] = i;
		if(cfput_dupname(h1, "address", 7, buf, 32, NULL, NULL) == NULL)
			cfprintf("Put data to treedir failed at i=%d\n", i);
		if(cfput_dupname(h2, "address", 7, buf, 32, NULL, NULL) == NULL)
			cfprintf("Put data to hashdir failed at i=%d\n", i);
	}
	cfprintf("    Tree object alloc=%d used=%d.\n", cfbytesalloc(h1), cfbytesused(h1));
	cfprintf("    Copy tree object to extended memory.\n");
	if(!(h3 = cfcopy("EXTDMEM/tfile", h1))) {
		cfprintf("Failed to copy tree object.\n");
	}
	cftotalloc("EXTDMEM/", &used, &alloc);
	cfprintf("    EXTDMEM bytesalloc=%d bytesused=%d\n", alloc*1000, used*1000);
	cfprintf("    Hash object alloc=%d used=%d.\n", cfbytesalloc(h2), cfbytesused(h2));
	cfprintf("    Copy hash object to extended memory.\n");
	if(!(h4 = cfcopy("EXTDMEM/hfile", h2))) {
		cfprintf("Failed to copy hash object.\n");
	}
	cftotalloc("EXTDMEM/", &used, &alloc);
	cfprintf("    EXTDMEM bytesalloc=%d bytesused=%d\n", alloc*1000, used*1000);

	if(cfcopy("tfile.cff", h1) != NULL) {
		cfprintf("ERROR: No error when copy of sorted directory to tfile.cff\n");
	}
#if 1
	cfprintf("    entrycnt orig tree=%d hash=%d\n", cfentrycnt(h1), cfentrycnt(h2));
	cfprintf("    entrycnt copy tree=%d hash=%d\n", cfentrycnt(h3), cfentrycnt(h4));
	cfprintf("    original size of tree object = %d copied size=%d\n",
		cfbytesalloc(h1), cfbytesalloc(h3));
	cfprintf("    original size of hash object = %d copied size=%d\n",
		cfbytesalloc(h2), cfbytesalloc(h4));
#endif

	cfprintf("    Retrieve pushed data from copied objects.\n");
	for(i = 19; i >= 0; --i)
	{
		if(cfpop_data(h3, buf, 32) == ERROR)
			cfprintf("Popdata for hash failed at i=%d\n");
		for(j = 0; j < 16; ++j) {
			if(buf[j] != i) {
				cfprintf("Data for hash pop failed at i=%d j=%d data=%d\n",i,j,buf[j]);
				break;
			}
		}
		if(cfpop_data(h4, buf, 32) == ERROR)
			cfprintf("Popdata for tree failed at i=%d\n");
		for(j = 0; j < 16; ++j) {
			if(buf[j] != i) {
				cfprintf("Pop data for tree failed at i=%d j=%d data=%d\n",i,j,buf[j]);
				break;
			}
		}
	}
	cflastdupname(h3, "address", 7, &dupname3);
	cflastdupname(h4, "address", 7, &dupname4);
	cfprintf("    Retrieve lots of dupname data from copied objects.\n");
	for(i = 2999; i >= 0; --i)
	{
		if(cfget_dupname(h3, &dupname3, buf, 32) < FOUND) {
			cfprintf("Get dupname data tree failed at i = %d\n", i);
		}
		else {
			for(j = 0; j < 16; ++j) {
				if(buf[j] != i) {
					cfprintf("Data for tree wrong at i=%d j=%d data=%d\n", i, j, buf[j]);
					break;
				}
			}
		}
		if(cfget_dupname(h4, &dupname4, buf, 32) < FOUND) {
			cfprintf("Get dupname data hash failed at i = %d\n",i);
		}
		else {
			for(j = 0; j < 16; ++j) {
				if(buf[j] != i) {
					cfprintf("Data for hash wrong at i=%d j=%d data=%d\n",i, j, buf[j]);
					break;
				}
			}
		}
		--dupname3.name;
		--dupname4.name;
	}
	cfclose(h1);
	cfclose(h2);
	cfunlink(h3, NULL);
	cfunlink(h4, NULL);
	cfprintf("  End test2\n");
}
static void
test3()
{
void *h1, *h2;

	cfprintf("  Begin test3 -- myfile.cff (retest with permtest)\n");
	if(cfentrycnt("myfile.cff") == ERROR)
	{
		cfprintf("The file 'myfile.cff' does not exist.\nRun 'permtest' to create it.\n");
		return;
	}

#if 0
{
long used, alloc;
	cfprintf("    MYFILE.CFF BEFORE COPY\n");
	cftotalloc("myfile.cff", &used, &alloc);
	cfprintf("    myfile.cff alloc=%lu used=%lu\n", alloc, used);
	cfprintf("    entrycnt=%d\n", cfentrycnt("myfile.cff"));
	cfprintbitmaps("myfile.cff");
}
#endif

	if((h1 = cfcopy("MEMORY/myfile", "myfile.cff")) != NULL)
	{
#if 0
{
long used, alloc;
		cftotalloc("MEMORY/myfile", &used, &alloc);
		cfprintf("    MEMORY/myfile alloc=%lu used=%lu\n", alloc, used);
		cfprintf("    entrycnt=%d\n", cfentrycnt("MEMORY/myfile"));
		cfprintbitmaps(h1);
}
#endif
		if((h2 = cfcopy("myfile.cff", h1)) != NULL)
		{
			cfunlink(h1, NULL);
#if 0
{
long used, alloc;
			cfprintf("    MYFILE.CFF BEFORE CLOSING\n");
			cftotalloc(h2, &used, &alloc);
			cfprintf("    OPEN myfile.cff alloc=%lu used=%lu\n", alloc, used);
			cfprintf("    entrycnt=%d\n", cfentrycnt("myfile.cff"));
			cfprintbitmaps(h2);
}
#endif
			cfclose(h2);
#if 0
{
long used, alloc;
			cfprintf("    MYFILE.CFF AFTER CLOSING\n");
			cftotalloc("myfile.cff", &used, &alloc);
			cfprintf("    myfile.cff alloc=%lu used=%lu\n", alloc, used);
			cfprintf("    entrycnt=%d\n", cfentrycnt("myfile.cff"));
			cfprintbitmaps("myfile.cff");

}
#endif
		} else cfprintf("Failed to copy memory to %s\n", "myfile.cff");
	} else cfprintf("Failed to copy %s to memory.\n", "myfile.cff");
	cfprintf("  End test3\n");
}

