/* DATATEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

#define CLOCKS_PER_SECOND 1000000L

/* TEST CHOICES */
#define PFLAGS 0
#define MEMFILE 1
#define EXTDMEM 1
#define DOHASH 1
#define DOTREE 1

extern int errno;
extern long clock();
extern int rand();
static void data_test1(void *hd, void *hd1);
static void data_test2(void *hd, void *hd1);

OPNINFO info;

void
main()
{
void *hxxx;
void *huniq;
void *huniq1;
void *huniq2;
void *huniq3;
void *hsxxx;
void *hsxxx1;
void *hsxxx2;
void *hsxxx3;

	cfport_settestflags(1);
	cfinit("datatest",512,NULL);
	cfprintf("KEYED DATA STORAGE -- 128 bytes\n");

	/* SET UP PREALLOC FOR THE HASH DIRECTORIES */

#if MEMFILE
	/* EXTRANEOUS DIRECTORY just to add flavor */
	cfprintf("MEMORY FILE\n");
	hxxx = cfopen("MEMORY/XXX",F_RDWR|F_CREAT,NULL);
	if(!hxxx) {
		cfprintf("ERROR: create XXX err=%d\n", errno);
		exit(0);
	}

	/* HASH DIRECTORY WITH PREALLOC OF MAPS AND DATA */
	info.initial_entries = 1000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 128;
	huniq = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, &info);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE0 err=%d\n", errno);
		exit(0);
	}

	/* TREE DIRECTORY no prealloc */
	huniq1 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_SORTED, NULL);
	if(!huniq1) {
		cfprintf("ERROR: create UNIQUE TEMP FILE1 err=%d\n", errno);
		exit(0);
	}
	/* HASH DIRECTORY WITH PREALLOC OF MAPS AND DATA */
	info.initial_entries = 1000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 128;
	huniq2 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, &info);
	if(!huniq2) {
		cfprintf("ERROR: create UNIQUE TEMP FILE2 err=%d\n", errno);
		exit(0);
	}
	/* TREE DIRECTORY no prealloc */
	huniq3 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_SORTED, NULL);
	if(!huniq3) {
		cfprintf("ERROR: create UNIQUE TEMP FILE3 err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxxx", hxxx);
	cfpflags("huniq", huniq);
	cfpflags("huniq1", huniq1);
	cfpflags("huniq2", huniq2);
	cfpflags("huniq3", huniq3);
#endif

	cfsetverylazy(huniq);
	cfsetverylazy(huniq1);
	data_test1(huniq, huniq1);

	cfsetverylazy(huniq2);
	cfsetverylazy(huniq3);
	data_test2(huniq2, huniq3);

cfprintf("NOW CLOSING\n");
	cfclose(huniq);
	cfclose(huniq1);
	cfclose(huniq2);
	cfclose(huniq3);
#endif /* MEMFILE */


#if EXTDMEM
	cfprintf("EXTDMEM FILE\n");

	/* HASH DIRECTORY WITH PREALLOC OF MAPS ONLY */
	info.initial_entries = 1000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 0;
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hsxxx) {
		cfprintf("ERROR: create EXTDMEM/XXX err=%d\n", errno);
		exit(0);
	}

	/* TREE DIRECTORY no prealloc */
	hsxxx1 = cfopen("EXTDMEM/XXX1", F_RDWR|F_CREAT|F_SORTED, NULL);
	if(!hsxxx1) {
		cfprintf("ERROR: create EXTDMEM/XXX1 err=%d\n", errno);
		exit(0);
	}

	/* HASH DIRECTORY WITH PREALLOC OF MAPS and DATA */
	info.initial_entries = 1000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 128;
	hsxxx2 = cfopen("EXTDMEM/XXX2", F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hsxxx2) {
		cfprintf("ERROR: create EXTDMEM/XXX2 err=%d\n", errno);
		exit(0);
	}

	/* TREE DIRECTORY no prealloc */
	hsxxx3 = cfopen("EXTDMEM/XXX3", F_RDWR|F_CREAT|F_SORTED, NULL);
	if(!hsxxx3) {
		cfprintf("ERROR: create EXTDMEM/XXX3 err=%d\n", errno);
		exit(0);
	}

#if PFLAGS
	cfpflags("hsxxx", hsxxx);
	cfpflags("hsxxx1", hsxxx1);
	cfpflags("hsxxx2", hsxxx2);
	cfpflags("hsxxx3", hsxxx3);
#endif
#if 0
	cfsetverylazy(hsxxx);
	cfsetverylazy(hsxxx1);
#endif
	data_test1(hsxxx, hsxxx1);

	cfsetverylazy(hsxxx2);
	cfsetverylazy(hsxxx3);
	data_test2(hsxxx2, hsxxx3);

cfprintf("NOW CLOSING\n");
	cfclose(hsxxx);
	cfclose(hsxxx1);
	cfclose(hsxxx2);
	cfclose(hsxxx3);

	cfprintf("REOPEN EXTDMEM FILE\n");	
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX err=%d\n", errno);
		exit(0);
	}
	hsxxx1 = cfopen("EXTDMEM/XXX1", F_RDWR, NULL);
	if(!hsxxx1) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX1 err=%d\n", errno);
		exit(0);
	}
	hsxxx2 = cfopen("EXTDMEM/XXX2", F_RDWR, NULL);
	if(!hsxxx2) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX2 err=%d\n", errno);
		exit(0);
	}
	hsxxx3 = cfopen("EXTDMEM/XXX3", F_RDWR, NULL);
	if(!hsxxx3) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX3 err=%d\n", errno);
		exit(0);
	}
#if 0
	cfsetverylazy(hsxxx);
	cfsetverylazy(hsxxx1);
#endif
	data_test1(hsxxx,hsxxx1);

	cfsetverylazy(hsxxx2);
	cfsetverylazy(hsxxx3);
	data_test2(hsxxx2,hsxxx3);

cfprintf("NOW UNLINKING\n");
	cfunlink(hsxxx, NULL);
	cfunlink(hsxxx1, NULL);
	cfunlink(hsxxx2, NULL);
	cfunlink(hsxxx3, NULL);
#endif /* EXTDMEM */

	cfexit();
} /* END: MAIN */

char *lkey1 = "this is a long key";
static long buf[32];
static Item loc;
static Item dupval;

static void
data_test1(void *hd, void *hd1)
{
long i, start, end, diff, result;
long varkey[32];

	cfprintf("Begin data_test1 -- 128 bytes per item\n");

#if 0
cfprintf("BEFORE\n");
print_entries(hd1);
print_all_bitmaps(hd1);
#endif


#if DOHASH == 1

	start = clock();
	for (i = 0; i < 100; ++i)
	{
		buf[0] = i+6;
		buf[31] = i+9;
		if(!(cfput_dupnum(hd, lkey1, strlen(lkey1), buf, 128, &loc, &dupval))) {
			cfprintf("PUTDATA dupnum hash failed at i=%d\n", i);
			break;
		}
		if(dupval.a0 != i+1)
			cfprintf("PUTDATA dupnum hash dupval=%d should be %d\n", dupval.a0, i+1);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUTDATA dupnum hash PER SEC = %ld\n", (i*10) / diff);

	start = clock();
	for (i = 0; i < 100; ++i)
	{
		dupval.a0 = i;
		if((result = cfget_dupnum(hd, lkey1, strlen(lkey1), buf, 128, &dupval)) < FOUND) {
			cfprintf("GETDATA dupnum hash failed result = %d\n", result);
			break;
		}
		if(buf[0] != i+6 || buf[31] != i+9)
			cfprintf("GETDATA dupnum hash returned wrong value %d should be %d\n",
			buf[0], i+6);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GETDATA dupnum hash PER SEC = %ld\n", (i*10) / diff);

	start = clock();
	for (i = 99; i >= 0; --i)
	{

		if((result = cfdelete_dupnum(hd, lkey1, strlen(lkey1), i)) != OK) {
			cfprintf("DELETE dupnum hash failed i=%d result = %d\n", i, result);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE dupnum hash PER SEC = %ld\n", (100*10) / diff);

	/* LONG KEY W/CHANGES */
	strcpy((char *)varkey, lkey1);	
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		buf[0] = i+11;
		buf[31] = i+23;
		++varkey[0];
		if(!(cfput(hd, varkey, 16, buf, 128, &loc))) {
			cfprintf("PUTDATA longkey hash failed at i=%d\n", i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUTDATA longkey hash PER SEC = %ld\n", (i*10) / diff);


	strcpy((char *)varkey, lkey1);	
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfget(hd, varkey, 16, buf, 128)) != FOUND) {
			cfprintf("GETDATA longkey hash failed result = %d i=%d x=%lx\n", result, i, varkey[0]);
			break;
		}
		if(buf[0] != i+11 || buf[31] != i+23)
			cfprintf("GETDATA longkey hash returned wrong value %d should be %d\n",
			buf[0], i+11);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GETDATA longkey hash PER SEC = %ld\n", (i*10) / diff);

	strcpy((char *)varkey, lkey1);
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfdelete(hd, varkey, 16)) != OK) {
			cfprintf("DELETE longkey hash failed result = %d i=%d\n", result, i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE longkey hash PER SEC = %ld\n", (i*10) / diff);


	/* SHORT KEY W/CHANGES */
	start = clock();
	varkey[0] = 1;
	varkey[1] = 1;
	for (i = 0; i < 1000; ++i)
	{
		buf[0] = i+16;
		buf[31] = i+13;
		++varkey[0];
		if(!(cfput(hd, varkey, 8, buf, 128, &loc))) {
			cfprintf("PUTDATA shortkey hash failed at i=%d\n", i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUTDATA shortkey hash PER SEC = %ld\n", (i*10) / diff);


	varkey[0] = 1;
	varkey[1] = 1;
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfget(hd, varkey, 8, buf, 128)) != FOUND) {
			cfprintf("GETDATA shortkey hash failed result = %d i=%d\n", result, i);
			break;
		}
		if(buf[0] != i+16 || buf[31] != i+13)
			cfprintf("GETDATA shortkey hash returned wrong value %d should be %d\n",
			buf[0], i+16);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GETDATA shortkey hash PER SEC = %ld\n", (i*10) / diff);

	varkey[0] = 1;
	varkey[1] = 1;
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfdelete(hd, varkey, 8)) != OK) {
			cfprintf("DELETE shortkey hash failed result = %d i=%d\n", result,i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE shortkey hash PER SEC = %ld\n", (i*10) / diff);

#endif
#if DOTREE == 1

	start = clock();
	for (i = 0; i < 100; ++i)
	{
		buf[0] = i+45;
		buf[31] = i+93;
		if(!(cfput_dupnum(hd1, lkey1, strlen(lkey1), buf, 128, &loc, &dupval))) {
			cfprintf("PUTDATA dupnum tree failed at i=%d\n", i);
			break;
		}
		if(dupval.a0 != i+1)
			cfprintf("PUTDATA dupnum tree dupval=%d should be %d\n", dupval.a0, i+1);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUTDATA dupnum tree PER SEC = %ld\n", (i*10) / diff);

	start = clock();
	for (i = 0; i < 100; ++i)
	{
		dupval.a0 = i;
		if((result = cfget_dupnum(hd1, lkey1, strlen(lkey1), buf, 128, &dupval)) < FOUND) {
			cfprintf("GETDATA dupnum tree failed result = %d\n", result);
			break;
		}
#if 0	/* THIS WILL NOT ALWALYS BE TRUE -- SORTED DIRECTORIES sort the items */
		if(buf[0] != i+45 || buf[31] != i+93)
			cfprintf("GETDATA dupnum tree returned wrong value %d should be %d\n",
			buf[0], i+45);
#endif
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GETDATA dupnum tree PER SEC = %ld\n", (i*10) / diff);

	start = clock();
	for (i = 99; i >=0; --i)
	{
		if((result = cfdelete_dupnum(hd1, lkey1, strlen(lkey1), i)) != OK) {
			cfprintf("DELETE dupnum tree i=%d failed result = %d\n", i, result);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE dupnum tree PER SEC = %ld\n", (100*10) / diff);

	/* LONG KEY W/CHANGES */
	strcpy((char *)varkey, lkey1);	
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		buf[0] = i+76;
		buf[31] = i+37;
		++varkey[0];
		if(!(cfput(hd1, varkey, 16, buf, 128, &loc))) {
			cfprintf("PUTDATA longkey tree failed at i=%d\n", i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUTDATA longkey tree PER SEC = %ld\n", (i*10) / diff);


	strcpy((char *)varkey, lkey1);	
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfget(hd1, varkey, 16, buf, 128)) != FOUND) {
			cfprintf("GETDATA longkey tree failed result = %d i=%d\n", result,i);
			break;
		}
		if(buf[0] != i+76 || buf[31] != i+37)
			cfprintf("GETDATA longkey tree returned wrong value %d should be %d\n",
			buf[0], i+76);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GETDATA longkey tree PER SEC = %ld\n", (i*10) / diff);

	strcpy((char *)varkey, lkey1);
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfdelete(hd1, varkey, 16)) != OK) {
			cfprintf("DELETE longkey tree failed result = %d i=%d\n", result,i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE longkey tree PER SEC = %ld\n", (i*10) / diff);


	/* SHORT KEY W/CHANGES */
	start = clock();
	varkey[0] = 1;
	varkey[1] = 1;
	for (i = 0; i < 1000; ++i)
	{
		buf[0] = i+25;
		buf[31] = i+35;
		++varkey[0];
		if(!(cfput(hd1, varkey, 8, buf, 128, &loc))) {
			cfprintf("PUTDATA shortkey tree failed at i=%d\n", i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUTDATA shortkey tree PER SEC = %ld\n", (i*10) / diff);


	varkey[0] = 1;
	varkey[1] = 1;
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfget(hd1, varkey, 8, buf, 128)) != FOUND) {
			cfprintf("GETDATA shortkey tree failed result = %d i=%d\n", result,i);
			break;
		}
		if(buf[0] != i+25 || buf[31] != i+35)
			cfprintf("GETDATA shortkey tree returned wrong value %d should be %d\n",
			buf[0], i+25);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GETDATA shortkey tree PER SEC = %ld\n", (i*10) / diff);

	varkey[0] = 1;
	varkey[1] = 1;
	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		++varkey[0];
		if((result = cfdelete(hd1, varkey, 8)) != OK) {
			cfprintf("DELETE shortkey tree failed result = %d i=%d\n", result,i);
			break;
		}
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE shortkey tree PER SEC = %ld\n", (i*10) / diff);

#endif

#if 0
cfprintf("AFTER\n");
print_entries(hd1);
print_all_bitmaps(hd1);
#endif

	cfprintf("End data_test1\n");
}
static void
data_test2(void *hd, void *hd1)
{
long i, start, end, diff, result;
DupName dupname;
DupName savnam;

	cfprintf("Begin data_test2 DUPNAMES -- 128 bytes per item\n");

#if DOHASH == 1

	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		buf[0] = i+42;
		buf[31] = i+43;
		if(!(cfput_dupname(hd,"ADDRESS + PHONE NUMBER",22,buf,128,&loc,NULL)))
			cfprintf("PUT dupname  hash failed at i=%d\n", i);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUT DUPNAME hash PER SEC = %ld\n", (i*10) / diff);


	cflastdupname(hd, "ADDRESS + PHONE NUMBER", 22, &dupname);
	start = clock();
	for (i = 999; i >= 0; --i)
	{
		if(!(cfget_dupname(hd, &dupname, buf, 128)))
			cfprintf("GET dupname  hash failed at i=%d\n", i);
		if(buf[0] != i+42 || buf[31] != i+43)
			cfprintf("GET dupname hash returned wrong value %d should be %d\n",
			buf[0], i+42);
		--dupname.name;
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GET DUPNAME hash PER SEC = %ld\n", (1000*10) / diff);

	for (i = 0; i < 1000; ++i)
	{
		if((result = cfdelete_lastdupname(hd, "ADDRESS + PHONE NUMBER", 22)) != OK)
			cfprintf("DELETE LASTDUPNAME hash failed at i=%d result=%d\n",
		 	i, result);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE LASTDUPNAME hash PER SEC = %ld\n", (i*10) / diff);

#endif
#if DOTREE == 1

	start = clock();
	for (i = 0; i < 1000; ++i)
	{
		buf[0] = i+42;
		buf[31] = i+43;
		if(!(cfput_dupname(hd1,"ADDRESS + PHONE NUMBER",22,buf,128,&loc,&savnam)))
			cfprintf("PUT dupname tree failed at i=%d\n", i);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  PUT DUPNAME tree PER SEC = %ld\n", (i*10) / diff);

	start = clock();

	cflastdupname(hd1, "ADDRESS + PHONE NUMBER", 22, &dupname);
	for (i = 999; i >= 0; --i)
	{
		if(!(cfget_dupname(hd1, &dupname, buf, 128)))
			cfprintf("GET dupname tree failed at i=%d\n", i);
		if(buf[0] != i+42 || buf[31] != i+43)
			cfprintf("GET dupname tree returned wrong value %d should be %d\n",
			buf[0], i+42);
		--dupname.name;
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  GET DUPNAME tree PER SEC = %ld\n", (1000*10) / diff);

	for (i = 0; i < 1000; ++i)
	{
		if((result = cfdelete_lastdupname(hd1, "ADDRESS + PHONE NUMBER", 22)) != OK)
			cfprintf("DELETE LASTDUPNAME tree failed at i=%d result=%d\n",
		 	i, result);
	}
	end = clock();
	diff = end - start;
	diff /= CLOCKS_PER_SECOND/10;
	if(diff == 0) diff = 1;
	cfprintf("  DELETE LASTDUPNAME tree PER SEC = %ld\n", (i*10) / diff);


#endif

	cfprintf("End data_test2\n");
}

