/* DUPTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

#define CLOCKS_PER_SECOND 1000000L

/* TEST CHOICES */
#define PFLAGS 0
#define MEMFILE 1
#define EXTDMEM 1
#define DOHASH 1
#define DOTREE 1

extern int errno;
static void dup_test1(void *hd, void *hd1);
static void dup_test2(void *hd, void *hd1);

void
main()
{
void *hxxx;
void *huniq;
void *huniq1;
void *hsxxx;
void *hsxxx1;


	cfport_settestflags(1);
	cfinit("duptest",512,NULL);
	cfprintf("DUPLICATE ENTRY TESTS.\n");


#if MEMFILE
	cfprintf("MEMORY FILE\n");
	hxxx = cfopen("MEMORY/XXX",F_RDWR|F_CREAT,NULL);
	if(!hxxx) {
		cfprintf("ERROR: create XXX err=%d\n", errno);
		exit(0);
	}
	huniq = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, NULL);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE0 err=%d\n", errno);
		exit(0);
	}
	huniq1 = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_SORTED, NULL);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE1 err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxxx", hxxx);
	cfpflags("huniq", huniq);
	cfpflags("huniq1", huniq1);
#endif
	dup_test1(huniq, huniq1);
	dup_test2(huniq, huniq1);
cfprintf("NOW CLOSING\n");
	cfclose(huniq);
	cfclose(huniq1);
#endif /* MEMFILE */


#if EXTDMEM
	cfprintf("EXTDMEM FILE\n");
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR|F_CREAT|F_HUGEDIR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: create EXTDMEM/XXX err=%d\n", errno);
		exit(0);
	}
	hsxxx1 = cfopen("EXTDMEM/XXX1", F_RDWR|F_CREAT|F_SORTED, NULL);
	if(!hsxxx1) {
		cfprintf("ERROR: create EXTDMEM/XXX1 err=%d\n", errno);
		exit(0);
	}

#if PFLAGS
	cfpflags("hsxxx", hsxxx);
	cfpflags("hsxxx1", hsxxx1);
#endif
	cfsetlazy(hsxxx);
	cfsetlazy(hsxxx1);
	dup_test1(hsxxx, hsxxx1);
	dup_test2(hsxxx, hsxxx1);
cfprintf("NOW CLOSING\n");
	cfclose(hsxxx1);
	cfclose(hsxxx);

	cfprintf("REOPEN EXTDMEM FILE\n");	
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX err=%d\n", errno);
		exit(0);
	}
	hsxxx1 = cfopen("EXTDMEM/XXX1", F_RDWR, NULL);
	if(!hsxxx1) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX1 err=%d\n", errno);
		exit(0);
	}
	cfsetlazy(hsxxx);
	cfsetlazy(hsxxx1);
	dup_test1(hsxxx,hsxxx1);
	dup_test2(hsxxx,hsxxx1);
cfprintf("NOW CLOSING\n");
	cfunlink(hsxxx, NULL);
	cfunlink(hsxxx1, NULL);
#endif /* EXTDMEM */

	cfexit();
} /* END: MAIN */

static Item keyval;
static Item newval;

static void
dup_test1(void *hd, void *hd1)
{
char *keyname1 = "keyname1";
char *keyname2 = "keyname2";
char *lname1 = "long key name";
char *lname2 = "long key name2";
int result;
long i;
long dupcnt;

	cfprintf("Begin dup_test1 SIMPLE DUPS\n");
	if(cfisnew(hd))
	{/* INITIAL DATA  ENTRY */

		/* 8 BYTE KEY with OKDUPS */
		for(i = 0; i < 20; ++i)
		{
			keyval.a0 = i+2;
#if DOHASH == 1
			if((result = cfinsert_dupnum(hd, keyname1, 8, &keyval, NULL)) < OK) {
				cfprintf("CFINSERT hash OKDUPS FAILED at i=%d result=%d\n", i, result);
			}
#endif
#if DOTREE == 1
			if((result = cfinsert_dupnum(hd1, keyname1, 8, &keyval, NULL)) < OK) {
				cfprintf("CFINSERT tree OKDUPS FAILED at i=%d result=%d\n", i, result);
			}
#endif
		}


		/* 8 BYTE KEY with CNTDUPS */
		for(i = 0; i < 20; ++i)
		{
			keyval.a0 = i+2;
#if DOHASH == 1
			dupcnt = 0;
			if((result = cfinsert_dupnum(hd, keyname2, 8, &keyval, &dupcnt)) < OK) {
				cfprintf("CFINSERT hash CNTDUPS FAILED at i=%d result=%d\n", i, result);
			}
			if(dupcnt != i+1)
				cfprintf("hashinsert CNTDUPS i=%d dupcnt=%d\n", i, dupcnt);
#endif
#if DOTREE == 1
			if((result = cfinsert_dupnum(hd1, keyname2, 8, &keyval, &dupcnt)) < OK) {
				cfprintf("CFINSERT tree CNTDUPS FAILED at i=%d result=%d\n", i, result);
			}
			if(dupcnt != i+1)
				cfprintf("treeinsert CNTDUPS i=%d dupcnt=%d\n", i, dupcnt);
#endif
		}

		/* LONG KEY with OKDUPS */
		for(i = 0; i < 20; ++i)
		{
			keyval.a0 = i+2;
#if DOHASH == 1
			if((result = cfinsert_dupnum(hd, lname1, strlen(lname1), &keyval, NULL)) < OK) {
				cfprintf("CFINSERT hashL1 OKDUPS FAILED at i=%d result=%d\n", i, result);
			}
#endif
#if DOTREE == 1
			if((result = cfinsert_dupnum(hd1, lname1, strlen(lname1), &keyval, NULL)) < OK) {
				cfprintf("CFINSERT treeL1 OKDUPS FAILED at i=%d result=%d\n", i, result);
			}
#endif
		}


		/* LONG KEY with CNTDUPS */
		for(i = 0; i < 20; ++i)
		{
			keyval.a0 = i+2;
#if DOHASH == 1
			dupcnt = 0;
			if((result = cfinsert_dupnum(hd, lname2, strlen(lname2), &keyval, &dupcnt)) < OK) {
				cfprintf("CFINSERT hashL2 CNTDUPS FAILED at i=%d result=%d\n", i, result);
			}
			if(dupcnt != i+1)
				cfprintf("hashL2 CNTDUPS i=%d dupcnt=%d\n", i, dupcnt);
#endif
#if DOTREE == 1
			dupcnt = 0;
			if((result = cfinsert_dupnum(hd1, lname2, strlen(lname2), &keyval, &dupcnt)) < OK) {
				cfprintf("CFINSERT treeL2 CNTDUPS FAILED at i=%d result=%d\n", i, result);
			}
			if(dupcnt != i+1)
				cfprintf("treeL2 CNTDUPS i=%d dupcnt=%d\n", i, dupcnt);
#endif
		}
	}/* END: if(cfisnew()) */

	/* CHECK IF DATA IS REALLY THERE */
	/* USE CFFINDITEM */
	/* 8 BYTE KEY with OKDUPS */
	for(i = 0; i < 20; ++i)
	{
		keyval.a0 = i+2;
#if DOHASH == 1
		if((result = cffind_item(hd, keyname1, 8, &keyval)) != FOUND) {
			cfprintf("CFFINDITEM hash OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0  != i+2)
			 cfprintf("CFFINDITEM hash OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		if((result = cffind_item(hd1, keyname1, 8, &keyval)) != FOUND) {
			cfprintf("CFFINDITEM tree OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDITEM tree OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}

#endif
	}

	/* 8 BYTE KEY with CNTDUPS */
	for(i = 0; i < 20; ++i)
	{
		keyval.a0 = i+2;
#if DOHASH == 1
		if((result = cffind_item(hd, keyname2, 8, &keyval)) != FOUND) {
			cfprintf("CFFINDITEM hash CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
		  if(keyval.a0 != i+2)
			cfprintf("CFFINDITEM hash CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}

#endif
#if DOTREE == 1
		if((result = cffind_item(hd1, keyname2, 8, &keyval)) != FOUND) {
			cfprintf("CFFINDITEM tree CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDITEM tree CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* LONG KEY with OKDUPS */
	for(i = 0; i < 20; ++i)
	{
		keyval.a0 = i+2;
#if DOHASH == 1
		if((result = cffind_item(hd, lname1, strlen(lname1), &keyval)) != FOUND) {
			cfprintf("CFFINDITEM hashL1 OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDITEM hashL1 OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		if((result = cffind_item(hd1, lname1, strlen(lname1), &keyval)) != FOUND) {
			cfprintf("CFFINDITEM treeL1 OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDITEM treeL1 OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* LONG KEY with CNTDUPS */
	for(i = 0; i < 20; ++i)
	{
		keyval.a0 = i+2;
#if DOHASH == 1
		if((result = cffind_item(hd, lname2, strlen(lname2), &keyval)) != FOUND) {
			cfprintf("CFFINDITEM hashL2 CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDITEM hashL2 CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		if((result = cffind_item(hd1, lname2, strlen(lname2), &keyval)) != FOUND) {
			cfprintf("CFFINDITEM treeL2 CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDITEM treeL2 CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* CHECK IF DATA IS REALLY THERE */
	/* USE CFFINDDUP */
	/* 8 BYTE KEY with OKDUPS */
	for(i = 0; i < 20; ++i)
	{
#if DOHASH == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, keyname1, 8, &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP hash OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP hash OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, keyname1, 8, &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP tree OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP tree OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* 8 BYTE KEY with CNTDUPS */
	for(i = 0; i < 20; ++i)
	{
#if DOHASH == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, keyname2, 8, &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP hash CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
		  if(keyval.a0 != i+2)
			cfprintf("CFFINDDUP hash CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, keyname2, 8, &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP tree CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP tree CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* LONG KEY with OKDUPS */
	for(i = 0; i < 20; ++i)
	{
#if DOHASH == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, lname1, strlen(lname1), &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP hashL1 OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP hashL1 OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, lname1, strlen(lname1), &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP treeL1 OKDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP treeL1 OKDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* LONG KEY with CNTDUPS */
	for(i = 0; i < 20; ++i)
	{
#if DOHASH == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, lname2, strlen(lname2), &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP hashL2 CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP hashL2 CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, lname2, strlen(lname2), &keyval, &i)) != FOUND) {
			cfprintf("CFFINDDUP treeL2 CNTDUPS FAILED at i=%d result=%d val=%d\n",
			i, result, keyval.a0);
		} else {
			if(keyval.a0 != i+2)
			 cfprintf("CFFINDDUP treeL2 CNTDUPS returned wrong value=%d should be %d\n",
							keyval.a0, i+2);
		}
#endif
	}

	/* CHECK THE LAST DUP OPTION OF CFFINDDUP */
#if DOHASH == 1
		keyval.a0 = 0;
		i = -1;
		if((result = cffind_dupnum(hd, keyname1, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hash OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			 cfprintf("CFFINDDUPLAST hash OKDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, keyname2, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hash CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			cfprintf("CFFINDDUPLAST hash CNTDUPS returned wrong value=%d should be 21\n",
			keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, lname1, strlen(lname1), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hashL1 OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			cfprintf("CFFINDDUPLAST hashL1 OKDUPS returned wrong value=%d should be 21\n",
			keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, lname2, strlen(lname2), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hashL2 CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			 cfprintf("CFFINDDUPLAST hashL2 CNTDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		i = -1;
		if((result = cffind_dupnum(hd1, keyname1, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST tree OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			 cfprintf("CFFINDDUPLAST tree OKDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, keyname2, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST tree CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			 cfprintf("CFFINDDUPLAST tree CNTDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, lname1, strlen(lname1), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST treeL1 OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 21)
			 cfprintf("CFFINDDUPLAST treeL1 OKDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, lname2, strlen(lname2), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST treeL2 CNTDUPS FAILED result=%d val=%d\n",
			result, (int)keyval.a0);
		else if(keyval.a0 != 21)
			 cfprintf("CFFINDDUPLAST treeL2 CNTDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);
#endif

	/* CHECK THE CFFIND FUNCTION */
#if DOHASH == 1
		keyval.a0 = 0;
		if((result = cffind(hd, keyname1, 8, &keyval)) != FOUND+1)
			cfprintf("CFFIND hash OKDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND hash OKDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
		keyval.a0 = 0;
		if((result = cffind(hd, keyname2, 8, &keyval)) != FOUND+1)
			cfprintf("CFFIND hash CNTDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND hash OKDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
		keyval.a0 = 0;
		if((result = cffind(hd, lname1, strlen(lname1), &keyval)) != FOUND+1)
			cfprintf("CFFIND hashL1 OKDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND hashL1 OKDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
		keyval.a0 = 0;
		if((result = cffind(hd, lname2, strlen(lname1), &keyval)) != FOUND+1)
			cfprintf("CFFIND hashL2 CNTDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND hashL2 CNTDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		if((result = cffind(hd1, keyname1, 8, &keyval)) != FOUND+1)
			cfprintf("CFFIND tree OKDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND tree OKDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
		keyval.a0 = 0;
		if((result = cffind(hd1, keyname2, 8, &keyval)) != FOUND+1)
			cfprintf("CFFIND tree CNTDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND tree CNTDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
		keyval.a0 = 0;
		if((result = cffind(hd1, lname1, strlen(lname1),&keyval)) != FOUND+1)
			cfprintf("CFFIND treeL1 OKDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND treeL1 OKDUPS returned wrong value %d should be 2\n", (int)keyval.a0);
		keyval.a0 = 0;
		if((result = cffind(hd1, lname2, strlen(lname1), &keyval)) != FOUND+1)
			cfprintf("CFFIND treeL2 CNTDUPS failed result=%d\n",result);
		else if(keyval.a0 != 2)
			cfprintf("CFFIND treeL2 returned wrong value %d should be 2\n", (int)keyval.a0);
#endif

	/* TRY DELETING SOME DATA */
#if DOHASH == 1

	if((result = cfdelete_lastdupnum(hd, keyname1, 8)) != OK)
		cfprintf("DELETEDUP hash OKDUPS failed result=%d\n", result);
	if((result = cfdelete_lastdupnum(hd, keyname2, 8)) != OK)
		cfprintf("DELETEDUP hash CNTDUPS failed result=%d\n", result);
	if((result = cfdelete_lastdupnum(hd, lname1, strlen(lname1))) != OK)
		cfprintf("DELETEDUP hashL1 OKDUPS failed result=%d\n", result);
	if((result = cfdelete_lastdupnum(hd, lname2, strlen(lname2))) != OK)
		cfprintf("DELETEDUP hashL2 CNTDUPS failed result=%d\n", result);
#endif
#if DOTREE == 1

	if((result = cfdelete_lastdupnum(hd1, keyname1, 8)) != OK)
		cfprintf("DELETEDUP tree OKDUPS failed result=%d\n", result);
	if((result = cfdelete_lastdupnum(hd1, keyname2, 8)) != OK)
		cfprintf("DELETEDUP tree CNTDUPS failed result=%d\n", result);
	if((result = cfdelete_lastdupnum(hd1, lname1, strlen(lname1))) != OK)
		cfprintf("DELETEDUP treeL1 OKDUPS failed result=%d\n", result);
	if((result = cfdelete_lastdupnum(hd1, lname2, strlen(lname2))) != OK)
		cfprintf("DELETEDUP treeL2 CNTDUPS failed result=%d\n", result);
#endif

	/* CHECK THE COUNT DUPS FUNCTION */
#if DOHASH == 1
	if((result = cfcountdups(hd, keyname1, 8)) != 19)
		cfprintf("COUNTDUPS hash OKDUPS =%d should be 19\n",result);
	if((result = cfcountdups(hd, keyname2, 8)) != 19)
		cfprintf("COUNTDUPS hash CNTDUPS =%d should be 19\n",result);
	if((result = cfcountdups(hd, lname1, strlen(lname1))) != 19)
		cfprintf("COUNTDUPS hashL1 OKDUPS =%d should be 19\n",result);
	if((result = cfcountdups(hd, lname2, strlen(lname1))) != 19)
		cfprintf("COUNTDUPS hashL2 CNTDUPS =%d should be 19\n",result);
#endif
#if DOTREE == 1
	if((result = cfcountdups(hd1, keyname1, 8)) != 19)
		cfprintf("COUNTDUPS tree OKDUPS =%d should be 19\n",result);
	if((result = cfcountdups(hd1, keyname2, 8)) != 19)
		cfprintf("COUNTDUPS tree CNTDUPS =%d should be 19\n",result);
	if((result = cfcountdups(hd1, lname1, strlen(lname1))) != 19)
		cfprintf("COUNTDUPS treeL1 OKDUPS =%d should be 19\n",result);
	if((result = cfcountdups(hd1, lname2, strlen(lname1))) != 19)
		cfprintf("COUNTDUPS treeL2 CNTDUPS =%d should be 19\n",result);
#endif


	/* CONFIRM THAT THE LAST DUP WAS DELETED */
#if DOHASH == 1
		keyval.a0 = 0;
		i = -1;
		if((result = cffind_dupnum(hd, keyname1, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hash OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			 cfprintf("CFFINDDUPLAST hash OKDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, keyname2, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hash CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			cfprintf("CFFINDDUPLAST hash CNTDUPS returned wrong value=%d should be 21\n",
			keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, lname1, strlen(lname1), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hashL1 OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			cfprintf("CFFINDDUPLAST hashL1 OKDUPS returned wrong value=%d should be 21\n",
			keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd, lname2, strlen(lname2), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST hashL2 CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			 cfprintf("CFFINDDUPLAST hashL2 CNTDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);
#endif
#if DOTREE == 1
		keyval.a0 = 0;
		i = -1;
		if((result = cffind_dupnum(hd1, keyname1, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST tree OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			 cfprintf("CFFINDDUPLAST tree OKDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, keyname2, 8, &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST tree CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			 cfprintf("CFFINDDUPLAST tree CNTDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, lname1, strlen(lname1), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST treeL1 OKDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			 cfprintf("CFFINDDUPLAST treeL1 OKDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);

		keyval.a0 = 0;
		if((result = cffind_dupnum(hd1, lname2, strlen(lname2), &keyval, &i)) != FOUND)
			cfprintf("CFFINDDUPLAST treeL2 CNTDUPS FAILED result=%d val=%d\n",
			result, keyval.a0);
		else if(keyval.a0 != 20)
			 cfprintf("CFFINDDUPLAST treeL2 CNTDUPS returned wrong value=%d should be 21\n",
			 keyval.a0);
#endif

	/* RESTORE THE LAST DUP SO REOPEN WILL WORK*/
	keyval.a0 = 19+2;
#if DOHASH == 1
	if((result = cfinsert_dupnum(hd, keyname1, 8, &keyval, NULL)) < OK)
		cfprintf("CFREINSERT hash OKDUPS FAILED result=%d\n", result);
	if((result = cfinsert_dupnum(hd, keyname2, 8, &keyval, NULL)) < OK)
		cfprintf("CFREINSERT hash OKDUPS FAILED result=%d\n", result);
	if((result = cfinsert_dupnum(hd, lname1, strlen(lname1), &keyval, NULL)) < OK)
		cfprintf("CFREINSERT hashL1 OKDUPS FAILED result=%d\n", result);
	if((result = cfinsert_dupnum(hd, lname2, strlen(lname2), &keyval, NULL)) < OK)
		cfprintf("CFREINSERT hashL2 OKDUPS FAILED result=%d\n", result);
#endif
#if DOTREE == 1
	if((result = cfinsert_dupnum(hd1, keyname1, 8, &keyval, NULL)) < OK)
		cfprintf("CFREINSERT tree OKDUPS FAILED result=%d\n", result);
	if((result = cfinsert_dupnum(hd1, keyname2, 8, &keyval, NULL)) < OK)
		cfprintf("CFREINSERT tree OKDUPS FAILED result=%d\n", result);
	if((result = cfinsert_dupnum(hd1, lname1, strlen(lname1), &keyval, NULL)) < OK)
		cfprintf("CFREINSERT treeL1 OKDUPS FAILED result=%d\n", result);
	if((result = cfinsert_dupnum(hd1, lname2, strlen(lname2), &keyval, NULL)) < OK)
		cfprintf("CFREINSERT treeL2 OKDUPS FAILED result=%d\n", result);
#endif
	cfprintf("End dup_test1\n");
}


static void
dup_test2(void *hd, void *hd1)
{
char *keyname3 = "keyname3";
int result;
long i;
DupName dupname;
DupName testname;

	cfprintf("Begin dup_test2 DUPNAMES\n");
	if(cfisnew(hd))
	{/* INITIAL DATA  ENTRY */
		for(i = 0; i < 20; ++i)
		{
		  keyval.a0 = i+2;
#if DOHASH == 1
		  dupname.name = 0;
		  dupname.xname = 0;
		  dupname.id = 0;

		  if((result = cfinsert_dupname(hd, keyname3, 8, &keyval, &dupname)) < OK) {
			cfprintf("CFINSERT hash DUPNAMES FAILED at i=%d result=%d\n", i, result);
		  }
		  if(dupname.id != 2 || dupname.name != i+1)
		  	cfprintf("hash DUPNAME wrong, should be:2,%d is %d,%d\n",
		  			i+1, dupname.id, dupname.name);

		  newval.a0 = 0;
		  if((result = cffind_dupname(hd, &dupname, &newval)) != FOUND) {
		  	cfprintf("CFFIND hash DUPNAMES FAILED at i=%d result=%d\n", i, result);
		  }
		  if(newval.a0 != i+2)
		    cfprintf("CFFIND hash DUPNAMES returned wrong value %d should be %d\n", newval.a0, i+2);

#endif
#if DOTREE == 1
		  dupname.name = 0;
		  dupname.xname = 0;
		  dupname.id = 0;

		  if((result = cfinsert_dupname(hd1, keyname3, 8, &keyval, &dupname)) < OK) {
			cfprintf("CFINSERT tree DUPNAMES FAILED at i=%d result=%d\n", i, result);
		  }
		  if(dupname.id != 2 || dupname.name != i+1)
		  	cfprintf("tree DUPNAME wrong, should be:2,%d is %d,%d\n",
		  			i+1, dupname.id, dupname.name);

		  newval.a0 = 0;
		  if((result = cffind_dupname(hd1, &dupname, &newval)) != FOUND) {
		  	cfprintf("CFFIND tree DUPNAMES FAILED at i=%d result=%d\n", i, result);
		  }
		  if(newval.a0 != i+2)
		    cfprintf("CFFIND tree DUPNAMES returned wrong value %d should be %d\n", newval.a0, i+2);

#endif
		}/* END: for(i,20,) */

#if DOHASH == 1
		/* CHECK THAT THERE ARE EXACTLY 20 DUPNAMES */

		if((result = cfcountdups(hd,keyname3,8)) != 20)
			cfprintf("COUNTDUPS hash DUPNAMES  =%d should be 20\n", result);

		/* DELETE THE LAST DUPNAME AND CHECK THE BOOKKEEPING */

		if((result = cfdelete_lastdupname(hd, keyname3, 8)) != OK)
			cfprintf("DELETE LASTDUPNAME hash failed. result=%d\n", result);
		if((result = cflastdupname(hd, keyname3, 8, &testname)) != OK)
			cfprintf("GET LASTDUPNAME hash failed. result = %d\n", result);
		if(testname.id != 2 || testname.name != 19)
		  	cfprintf("hash LASTDUPNAME wrong, should be:2,%d is %d,%d\n",
		  			19, testname.id, testname.name);
		if((result = cfcountdups(hd,keyname3,8)) != 19)
			cfprintf("COUNTDUPS hash DUPNAMES  =%d should be 19\n", result);
#endif
#if DOTREE == 1
		/* CHECK THAT THERE ARE EXACTLY 20 DUPNAMES */

		if((result = cfcountdups(hd1,keyname3,8)) != 20)
			cfprintf("COUNTDUPS tree DUPNAMES =%d should be 20\n", result);

		/* DELETE THE LAST DUPNAME AND CHECK THE BOOKKEEPING */

		if((result = cfdelete_lastdupname(hd1, keyname3, 8)) != OK)
			cfprintf("DELETE LASTDUPNAME tree failed. result=%d\n", result);
		if((result = cflastdupname(hd1, keyname3, 8, &testname)) != OK)
			cfprintf("GET LASTDUPNAME tree failed. result = %d\n", result);
		if(testname.id != 2 || testname.name != 19)
		  	cfprintf("tree LASTDUPNAME wrong, should be:2,%d is %d,%d\n",
		  			19, testname.id, testname.name);		
		if((result = cfcountdups(hd1,keyname3,8)) != 19)
			cfprintf("COUNTDUPS tree DUPNAMES =%d should be 19\n", result);
#endif

		/* DELETE A COUPLE OF DUPNAMES IN THE MIDDLE AND CHECK THE BOOKKEEPING */

		dupname.name = 0;
		dupname.xname = 0;
		dupname.id = 2;
#if DOHASH == 1
		dupname.name = 13;
		if((result = cfdelete_dupname(hd,keyname3,8,&dupname)) != OK)
			cfprintf("DELETEDUPNAME 13 hash failed. result=%d\n", result);
		dupname.name = 5;
		if((result = cfdelete_dupname(hd,keyname3,8,&dupname)) != OK)
			cfprintf("DELETEDUPNAME 5 hash failed. result=%d\n", result);

		if((result = cflastdupname(hd, keyname3, 8, &testname)) != OK)
			cfprintf("GET LASTDUPNAME hash failed. result = %d\n", result);
		if(testname.id != 2 || testname.name != 19)
		  	cfprintf("hash LASTDUPNAME wrong, should be:2,%d is %d,%d\n",
		  			19, testname.id, testname.name);		
		if((result = cfcountdups(hd,keyname3,8)) != 17)
			cfprintf("COUNTDUPS tree DUPNAMES =%d should be 17\n", result);
#endif
#if DOTREE == 1
		dupname.name = 13;
		if((result = cfdelete_dupname(hd1,keyname3,8,&dupname)) != OK)
			cfprintf("DELETEDUPNAME 13 tree failed. result=%d\n", result);
		dupname.name = 5;
		if((result = cfdelete_dupname(hd1,keyname3,8,&dupname)) != OK)
			cfprintf("DELETEDUPNAME 5 tree failed. result=%d\n", result);

		if((result = cflastdupname(hd1, keyname3, 8, &testname)) != OK)
			cfprintf("GET LASTDUPNAME tree failed. result = %d\n", result);
		if(testname.id != 2 || testname.name != 19)
		  	cfprintf("tree LASTDUPNAME wrong, should be:2,%d is %d,%d\n",
		  			19, testname.id, testname.name);		
		if((result = cfcountdups(hd1,keyname3,8)) != 17)
			cfprintf("COUNTDUPS tree DUPNAMES =%d should be 17\n", result);
#endif

	}	
	/* DELETE ALL THE REMAINING DUPNAMES */
#if DOHASH == 1
	if(!cfisnew(hd)) {
		if((result = cfdelete_alldupnames(hd, keyname3, 8)) != OK)
			cfprintf("DELETE all dupnames hash failed. result=%d\n", result);
		if((result = cflastdupname(hd, keyname3, 8, &testname)) == OK)
			cfprintf("GET LASTDUPNAME hash failed. result = %d\n", result);
		if((result = cfcountdups(hd,keyname3,8)) != -1)
			cfprintf("COUNTDUPS tree DUPNAMES =%d should be -1\n", result);
	}
#endif
#if DOTREE == 1
	if(!cfisnew(hd1)) {
		if((result = cfdelete_alldupnames(hd1, keyname3, 8)) != OK)
			cfprintf("DELETE all dupnames tree failed. result=%d\n", result);
		if((result = cflastdupname(hd1, keyname3, 8, &testname)) == OK)
			cfprintf("GET LASTDUPNAME hash failed. result = %d\n", result);
		if((result = cfcountdups(hd1,keyname3,8)) != -1)
			cfprintf("COUNTDUPS tree DUPNAMES =%d should be -1\n", result);
	}
#endif
	cfprintf("End dup_test2\n");
} 
