# Makefile for the cff test programs using emx method E1
# assumes that ../ports/cfport.o was compiled with emx

CC = gcc -O2 -m486 -Wall
LIB = ../ports/cfport.o ../libs/libcff.a

all:	hashtest pushtest permtest copytest treefile filetest \
		misctest blobtest datatest seqtest duptest treetest

filetest:	filetest.c $(LIB)
			$(CC) -o filetest filetest.c $(LIB)
			emxbind   filetest   -ac

treefile:	treefile.c $(LIB)
			$(CC) -o treefile treefile.c $(LIB)
			emxbind   treefile   -ac

treetest:	treetest.c $(LIB)
			$(CC) -o treetest treetest.c $(LIB)
			emxbind   treetest   -ac

hashtest:	hashtest.c $(LIB)
			$(CC) -o hashtest hashtest.c $(LIB)
			emxbind   hashtest   -ac

duptest:	duptest.c $(LIB)
			$(CC) -o duptest duptest.c $(LIB)
			emxbind   duptest   -ac

pushtest:	pushtest.c $(LIB)
			$(CC) -o pushtest pushtest.c $(LIB)
			emxbind   pushtest   -ac

datatest:	datatest.c $(LIB)
			$(CC) -o datatest datatest.c $(LIB)
			emxbind   datatest   -ac

blobtest:	blobtest.c $(LIB)
			$(CC) -o blobtest blobtest.c $(LIB)
			emxbind   blobtest   -ac

permtest:	permtest.c $(LIB)
			$(CC) -o permtest permtest.c $(LIB)
			emxbind   permtest   -ac

misctest:	misctest.c $(LIB)
			$(CC) -o misctest misctest.c $(LIB)
			emxbind   misctest   -ac

copytest:	copytest.c $(LIB)
			$(CC) -o copytest copytest.c $(LIB)
			emxbind   copytest   -ac

seqtest:	seqtest.c $(LIB)
			$(CC) -o seqtest seqtest.c $(LIB)
			emxbind   seqtest   -ac

