/* FILETEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include <string.h>
#include "../cff.h"

#define CLOCKS_PER_SECOND 1000000L

/* TEST CHOICES */
#define PFLAGS 0
#define MEMFILE 1
#define EXTDMEM 1
#define CFFFILE 1
#define EXTERNAL 1

extern int errno;
extern long clock();
extern int rand();


static void file_test(void *hd, void *hd1);
static void big_test(void *hd, void *hd1);

void
main()
{
void *hxxx;
void *huniq;
void *hcfile;
void *hsxxx;
void *hsxxx1;
void *hcxxx;
void *hxfile;

	cfport_settestflags(1);
	cfinit("filetest",256,NULL);
	cfprintf("HASHED DIRECTORY -- test of file property 4bytes per i/o\n");
#if MEMFILE
	cfprintf("MEMORY FILE\n");
	hxxx = cfopen("MEMORY/XXX",F_RDWR|F_CREAT,NULL);
	if(!hxxx) {
		cfprintf("ERROR: create XXX err=%d\n", errno);
		exit(0);
	}
	huniq = cfopen("MEMORY/XXX",F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_FILEONLY, NULL);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxxx", hxxx);
	cfpflags("huniq", huniq);
#endif
	file_test(huniq, NULL);
	big_test(huniq, NULL);
cfprintf("NOW CLOSING\n");
	cfclose(huniq);
#endif /* MEMFILE */

#if EXTDMEM
	cfprintf("EXTDMEM FILE\n");
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR|F_CREAT|F_FILEONLY, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: create EXTDMEM/XXX err=%d\n", errno);
		exit(0);
	}
	{/* Special case file, with preallocation of local bitmap */
	OPNINFO info;

		info.initial_entries = 0;
		info.bitmap_prealloc = 240000;
		info.data_prealloc = 0;
		hsxxx1 = cfopen(	"EXTDMEM/XXX1",
							F_RDWR|F_CREAT|F_BITMAP|F_FILEONLY|F_TEMP,
							&info);
		if(!hsxxx1) {
			cfprintf("ERROR: create EXTDMEM/XXX1 err=%d\n", errno);
			exit(0);
		}
	}
#if PFLAGS
	cfpflags("hsxxx", hsxxx);
	cfpflags("hsxxx1", hsxxx1);
#endif
	file_test(hsxxx, hsxxx1);
	big_test(hsxxx1, NULL);
cfprintf("NOW CLOSING\n");
	cfclose(hsxxx1);
	cfclose(hsxxx);

	cfprintf("REOPEN EXTDMEM FILE\n");	
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX err=%d\n", errno);
		exit(0);
	}
	file_test(hsxxx,NULL);
	big_test(hsxxx,NULL);
	cfunlink(hsxxx, NULL);
#endif /* EXTDMEM */

#if CFFFILE
	cfprintf("CFF DISK FILE\n");
	hcfile = cfopen("testfile.cff", F_RDWR|F_CREAT, NULL);
	if(!hcfile) {	
		cfprintf("ERROR: create testfile.cff err=%d\n", errno);
		exit(0);
	}
	hcxxx = cfopen("testfile.cff/XXX",
			F_RDWR|F_CREAT|F_FILEONLY, NULL);
	if(!hcxxx) {	
		cfprintf("ERROR: create testfile.cff/XXX err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hcfile", hcfile);
	cfpflags("hcxxx", hcxxx);
#endif
	file_test(hcxxx, NULL);
cfprintf("NOW CLOSING\n");
	cfclose(hcxxx);
	cfclose(hcfile);

	cfprintf("REOPEN CFF DISK FILE\n");	
	hcfile = cfopen("testfile.cff", F_RDWR, NULL);
	if(!hcfile) {	
		cfprintf("ERROR: reopen testfile.cff err=%d\n", errno);
		exit(0);
	}
	hcxxx = cfopen("testfile.cff/XXX", F_RDWR, NULL);
	if(!hcxxx) {	
		cfprintf("ERROR: reopen testfile.cff/XXX err=%d\n", errno);
		exit(0);
	}
	file_test(hcxxx,NULL);
	big_test(hcxxx,NULL);
cfprintf("NOW CLOSING\n");
	cfclose(hcxxx);
	cfclose(hcfile);
	cfunlink("testfile.cff");
#endif /* CFF FILE */

#if EXTERNAL
	cfprintf("EXTERNAL DISK FILE\n");
	hxfile = cfopen("testfile.tst", F_RDWR|F_CREAT, NULL);
	if(!hxfile) {	
		cfprintf("ERROR: create EXTERNAL FILE err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxfile", hxfile);
#endif
	file_test(hxfile,NULL);
	cfclose(hxfile);

	cfprintf("REOPEN EXTERNAL DISK FILE\n");	
	hxfile = cfopen("testfile.tst", F_RDWR, NULL);
	if(!hxfile) {	
		cfprintf("ERROR: reopen EXTERNAL FILE err=%d\n", errno);
		exit(0);
	}
	file_test(hxfile,NULL);
	cfclose(hxfile);
	cfunlink("testfile.tst");
#endif /* EXTERNAL */

	cfexit();
}
static void
file_test(void *hd, void *hd1)
{
long i, start, end, diff, err;
long amount;
long obtype = cfobtype(hd);
int nfile = (hd1) ? 2:1;

		if(obtype & OB_MEM)
			amount = 250000;
		else if(obtype & OB_CFILE)
			amount = 100000;
		else if(obtype & OB_XFILE)
			amount = 10000;
		else if(obtype & OB_SMEM)
			amount = 150000;
		else {
			cfprintf("UNKNOWN OBTYPE: %x\n", obtype);
			return;
		}

		/* WRITE DATA */
		start = clock();
		if(cfisnew(hd)) {
			cfseek(hd, 0, S_SET);
			if(hd1)
				cfseek(hd1, 0, S_SET);
			for(i = 0; i < amount; ++i) {
				if((err = cfwrite(hd, &i, 4)) != 4) {
					cfprintf("  File write failed at i=%d err=%d\n", i, err);
					break;
				}
				/* SECOND FILE, forces multiple noncontiguous chunks into
					both file maps */
				if(hd1) if((err = cfwrite(hd1, &i, 4)) != 4) {
					cfprintf("  File write1 failed at i=%d err=%d\n", i, err);
					break;
				}
			}
			end = clock();
			diff = end - start;
			diff /= CLOCKS_PER_SECOND/10;
			if(diff == 0) diff = 1;
			cfprintf("  FILEWRITES PER SEC = %ld\n", (nfile*i*10) / diff);
		}
cfprintf("  Bytesalloc=%lu Bytesused=%lu\n  File1 size=%lu File1 alloc=%lu\n",
cfbytesalloc(hd), cfbytesused(hd), cffilesize(hd), cffilealloc(hd));
if(nfile == 2)
cfprintf("  File2 size=%lu File2 alloc=%lu\n", cffilesize(hd1), cffilealloc(hd1));

		/* READ FORWARD */
		start = clock();
		cfseek(hd, 0, S_SET);
		for(i = 0; i < amount; ++i) {
		long val;
			if((err = cfread(hd, &val, 4)) != 4) {
				cfprintf("  File read failed at i=%ld err=%ld val=%ld\n", i, err,val);
				break;
			}
			if(val != i) {
				cfprintf("  File read bad value=%d should be %d\n", val, i);
				break;
			}
		}
		end = clock();
		diff = end - start;
		diff /= CLOCKS_PER_SECOND/10;
		if(diff == 0) diff = 1;
		cfprintf("  FILEREADS PER SEC = %ld\n", (i*10) / diff);

		/* READ BACKWARD */
		start = clock();
		for(i = amount-1; i >= 0; --i) {
		long val;
			cfseek(hd, i*4, S_SET);
			if((err = cfread(hd, &val, 4)) != 4) {
				cfprintf("  File backward read failed at i=%d err=%d\n", i, err);
				break;
			}
			if(val != i) {
				cfprintf("  File backward read bad value=%d should be %d\n", val, i);
				break;
			}
		}
		end = clock();
		diff = end - start;
		diff /= CLOCKS_PER_SECOND/10;
		if(diff == 0) diff = 1;
		cfprintf("  BACKWARD READS PER SEC = %ld\n", ((amount -i)*10) / diff);

		/* RANDOM */
		start = clock();
		for(i = 0; i < amount/10; ++i) {
		long val, j;

			j = rand() % amount;
			cfseek(hd, j*4, S_SET);
			if((err = cfread(hd, &val, 4)) != 4) {
				cfprintf("  File random read failed at j=%d err=%d\n", j, err);
				break;
			}
			if(val != j) {
				cfprintf("  File random read bad value=%d should be %d\n", val, j);
				break;
			}
		}
		end = clock();
		diff = end - start;
		diff /= CLOCKS_PER_SECOND/10;
		if(diff == 0) diff = 1;
		cfprintf("  RANDOM READS PER SEC = %ld\n", (i*10) / diff);

	/* CLIP THE FILESIZE SUBSTANTIALLY */
	if(!cfisnew(hd))
	{
		amount /= 2;

		/* TRUNCATE AND REREAD FILE */
		cfprintf("   TRUNCATE AND REREAD FILE\n");

		cftruncate(hd, amount * 4);

		start = clock();
		cfseek(hd, 0, S_SET);
		for(i = 0; i < amount; ++i) {
		long val;
			if((err = cfread(hd, &val, 4)) != 4) {
				cfprintf("  File read failed at i=%ld err=%ld val=%ld\n", i, err,val);
				break;
			}
			if(val != i) {
				cfprintf("  File read bad value=%d should be %d\n", val, i);
				break;
			}
		}
		end = clock();
		diff = end - start;
		diff /= CLOCKS_PER_SECOND/10;
		if(diff == 0) diff = 1;
		cfprintf("  FILEREREADS PER SEC = %ld\n", (i*10) / diff);
cfprintf("  Bytesalloc=%lu Bytesused=%lu\n  File1 size=%lu File1 alloc=%lu\n",
cfbytesalloc(hd), cfbytesused(hd), cffilesize(hd), cffilealloc(hd));

	}

}
static void
big_test(void *hd, void *hd1)
{
#define BUFSIZE 15000
long buf[BUFSIZE];
int i,j;
long err;
	cfprintf("  TEST LARGE BUFFER READ/WRITE\n");


	cfseek(hd, 0, S_SET);
	if(hd1)
		cfseek(hd1, 0, S_SET);

	cfprintf("  WRITE 10 BUFFERS of %lu bytes each\n", sizeof(buf));
	for(i = 0; i < 10; ++i)
	{
		for(j = 0; j < BUFSIZE-1; ++j)
			buf[j] = (j<<8)+i;
		if((err = cfwrite(hd, buf, sizeof(buf))) != sizeof(buf)) {
			cfprintf("BIG write error hd i=%d err=%d\n", i, err);
		}
		if(hd1)
			if((err = cfwrite(hd1, buf, sizeof(buf))) != sizeof(buf)) {
				cfprintf("BIG write error hd1 i=%d err=%d\n", i, err);
			}
	}
	cfprintf("  WRITE DONE\n");

	cfseek(hd, 0, S_SET);
	if(hd1)
		cfseek(hd1, 0, S_SET);
	cfprintf("  READ AND CHECK BUFFERS\n");
	for(i = 0; i < 10; ++i)
	{
		memset(buf, 0, sizeof(buf));
		if((err = cfread(hd, buf, sizeof(buf))) != sizeof(buf)) {
			cfprintf("BIG READ ERROR hd i=%d err=%d\n", i, err);
			continue;
		}
		for(j = 0; j < BUFSIZE-1; ++j) {
			if(buf[j] != (j<<8)+i) {
				cfprintf("BAD DATA hd %x should be %x at i=%d j=%d\n",
					buf[j], (j<<8)+i, i, j);	
				break;
			}
		}
		if(hd1) {
			memset(buf, 0, sizeof(buf));
			if((err = cfread(hd1, buf, sizeof(buf))) != sizeof(buf)) {
				cfprintf("BIG READ ERROR hd1 i=%d err=%d\n", i, err);
				continue;
			}
			for(j = 0; j < BUFSIZE-1; ++j) {
				if(buf[j] != (j<<8)+i) {
					cfprintf("BAD DATA hd %x should be %x at i=%d j=%d\n",
						buf[j], (j<<8)+i, i, j);	
					break;
				}
			}
		}
	}
	cfprintf("  READ AND CHECK DONE\n");
}

