/* HASHTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

#define CLOCKS_PER_SECOND 1000000L

/* TEST CHOICES */
#define PFLAGS 0
#define MEMFILE 1
#define EXTDMEM 1
#define CFFFILE 1

extern int errno;
extern long clock();
extern int rand();
extern long tree_testcnt;
extern long tree_bincnt;
OPNINFO info;

static void hash_test(void *hd, void *hd1);

void
main()
{
void *hxxx;
void *huniq;
void *hcfile;
void *hsxxx;
void *hsxxx1;
void *hcxxx;


	cfport_settestflags(1);
	cfinit("hashtest",512,NULL);
	cfprintf("HASHED DIRECTORIES keyed inserts, finds and deletes.\n");

	/* HASHED DIRECTORIES CAN BE PREALLOCATED */
	info.initial_entries = 10000;
	info.bitmap_prealloc = 0;
	info.data_prealloc = 0;
	
#if MEMFILE
	cfprintf("MEMORY FILE\n");
	hxxx = cfopen("MEMORY/XXX",F_RDWR|F_CREAT,NULL);
	if(!hxxx) {
		cfprintf("ERROR: create XXX err=%d\n", errno);
		exit(0);
	}
	huniq = cfopen("MEMORY/XXX",
					F_RDWR|F_CREAT|F_TEMP|F_UNIQ|F_HUGEDIR, &info);
	if(!huniq) {
		cfprintf("ERROR: create UNIQUE TEMP FILE err=%d\n", errno);
		exit(0);
	}
#if PFLAGS
	cfpflags("hxxx", hxxx);
	cfpflags("huniq", huniq);
#endif
	hash_test(huniq, NULL);
cfprintf("NOW CLOSING\n");
	cfclose(huniq);
#endif /* MEMFILE */

#if EXTDMEM
	cfprintf("EXTDMEM FILE\n");
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hsxxx) {
		cfprintf("ERROR: create EXTDMEM/XXX err=%d\n", errno);
		exit(0);
	}
	{/* Special case file, with preallocation of local bitmap */
	OPNINFO info;
		info.initial_entries = 0;
		info.bitmap_prealloc = 240000;
		info.data_prealloc = 0;
		hsxxx1 = cfopen("EXTDMEM/XXX1",
						F_RDWR|F_CREAT|F_BITMAP|F_TEMP,
						&info);
		if(!hsxxx1) {
			cfprintf("ERROR: create EXTDMEM/XXX1 err=%d\n", errno);
			exit(0);
		}
	}
#if PFLAGS
	cfpflags("hsxxx", hsxxx);
	cfpflags("hsxxx1", hsxxx1);
#endif
	cfsetlazy(hsxxx);
	hash_test(hsxxx, hsxxx1);
cfprintf("NOW CLOSING\n");
	cfclose(hsxxx1);
	cfclose(hsxxx);

	cfprintf("REOPEN EXTDMEM FILE\n");	
	hsxxx = cfopen("EXTDMEM/XXX", F_RDWR, NULL);
	if(!hsxxx) {
		cfprintf("ERROR: reopen EXTDMEM:/XXX err=%d\n", errno);
		exit(0);
	}
	cfsetlazy(hsxxx);
	hash_test(hsxxx,NULL);
cfprintf("NOW CLOSING\n");
	cfunlink(hsxxx, NULL);
#endif /* EXTDMEM */

#if CFFFILE
	cfprintf("CFF DISK FILE\n");
	hcfile = cfopen("testfile.cff", F_RDWR|F_CREAT, NULL);
	if(!hcfile) {	
		cfprintf("ERROR: create testfile.cff err=%d\n", errno);
		exit(0);
	}
	hcxxx = cfopen("testfile.cff/XXX",
						F_RDWR|F_CREAT|F_HUGEDIR, &info);
	if(!hcxxx) {	
		cfprintf("ERROR: create testfile.cff/XXX err=%d\n", errno);
		exit(0);
	}
#if 0
	cfpflags("hcfile", hcfile);
	cfpflags("hcxxx", hcxxx);
#endif
	cfsetlazy(hcxxx);
	hash_test(hcxxx, NULL);
cfprintf("NOW CLOSING\n");
	cfclose(hcxxx);
	cfclose(hcfile);

	cfprintf("REOPEN CFF DISK FILE\n");	
	hcfile = cfopen("testfile.cff", F_RDWR, NULL);
	if(!hcfile) {	
		cfprintf("ERROR: reopen testfile.cff err=%d\n", errno);
		exit(0);
	}
	hcxxx = cfopen("testfile.cff/XXX", F_RDWR, NULL);
	if(!hcxxx) {	
		cfprintf("ERROR: reopen testfile.cff/XXX err=%d\n", errno);
		exit(0);
	}
	cfsetlazy(hcxxx);
	hash_test(hcxxx,NULL);
cfprintf("NOW CLOSING\n");
	cfclose(hcxxx);
	cfclose(hcfile);
	cfunlink("testfile.cff");
#endif /* CFF FILE */

	cfexit();
} /* MAIN */

static Item keyval;

static void
hash_test(void *hd, void *hd1)
{
long i, start, end, diff;
long amount;
long obtype = cfobtype(hd);

		if(obtype & OB_MEM)
			amount = 10000;
		else if(obtype & OB_CFILE)
			amount = 10000;
		else if(obtype & OB_SMEM)
			amount = 10000;
		else {
			cfprintf("UNKNOWN OBTYPE: %x\n", obtype);
			return;
		}

		if(cfisnew(hd)) {

		int result;
			start = clock();
			tree_testcnt = tree_bincnt = 0;
			for(i = 0; i < amount; ++i)
			{
				keyval.a0 = i+2;
				if((result = cfinsert(hd, &keyval, 4, &keyval)) < OK) {
					cfprintf("CFINSERT FAILED at i=%d result=%d\n", i, result);
					break;
				}
			}			
			end = clock();
			diff = end - start;
			diff /= CLOCKS_PER_SECOND/10;
			if(diff == 0) diff = 1;
			cfprintf("  KEYINSERTS PER SEC = %ld\n", (i*10) / diff);
		}
#if 0
print_entries(hd);
exit(0);
#endif
		/* FINDITEM */
		start = clock();
		{
		int result;
			tree_testcnt = tree_bincnt = 0;
			for(i = 0; i < amount; ++i)
			{
				keyval.a0 = i+2;
				if((result = cffind_item(hd, &keyval, 4, &keyval)) != FOUND) {
					cfprintf("CFFINDITEM FAILED at i=%d result=%d val=%d\n",
						i, result, (int)keyval.a0);
					break;
				} else {
				  if(keyval.a0 != i+2)
					cfprintf("CFFINDITEM returned wrong value=%d should be %d\n",
							(int)keyval.a0, i+2);
				}
			}			
			end = clock();
			diff = end - start;
			diff /= CLOCKS_PER_SECOND/10;
			if(diff == 0) diff = 1;
			cfprintf("  KEYFINDS PER SEC = %ld\n", (i*10) / diff);
		}

		/* DELETE */
		start = clock();
		{
		int result;
			tree_testcnt = tree_bincnt = 0;
			for(i = 0; i < amount/2; ++i)
			{
				keyval.a0 = i+2;
				if((result = cfdelete_item(hd, &keyval, 4, &keyval)) != OK) {
					cfprintf("CFDELETEITEM FAILED at i=%d result=%d val=%d\n",
						i, result, (int)keyval.a0);
					break;
				}
			}			
			end = clock();
			diff = end - start;
			diff /= CLOCKS_PER_SECOND/10;
			if(diff == 0) diff = 1;
			cfprintf("  KEYDELETEITEMS PER SEC = %ld\n", (i*10) / diff);
		}

		/* CHECK DELETE */
		start = clock();
		{
		int result;
			tree_testcnt = tree_bincnt = 0;
			for(i = 0; i < amount/2; ++i)
			{
				keyval.a0 = i+2;
				if((result = cffind_item(hd, &keyval, 4, &keyval)) >= FOUND){
					cfprintf("CFFINDDELETED FAILED at i=%d result=%d val=%d\n",
						i, result, (int)keyval.a0);
					break;
				}
			}			
			end = clock();
			diff = end - start;
			diff /= CLOCKS_PER_SECOND/10;
			if(diff == 0) diff = 1;
			cfprintf("  KEYNOFINDS PER SEC = %ld\n", (i*10) / diff);
		}

		/* REINSERT */
		start = clock();
		{
		int result;
			tree_testcnt = tree_bincnt = 0;
			for(i = 0; i < amount/2; ++i)
			{
				keyval.a0 = i+2;

				if((result = cfinsert(hd, &keyval, 4, &keyval)) < OK) {
					cfprintf("CFREINSERT FAILED at i=%d result=%d\n",
						i, result);
					break;
				}
			}			
			end = clock();
			diff = end - start;
			diff /= CLOCKS_PER_SECOND/10;
			if(diff == 0) diff = 1;
			cfprintf("  KEYREINSERTS PER SEC = %ld\n", (i*10) / diff);
		}

		cfprintf("  ALLOCATED:%lu USED:%lu PER ENTRY=%lu\n",
		  cfbytesalloc(hd), cfbytesused(hd), cfbytesused(hd)/amount);
}

