/* SEQTEST.C */
/* Copyright 1990, 1991, 1992, 1993 Norman D. Culver Ft. Lauderdale, FL */
/*					All Rights Reserved 			  				    */

#include <stdlib.h>
#include "../cff.h"

static void seq_test1(void *hd, void *hd1);
static void seq_test2(void *hd, void *hd1);
static void seq_test3(void *hd, void *hd1);

void
main()
{
void *hd, *hd1;

	cfport_settestflags(1);
	cfinit("seqtest",512,NULL);
	cfprintf("SEQUENTIAL ACCESS TESTS.\n");

	hd = cfopen("EXTDMEM/seq1", F_RDWR|F_CREAT|F_HUGEDIR, NULL);
	hd1 = cfopen("EXTDMEM/seq2", F_RDWR|F_CREAT|F_SORTED|F_HUGEDIR, NULL);
	seq_test1(hd, hd1);
	seq_test2(hd, hd1);
	seq_test3(hd, hd1);
	cfclose(hd);
	cfclose(hd1);
	cfexit();
}

static void
seq_test1(void *hd, void *hd1)
{
long i;
Item myitem;
unsigned long finds[200];

	cfprintf("Begin seq_test1 -- keyed inserts\n");
	myitem.a2.type = STO_VALUE;
	for(i = 0; i < 200; ++i)
	{
		myitem.a0 = i;
		if(cfinsert(hd, &i, 4, &myitem) != OK)
			cfprintf("Insert failed for hash at i=%d\n", i);
		if(cfinsert(hd1, &i, 4, &myitem) != OK)
			cfprintf("Insert failed for tree at i=%d\n", i);
	}
	myitem.a0 = 1000;
	if(cfhead(hd, &myitem) != OK)
		cfprintf("Head failed for hash dir.\n");
	if(myitem.a0 > 199)
		cfprintf("Data failed for Head hashdir =%d\n", myitem.a0);

	myitem.a0 = 1000;
	if(cftail(hd, &myitem) != OK)
		cfprintf("Tail failed for hash dir.\n");
	if(myitem.a0 > 199)
		cfprintf("Data failed for Tail hashdir =%d\n", myitem.a0);
	
	cfhead(hd1, &myitem);
	if(myitem.a0 != 0)
		cfprintf("Head failed for tree dir.\n");
	cftail(hd1, &myitem);
	if(myitem.a0 != 199)
		cfprintf("Tail failed for tree dir.\n");

	cfhead(hd, &myitem);
	finds[myitem.a0] = myitem.a0;
	cfhead(hd1, NULL);
	for(i = 1; i < 200; ++i)
	{
		if(cfnext(hd, &myitem) != OK)
			cfprintf("Next failed for hashdir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 > 199)
			cfprintf("Data failed for Next hashdir at i=%d item=%d\n", i, myitem.a0);
		finds[myitem.a0] = myitem.a0;

		myitem.a0 = 0;
		if(cfnext(hd1, &myitem) != OK)
			cfprintf("Next failed for treedir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 != i)
			cfprintf("Data failed for Next treedir at i=%d item=%d\n", i, myitem.a0);
	
	}
	cftail(hd, &myitem);
	finds[myitem.a0] = myitem.a0;
	cftail(hd1, NULL);
	for(i=198; i >= 0; --i)
	{
		if(cfprev(hd, &myitem) != OK)
			cfprintf("Prev failed for hashdir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 > 199)
			cfprintf("Data failed for Prev hashdir at i=%d item=%d\n", i, myitem.a0);
		finds[myitem.a0] = myitem.a0;

		myitem.a0 = 0;
		if(cfprev(hd1, &myitem) != OK)
			cfprintf("Prev failed for treedir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 != i)
			cfprintf("Data failed for Prev treedir at i=%d item=%d\n", i, myitem.a0);

	}
	for(i = 0; i < 200; ++i)
		if(finds[i] != i)
			cfprintf("Hash find failed at i=%d data=%d\n", i, finds[i]);

	cfprintf("End seq_test1\n");
}
static void
seq_test2(void *hd, void *hd1)
{
long i;
Item myitem;
unsigned long finds[200];

	cfprintf("Begin seq_test2 -- dupnum inserts\n");
	myitem.a2.type = STO_VALUE;
	for(i = 0; i < 200; ++i)
	{
	long numdups;
		myitem.a0 = i;
		if(cfinsert_dupnum(hd, "NAME", 4, &myitem, &numdups) != OK)
			cfprintf("Insert failed for hash at i=%d\n", i);
		if(numdups != i+1)
			cfprintf("Wrong number of dups for hash is=%d should be=%d\n", numdups, i+1);
		if(cfinsert_dupnum(hd1, "NAME", 4, &myitem, &numdups) != OK)
			cfprintf("Insert failed for tree at i=%d\n", i);
		if(numdups != i+1)
			cfprintf("Wrong number of dups for tree is=%d should be=%d\n", numdups, i+1);
	}
	myitem.a0 = 1000;
	if(cfhead_dupnum(hd, "NAME", 4, &myitem) != OK)
		cfprintf("Head failed for hash dir.\n");
	if(myitem.a0 > 199)
		cfprintf("Data failed for Head hashdir =%d\n", myitem.a0);

	myitem.a0 = 1000;
	if(cftail_dupnum(hd, "NAME", 4, &myitem) != OK)
		cfprintf("Tail failed for hash dir.\n");
	if(myitem.a0 > 199)
		cfprintf("Data failed for Tail hashdir =%d\n", myitem.a0);
	
	myitem.a0 = 1000;
	if(cfhead_dupnum(hd1, "NAME", 4, &myitem) != OK)
		cfprintf("Head failed for tree dir.\n");
	if(myitem.a0 != 0)
		cfprintf("Data failed for Head treedir =%d\n", myitem.a0);
	if(cftail_dupnum(hd1, "NAME", 4, &myitem) != OK)
		cfprintf("Tail failed for tree dir.\n");	
	if(myitem.a0 != 199)
		cfprintf("Data failed for Tail treedir =%d\n", myitem.a0);

	cfhead_dupnum(hd, "NAME", 4, &myitem);
	finds[myitem.a0] = myitem.a0;
	cfhead_dupnum(hd1, "NAME", 4, &myitem);
	for(i = 1; i < 200; ++i)
	{
		if(cfnext_dupnum(hd, "NAME", 4, &myitem) != OK)
			cfprintf("Next failed for hashdir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 > 199)
			cfprintf("Data failed for Next hashdir at i=%d item=%d\n", i, myitem.a0);
		finds[myitem.a0] = myitem.a0;

		myitem.a0 = 0;
		if(cfnext_dupnum(hd1, "NAME", 4, &myitem) != OK)
			cfprintf("Next failed for treedir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 != i)
			cfprintf("Data failed for Next treedir at i=%d item=%d\n", i, myitem.a0);
	}
	cftail_dupnum(hd, "NAME", 4, &myitem);
	finds[myitem.a0] = myitem.a0;
	cftail_dupnum(hd1, "NAME", 4, NULL);
	for(i=198; i >= 0; --i)
	{
		if(cfprev_dupnum(hd, "NAME", 4, &myitem) != OK)
			cfprintf("Prev failed for hashdir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 > 199)
			cfprintf("Data failed for Prev hashdir at i=%d item=%d\n", i, myitem.a0);
		finds[myitem.a0] = myitem.a0;

		myitem.a0 = 0;
		if(cfprev_dupnum(hd1, "NAME", 4, &myitem) != OK)
			cfprintf("Prev failed for treedir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 != i)
			cfprintf("Data failed for Prev treedir at i=%d item=%d\n", i, myitem.a0);

	}
	for(i = 0; i < 200; ++i)
		if(finds[i] != i)
			cfprintf("Hash find failed at i=%d data=%d\n", i, finds[i]);

	cfprintf("End seq_test2\n");
}
static void
seq_test3(void *hd, void *hd1)
{
long i;
Item myitem;
unsigned long finds[200];

	cfprintf("Begin seq_test3 -- dupname inserts\n");
	myitem.a2.type = STO_VALUE;
	for(i = 0; i < 200; ++i)
	{
	DupName numdups;
		myitem.a0 = i;
		if(cfinsert_dupname(hd, "XXXX", 4, &myitem, &numdups) != OK)
			cfprintf("Insert failed for hash at i=%d\n", i);
		if(numdups.name != i+1)
			cfprintf("Wrong number of dups for hash is=%d should be=%d\n", numdups.name, i+1);
		if(cfinsert_dupname(hd1, "XXXX", 4, &myitem, &numdups) != OK)
			cfprintf("Insert failed for tree at i=%d\n", i);
		if(numdups.name != i+1)
			cfprintf("Wrong number of dups for tree is=%d should be=%d\n", numdups.name, i+1);
	}
	myitem.a0 = 1000;
	if(cfhead_dupname(hd, "XXXX", 4, &myitem) != OK)
		cfprintf("Head failed for hash dir.\n");
	if(myitem.a0 > 199)
		cfprintf("Data failed for Head hashdir =%d\n", myitem.a0);

	myitem.a0 = 1000;
	if(cftail_dupname(hd, "XXXX", 4, &myitem) != OK)
		cfprintf("Tail failed for hash dir.\n");
	if(myitem.a0 > 199)
		cfprintf("Data failed for Tail hashdir =%d\n", myitem.a0);
	
	myitem.a0 = 1000;
	if(cfhead_dupname(hd1, "XXXX", 4, &myitem) != OK)
		cfprintf("Head failed for tree dir.\n");
	if(myitem.a0 != 0)
		cfprintf("Data failed for Head treedir =%d\n", myitem.a0);
	if(cftail_dupname(hd1, "XXXX", 4, &myitem) != OK)
		cfprintf("Tail failed for tree dir.\n");	
	if(myitem.a0 != 199)
		cfprintf("Data failed for Tail treedir =%d\n", myitem.a0);

	cfhead_dupname(hd, "XXXX", 4, &myitem);
	finds[myitem.a0] = myitem.a0;
	cfhead_dupname(hd1, "XXXX", 4, &myitem);
	for(i = 1; i < 200; ++i)
	{
		if(cfnext_dupname(hd, "XXXX", 4, &myitem) != OK)
			cfprintf("Next failed for hashdir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 > 199)
			cfprintf("Data failed for Next hashdir at i=%d item=%d\n", i, myitem.a0);
		finds[myitem.a0] = myitem.a0;

		myitem.a0 = 0;
		if(cfnext_dupname(hd1, "XXXX", 4, &myitem) != OK)
			cfprintf("Next failed for treedir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 != i)
			cfprintf("Data failed for Next treedir at i=%d item=%d\n", i, myitem.a0);
	}
	cftail_dupname(hd, "XXXX", 4, &myitem);
	finds[myitem.a0] = myitem.a0;
	cftail_dupname(hd1, "XXXX", 4, NULL);
	for(i=198; i >= 0; --i)
	{
		if(cfprev_dupname(hd, "XXXX", 4, &myitem) != OK)
			cfprintf("Prev failed for hashdir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 > 199)
			cfprintf("Data failed for Prev hashdir at i=%d item=%d\n", i, myitem.a0);
		finds[myitem.a0] = myitem.a0;

		myitem.a0 = 0;
		if(cfprev_dupname(hd1, "XXXX", 4, &myitem) != OK)
			cfprintf("Prev failed for treedir at i=%d item=%d\n", i, myitem.a0);
		if(myitem.a0 != i)
			cfprintf("Data failed for Prev treedir at i=%d item=%d\n", i, myitem.a0);

	}
	for(i = 0; i < 200; ++i)
		if(finds[i] != i)
			cfprintf("Hash find failed at i=%d data=%d\n", i, finds[i]);

	cfprintf("End seq_test3\n");
}

