	SET TTHRU OFF
	LEGEND "Installing ANSI emulation"
;
; ----- Set an emulation, enabling both display and remap
;	commenced: 9/23/92 R.McG
; ----------------------------------------------------------------
;	Note: This script creates the file COM-AND.RMP on the default
;	subdirectory (if no COM-AND= subdir) or on the COM-AND= subdir.
;	An existing COM-AND.RMP is destroyed.
; ----------------------------------------------------------------
;
;	If COM-AND.RMP is on the current subdirectory, use it
;
	S0 = "COM-AND.RMP"              ; Default to current subdir
	IF ISFILE S0 GOTO WriteRMP	; Skip if on current subdir
;
;	Construct the file name with the COM-AND= pathing (if provided)
;
	ENVIRON S1 "COM-AND="           ; Look for COM-AND= environment var
	IF FOUND			; If environment variable found
	   S1 = S1&""                   ; Trim trailing blanks
	   LENGTH S1 N0 		; Get its length
	   IF N0 GT 0			; If trimmed len > 0
	      IF NOT STRCMP S1(n0-1:n0-1) "\" S1 = S1&"\"
	   ELSE
	      S1 = ""
	      ENDIF
	   S0 = S1&S0			; Concatenate path and name
	   ENDIF
;
;	Open the output file and write the remap
;
WriteRMP:
	S0 = "COM-AND.RMP"
	FOPENO S0 text
	IF FAILED
	   MESS "Cannot open "*S0
	   EXIT
	   ENDIF
	WRITE "^@S^A^@H^C^[[A^@P^C^[[B^@K^C^[[D^@M^C"  ; CurR and CurL inter-
	WRITE "^[[C^@G^C^[[H^@O^C^[[K^@v^G^[[H^[[ J^@"  ; changed; fix 7/93
	WRITE "^C^[[M^@w^C^[[L^@h^C^[Oq^@i^C^[Or^@j^C"
	WRITE "^[Os^@k^C^[Ot^@l^C^[Ou^@m^C^[Ov^@n^C^["
	WRITE "Ow^@o^C^[Ox^@p^C^[Oy^@q^C^[Op^@g^B^@q^@"
	WRITE "T^C^[OP^@U^C^[OQ^@V^C^[OS^@W^C^[OT^@X^C"
	WRITE "^[Om^@Y^C^[Ol^@Z^C^[OM^@[^C^[On"
;
;	Add a remap for F10 (help) if help script is installed
;
	IF ISSC "ANSI.HLP"
	   WRITE "^@D^JANSI.HLP^M^@^@"; The " " is char value 255
	   ENDIF
	FCLOSEO 			; Close the file
;
; ----- Enable display emulation and remap
;
	EMULATE ANSI			; Display emulation
	SET REMAP ON			; Load new remap file
	SET CR CR			; ANSI assumes LF has meaning
	EXIT
