S0 = "CdT"              ; values are: EST, CST, MST, PST, EDT, CDT, MDT, PDT
;
; ----- COM-AND set DOS clock
;
;	This script dials the US Naval Observatory and sets the DOS clock
;	with the time obtained.  NOTE: If you change this script, please
;	do not connect to the Observatory longer than absolutely required.
;	Courteous usage will most likely retain this service.
;
;	S0 should be set with your timezone (EST, CST, MST, or PST)... if
;	left blank, this script will look for an EBL variable &ZONE... if
;	that is not found, this script will ask for it.
;
;	Note that this script, as supplied, only invokes DOS's TIME command
;	to set the clock.  If you have a hardware clock, the TIME command of
;	DOS will not necessarily change the hardware clock (and thus last
;	accross a power off).
;
;	The value in S0, if supplied, establishes the timezone.  You must
;	manually decide (for now) if daylight savings is used in your area.
;
; ------------------------------------------------------------
;	Script: John Poindexter, commenced 2/89
;		Modified for scheduler	   4/93
; ------------------------------------------------------------
;
;	If the value in S0 is null, look for EBL's &ZONE
;	.. This script does not require EBL if the above is set.
;
LEGEND "SETTIME v1.0"
IF NULL S0		; If value not set above
   EBL S0 &ZONE 	; .. Ask EBL if it knows the zone
ELSE			; If set above
   SET SUCCESS ON	; .. Fake EBL good completion
   ENDIF
;
;	If no EBL and no value, open a window and ask
;
IF FAILED		; No zone in script, and no EBL
   WOPEN 10,1, 13,77 (contrast) Exit
   ATSAY 11, 3 (contrast) "Enter your timezone (EST, EDT, CST, CDT, ...)"
   ATSAY 12, 3 (contrast) "->"
   ATSAY 13,26 (contrast) " Press ESC to exit"
   ATGET 12,6  (contrast) 3 S0
   WCLOSE		; Restore screen under
   IF NULL S0 GOTO Exit ; Null entry terminates script
   ENDIF
;
;	Using the Zone value, look up the hour offset
;
S1 = "E5C6M7P8"         ; Time zone letters and time difference from GMT.
FIND S1 S0(0:0) N0	; Case insensitive table lookup
IF NOT FOUND		; Unknown zone character
   MESSAGE "^M^JYou need to include your time zone in S1 in script.^M^J"
   GOTO EXIT
   ENDIF
;
;	COmpute the hour offset (allowing for DAYLIGHT Savings)
;
S1 = S1(N0+1:N0+1)	; Take hour offset from table
ATOI S1 N0		; COnvert to binary (w/o error message)
IF FIND S0 "D"          ; Look for daylight savings time
   N0 = N0 - 1		; Adjust for daylight savings
   ENDIF
;
;	Set-up to dial the Naval Observatory
;
SET FLAG(0) OFF 	; Flag indicates wrap to previous day
ON ESCAPE GOSUB UNAVAILABLE

IF FIND "_DDOVER" "OFF" SET BAUD 1200 ; Set parms for USNO (1200...)
SET PARITY NONE 	; .. (n,8,1)
SET DATA 8		; ..
SET STOP 1		; ..
SET MDEL 30		; Slow it down
;
;	Dial the Naval Observatory
;
   N99 = 1
LOOP:
   LEGEND "SETTIME v1.0 dialing attempt #"*N99
   TRANSMIT "_MESCa"&"!"; Wake up the modem
   PAUSE 1
   TRANSMIT "_DPREf"&"1-202-653-0351"&"_DSUFf"&""  ; Dialing command

   WAITFOR  "_MCONn"&"" 45 ; Remember to trim trailing blanks
   IF NOT WAITFOR	; DIAL failed
      TRANSMIT "_MESCa"&"!"
      TRANSMIT "_MHANg"&""
      INC N99		; COunt the try
      IF N99 GT 10 GOTO Unavailable
      GOTO LOOP
      ENDIF
;
;	Read the UTC
;
GET_TIME:
   WAITFOR "*" 30
   RGET S0
   RGET S0
   MESSAGE S0
   IF NOT FIND S0(17:19) "UTC"
      GOTO GET_TIME
      ENDIF
;
;	Extract the time from the message
;
ATOI S0(10:11) N1	; Extract hour #
IF LT N1 N0		; Test for negative after adjust
   N1 = N1 + 24 	; Ensure positive hour number after adjust
   SET FLAG(0) ON	; .. and flag the fact
   ENDIF
;
;	And give the TIME to DOS
;
TIME S3 1		; Save current clock
N1 = N1 - N0		; Adjust for timezone
S1 = "TIME "*N1&":"&S0(12:13)&":"&S0(14:15)
DOS S1			; Tell DOS to set the clock
MESSAGE S1		; Display on screen too
CLOG "* SETTIME clock change from:" *S3*" to "*S1(5:79)
HANGUP
GOTO Exit
;
;	Failed DIAL
;
UNAVAILABLE:
   HANGUP
   MESSAGE "^M^JUnable to reach the Naval Observatory.^M^J"
   GOTO Exit
;
;	General exit (modem not connected yet)
;
EXIT:
   IF ISSC "$$$SCHED" EXECUTE "$$$SCHED"
   IF FCALLED FRETURN	; Return if called
   EXIT
