/*****************************************************************************
** Copyright (C) 1993 Todd J. Abel. All Rights Reserved
******************************************************************************
** File:	OUTLINE.HPP - Main outline routines
** Author:	Todd J. Abel
** History:	10/2/93	Creation
*****************************************************************************/

#ifndef OUTLINE_H
#define OUTLINE_H

#ifdef __cplusplus
extern "C" { 
#endif

/****************************************************************************
** Outline Message Declarations
****************************************************************************/
#define OL_BASE						WM_USER + 200
#define OL_ADD_NODE					OL_BASE + 1
#define OL_MOVE_FORWARD				OL_BASE + 2
#define OL_MOVE_BACKWARD			OL_BASE + 3
#define OL_INDENT_IN				OL_BASE + 4
#define OL_INDENT_OUT				OL_BASE + 5
#define OL_INDENT_NUMBERING			OL_BASE + 6
#define OL_ALLOW_APPEND				OL_BASE + 7
#define OL_ALLOW_DELETE				OL_BASE + 8
#define OL_ALLOW_EDIT				OL_BASE + 9
#define OL_ALLOW_INSERT				OL_BASE + 10
#define OL_SET_FONT					OL_BASE + 11
#define OL_GET_NODE_TEXT_SIZE		OL_BASE + 12
#define OL_GET_NODE_TEXT			OL_BASE + 13
#define OL_GET_TEXT_STREAM			OL_BASE + 14
#define OL_GET_TEXT_STREAM_SIZE		OL_BASE + 15
#define OL_SET_TEXT_STREAM			OL_BASE + 16
#define OL_SET_NODE_TEXT			OL_BASE + 17
#define OL_TOP						OL_BASE + 18
#define OL_BOTTOM					OL_BASE + 19
#define OL_DELETE					OL_BASE + 20
#define OL_INSERT					OL_BASE + 21
#define OL_NEXTCONTROL				OL_BASE + 22
#define OL_PREVCONTROL				OL_BASE + 23
#define OL_GET_NUM_NODES			OL_BASE + 24
#define OL_GET_FONT					OL_BASE + 25
#define OL_GET_CURRENT_NODE			OL_BASE + 26
#define OL_SET_MAX_INDENT_LEVEL		OL_BASE + 27
#define OL_GET_MAX_INDENT_LEVEL		OL_BASE + 28
#define OL_FLUSH					OL_BASE + 29
#define OL_SETREDRAW				OL_BASE + 30
#define OL_REDRAW					OL_BASE + 31
#define OL_GETREDRAW				OL_BASE + 32
#define OL_CANUNDO					OL_BASE + 33
#define OL_UNDO						OL_BASE + 34
#define OL_GET_INDENT_LEVEL			OL_BASE + 35
#define OL_GET_NUMBERING_STYLE		OL_BASE + 36

#define OL_LAST_MESSAGE				OL_BASE + 36

/****************************************************************************
** Outline Notification Message Declarations
****************************************************************************/
#define OLN_ADDNODE					1		// Notifications
#define OLN_CHANGE					2
#define OLN_DELNODE					3
#define OLN_INDENT				    4
#define OLN_INSNODE					5
#define OLN_KILLFOCUS				6
#define OLN_SELCHANGE				7
#define OLN_SETFOCUS				8 
#define OLN_VSCROLL					9
#define OLN_LBUTTONCLK				10
#define OLN_LBUTTONDBLCLK			11
#define OLN_RBUTTONCLK				12
#define OLN_RBUTTONDBLCLK			13
#define OLN_MBUTTONCLK				14
#define OLN_MBUTTONDBLCLK			15

/****************************************************************************
** Outline Style Declarations
****************************************************************************/
#define OLS_ALLOW_APPEND	0x0001
#define OLS_ALLOW_DELETE	0x0002
#define OLS_ALLOW_EDIT		0x0004
#define OLS_ALLOW_INSERT	0x0008
#define OLS_NONUMBERING		0x0010
#define OLS_NUMNUMBERING	0x0020
#define OLS_REDRAW			0x0040

/****************************************************************************
** Constant Declarations
****************************************************************************/
#define OL_NONODE			-1
#define OL_NOINDENT			-1
#define OL_ERROR			-1

#define OL_NUM_NONE			0x0000		// Numbering type constants
#define OL_NUM_NUMERIC		0x0001
#define OL_MAX_INDENT_LEVEL	0x0008		// Maximum number of indent levels                  

/****************************************************************************
** Function Declarations
****************************************************************************/
HWND __export CALLBACK OlCreateOutline(DWORD dwStyle, int X, int Y, int iWidth,
  								 int iHeight, HWND hParent, int nID);
#ifdef __cplusplus						   
} /* End Extern "C" */
#endif

#endif

