/* This program newsnet.c created by Hilgraeve and assigned to the NewsNet session */
/* runs an automated logon script for connecting to NewNet.                        */

/*	$Revision: 1.2 $  */
/*	$Date: 1993/10/27 16:07:55 $  */

/* Define main function, which is always the starting point of C programs. */
/* (The term "void" indicates that the function returns no value.) */
void main()
	{
	/* Declare variables */
	long ScriptHandle;
	int ReturnValue;
	char Buffer[128], LogLine[128];

	/* Initialize variables */
	ReturnValue = 0;
	ScriptHandle = 0;

	/* Establish a link between this script program and HA/Win */
	ScriptHandle = haInitialize(0,0,0,0);

	/* Exit if intialization of link with HA/Win failed */
	if (ScriptHandle == 0) exit();

	/* Set local echo on */
	haSetLocalEcho(ScriptHandle, 1);

	/* Type a '@' then <enter> */
	if (ReturnValue >= 0)
		ReturnValue = haTypeText(ScriptHandle, 0, "@");

	/* Pause */
	if (ReturnValue >= 0)
		haSleep(ScriptHandle, 1000L);

	/* Type a  <enter> */
	if (ReturnValue >= 0)
		ReturnValue = haTypeText(ScriptHandle, 0, "\r");

	/* Wait for one of three prompts possible with Tymenet or Telenet */
	if (ReturnValue >= 0)
		ReturnValue = haWaitForPrompt(ScriptHandle, 3, "ERMINAL=\0r name: \0identifier", 300L, 32000L);

	/* If Tymenet do this block */
	if (ReturnValue == 0)
		{
		/* Type an <enter> */
		ReturnValue = haTypeText(ScriptHandle, 0, "\r");

		/* Wait for a prompt */
		if (ReturnValue >= 0)
			ReturnValue = haWaitForPrompt(ScriptHandle, 1, "\r\n\r\n@", 300L, 32000L);

		/* Type text to request Newsnet */
		if (ReturnValue >= 0)
			ReturnValue = haTypeText(ScriptHandle, 0, "c net\r");

		/* Set local echo to off */
		if (ReturnValue >= 0)
			ReturnValue = haSetLocalEcho(ScriptHandle, 0);
		}
	/* If Telenet do this block */
	else
		{
		/* Type an 'a' */
		ReturnValue = haTypeText(ScriptHandle, 0, "a");

		/* Wait for a prompt */
		if (ReturnValue >= 0)
			ReturnValue = haWaitForPrompt(ScriptHandle, 1, "log in: ", 300L, 32000L);

		/* Type text requesting Newsnet */
		if (ReturnValue >= 0)
			ReturnValue = haTypeText(ScriptHandle, 0, "net\r");

		/* Set local echo to off */
		if (ReturnValue >= 0)
			ReturnValue = haSetLocalEcho(ScriptHandle, 0);
		}

	/* Wait for a prompt */
	if (ReturnValue >= 0)
		ReturnValue = haWaitForPrompt(ScriptHandle, 1, " on\r\n-->", 300L, 32000L);

	/* Get User ID value from Runtime Values dialog box */
	if (ReturnValue >= 0)
		ReturnValue = haGetRuntimeValue(ScriptHandle, 2, 1, 128, Buffer);

	/* Add value to logline */
	if (ReturnValue >= 0)
		{
		strcat(LogLine, "ID ");
		strncat(LogLine, Buffer, strlen(Buffer)-1);
		}

	/* Get Password value from Runtime Values dialog box */
	if (ReturnValue >= 0)
		ReturnValue = haGetRuntimeValue(ScriptHandle, 3, 1, 128, Buffer);

	/* Add a comma, then the password value to the logline */
	if (ReturnValue >= 0)
		{
		strcat(LogLine, " ");
		strcat(LogLine, Buffer);
		}

	/* Type the logline */
	if (ReturnValue >= 0)
		ReturnValue = haTypeText(ScriptHandle, 0, LogLine);

	/* Terminate link between HA/Win and script program */
	haTerminate(ScriptHandle, 0);
	}

