/* This program zm_send.c created by Hilgraeve, handles files that are drag and */
/* dropped from the file manager and sends them with zmodem  protocol to the remote system. */

/*	$Revision: 1.1 $  */
/*	$Date: 1993/04/26 15:21:58 $  */

/* Use pre-defined constants stored in the file defines.h */
#include <defines.h>

/* Define main function, which is always the starting point of C programs. */
/* (The term "void" indicates that the function returns no value.) */
void main ()
	{
	/* Declare variables */
	long ScriptHandle;
	int ReturnValue;
	
	/* Initialize variables */
	ScriptHandle = 0;
	ReturnValue = 0;
	
	/* Establish a link between this script program and HA/Win */
	ScriptHandle = haInitialize(0, 0, 0, 0);

	/* Exit if intialization of link with HA/Win failed */
	if (ScriptHandle == 0) exit();

	/* Set default sending protocol to zmodem */
	ReturnValue = haGetXferProtocol(ScriptHandle, HA_XFER_SEND);
	if (ReturnValue != HA_ZMODEM)
		ReturnValue = haSetXferProtocol(ScriptHandle, HA_XFER_SEND, HA_ZMODEM);

	/* Transfer the dropped file(s) */
	if (ReturnValue >= 0)
		haXferDropSend(ScriptHandle, 1);
	
	/* Terminate link between HA/Win and script program */
	haTerminate(ScriptHandle, 0);
	}

