/******************************
						BSP Demo
Compiled with TC++3.1. Memory model is large.
***********************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <alloc.h>
#include <math.h>
#include <dos.h>
#include <graphics.h>

/***************** Typedefs *******************/
typedef struct { int   name;
								 float x[3];      /* coordinate  */
								 } VTX;

#define FACE_LENGTH 8
typedef struct { int   name;
								 int   front;     /* front pointer */
								 int   back;      /* back pointer */
								 int   length;    /* number of vertices */
								 int   color;     /* color code */
								 int   vertex[FACE_LENGTH]; /* vertex list */
								 } FACE;

#define degtorad(a) (a*M_PI/180.)

/******************** Global variables ************/
float *x,*y;
int *visi;
int nv,nf;              /* Number of vertices and faces */
VTX *vtx;               /* vertices list  */
FACE *fl;               /* faces list */
double matrix[3][3];    /* transformations matrice  */
int xdisp_center,ydisp_center;
int stepmode;         /* control variable for the stepping mode */
extern int far _Cdecl svga_driver_far[];

/**************************/
int load( char *filname )  {
/* loads a file entered as call parameter */
	 FACE hf;
	 FILE *filin;
	 int i,j,k,n;
	 float hx[3];
	 char line[80];

	 filin = fopen(filname,"r");
	 if ( filin == NULL )  {
		 printf("File not found !\n");
		 return 1;
		 }
	 if ( fgets(line,80,filin) == NULL ) return 1;
	 sscanf(line,"%d,%d,",&nv,&nf);    /* read fdata base length */
	 /* and allocate memory */
	 vtx = ( VTX *)farmalloc(sizeof(VTX)*(nv+1));
	 fl = ( FACE *)farmalloc(sizeof(FACE)*(nf+1));
	 /* read vertices */
	 for ( i=0; i < nv; i++ )  {
		 fgets(line,80,filin);   /* get a whole line */
		 k = sscanf(line,"%d,%f,%f,%f,",&j,&hx[0],&hx[1],&hx[2]);
		 if ( k != 4 ) {
			 printf("read error at line %s\n",line);
			 goto out;
			 }
		 for ( n=0; n < 3; n++ ) vtx[j].x[n] = hx[n];
		 }
	 /* read faces */
	 for ( i=0; i < nf; i++ )  {
		 fgets(line,80,filin);
		 k = sscanf(line,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",&j,&hf.front,&hf.back,
							 &hf.length,&hf.color,&hf.vertex[0],&hf.vertex[1],&hf.vertex[2],
							 &hf.vertex[3],&hf.vertex[4],&hf.vertex[5],&hf.vertex[6],&hf.vertex[7]);
		 if ( k != hf.length + 5 ) {
			 printf("read error at line %s\n",line);
			 goto out;
			 }
		 fl[j] = hf;
		 fl[j].name = j;
		 }
out:
	 fclose(filin);
	 return 0;
	 }

/**************************/
void rot3( int axe, float angle, double *matrix)   {
/* get the rotation matrix for 'angle' about 'axe'.
Values assigned for axe: 0 => x, 1 => y, 2 => z  */
	 double *ptf,c,s;
	 int i,m1,m2;
	 int mm1[3] = { 1,2,0};
	 int mm2[3] = { 2,0,1};

	 for ( i=0, ptf = matrix; i < 9; i++) *ptf++ = 0;
	 m1 = mm1[axe];
	 m2 = mm2[axe];
	 ptf = matrix;
	 *( ptf + axe*4 ) = 1.;
	 c = cos(angle);
	 s = sin(angle);
	 *( ptf + m1*4) = c;
	 *( ptf + m2*4) = c;
	 *( ptf + m1*3+m2) = s;
	 *( ptf + m2*3+m1) = -s;
	 }

/****************************/
void mmult( double *a, double *b, double *c,int l, int m, int n)   {
/* Matrixmultiplication c = a * b
l = rows of a,n = columns of b
m = columns of a = rows of b  */
	 double *pa,*pb,x;
	 int i,j,k;
	 for ( i=0; i<l; i++)        /* over all rows of a  */
		 for ( j=0; j < n; j++ ) { /* over all columns of b  */
			 pa = a+i*m;
			 pb = b+j;
			 x = 0.0;
			 for ( k=0; k < m; k++ ) {
				 x += (*pa++) *(*pb);
				 pb += n;
				 }
			 *c++  = x;
			 }
	 }

/*********************/
void trafo( VTX *vl, int l)  {
/* Multiplicates the vertices list vl ( length l)
with the transformation matrix  */
	 int i,j,k;
	 register double *pm;
	 float delz,kz,coord[3];

	 delz = getmaxx()*3;  /* distance from observer to the display
	 = 3 x the display width, ( unit is pixel) */
	 for (i=1; i <= l; i++ ) {
		 for ( j=0,pm=matrix[0]; j < 3; j++ ) {
			 coord[j] = 0.;
			 for ( k=0; k<3; k++ )
//				 coord[j] += vl[i].x[k]* matrix[j][k];
				 coord[j] += vl[i].x[k]* *pm++;
			 }
		 /*  perspective */
		 if ( delz < -coord[2] ) coord[2] = - delz+0.001;  // durty but efficient
		 kz = delz/(delz+coord[2]);
		 x[i] = coord[0]*kz;
		 y[i] = coord[1]*kz;
		 }
	 }

/*****************************/
int face_visi( FACE *fac)  {
   int j1,j2,j3;
   float dx1,dx2,dy1,dy2;

	 j1 = fac->vertex[0];  /* namen of the three first */
	 j2 = fac->vertex[1];  /* vertices */
	 j3 = fac->vertex[2];

	 dx1 = x[j2] - x[j1];  /* vector (P1,P2)  = */
	 dy1 = y[j2] - y[j1];  /* first edge of the face */
	 dx2 = x[j3] - x[j2];  /* vector (P2,P3)  = */
	 dy2 = y[j3] - y[j2];  /* second edge */
	 dx1 = dx1*dy2 - dx2*dy1;  /* 2D cross product  */
	 if ( dx1 > 0) return 1; /* Polygon visible */
	 else return 0;      /* Polygon not visible */
	 }

/************************/
void draw( int k)  {
/* draws a polygon */
	 int n,nc,i,j,buf[FACE_LENGTH*4+2];
	 int xc[FACE_LENGTH+FACE_LENGTH+2],yc[FACE_LENGTH+FACE_LENGTH+2];

	 setcolor(fl[k].color);
	 setfillstyle(SOLID_FILL,fl[k].color);
	 nc = fl[k].length;
	 for ( j=0,n=0; j < nc; j++ )  {
		 i = fl[k].vertex[j];
		 buf[n++] = x[i] + xdisp_center;
		 buf[n++] = y[i] + ydisp_center;
		 }
	 fillpoly(nc,buf);
	 if ( nc >= 9 ) printf("%d\n",nc);
	 if ( stepmode )
		 if ( getch() == 's' ) stepmode = 0;
	 }

/************************/
void bsprun(int k)   {
/* run through the BSP-tree */
	 if ( k == 0 ) return;
	 if(visi[k]) {            /* if poly visible */
		 bsprun( fl[k].back );  /* go back */
		 draw(k);               /* draw poly k */
		 bsprun( fl[k].front ); /* and go to front */
		 }
	 else  {
		 bsprun( fl[k].front );
		 bsprun( fl[k].back );
		 }
	 }

/************************/
void load_table(char *name)	{
	 char line[80],col[256][3],*colpt;
	 FILE *filcol;
	int i,j,k,ir,ig,ib,c1,c2;
	struct REGPACK reg;

		filcol = fopen(name,"r");
		if ( filcol == NULL )	{
			printf("File %s not found !\n",name);
			getch();
			}
		else	{
			for ( i=0; i < 256; i++ )	{
				fgets(line,80,filcol);
				k = sscanf(line,"%d, %d, %d, %d",&j,&ir,&ig,&ib);
		//		printf( "%d %d %d  %d\n",ir,ig,ib,i);
				col[j][0] = ir>>2; col[j][1] = ig>>2; col[j][2] = ib>>2;
				}
		fclose(filcol);
		}

	reg.r_ax = 0x1012;
	reg.r_bx = 0;
	reg.r_cx = 256;
	colpt = &col[0][0];
	reg.r_es = FP_SEG(colpt);
	reg.r_dx = FP_OFF(colpt);
	intr(0x10,&reg);
	}

/********************/
void main( int argc, char *argv[])   {
	 int i,j,c,nt,act=0,externdr,paging=1;
	 char *drname,dri[4],buf[80],hbuf[80],*path;
	 float azit,elev,az,el,coef,coefh,delz,kz,scal;
	 float xmax,xmin,ymax,ymin,zmax,zmin;
	 double f[9],g[9],h[9],e[9];
	 int gdriver,gmode=0,errorcode;

	/*  check input parameters	*/
	for ( i=1,nt=externdr=0; i < argc; i++)	{
		if ( strncmpi(argv[i],"-d",2) == 0 )	{ drname = argv[i] + 2; externdr++; }
		if ( strncmpi(argv[i],"-m",2) == 0 ) gmode = atoi(argv[i]+2);
		if ( strncmpi(argv[i],"-p",2) == 0 ) paging = 0;
		if ( *argv[i] != '-') nt = i;
		}

	if ( argc == 1 || nt == 0 )	{
	printf("Usage:\nbsp filename.ext [-d[drivername]] [-m[graphic mode]] [-p]\n"
					"filename.ext     name of the data base\n"
					"drivername       name of the BGI driver for your card (optional)\n"
					"graph mode       3 (default) => 640 x 480; 4 => 800x600\n"
					"-p               switch, set paging off\n\n"
					"move view point with arrows keys,\n toggle to step mode with 's',\n"
					"zoom in with '+' and zoom out with '-',\n quit with Esc\n");
	exit(1);
		}

	if (externdr == 1 && gmode == 0)	{
		printf("if [drivername] is specified, [graphic mode] MUST be specified !\n");
		exit(1);
		}

	if ( externdr == 0 ) drname = "SVGA";
	else {
		fnsplit(argv[0],dri,buf,NULL,NULL);
		fnmerge(hbuf,dri,buf,NULL,NULL);
		path = hbuf;
		}
	gdriver = installuserdriver(drname,NULL);
	if ( externdr == 0 ) {
		if ( registerfarbgidriver(svga_driver_far) < 0 )	{
			errorcode = graphresult();
			printf(" %s\n", grapherrormsg(errorcode));
			}
		if ( gmode == 0 ) gmode = 3;		// detect mode for linked driver
		}
		/* initialize graphics and local variables */
		initgraph(&gdriver, &gmode, path);

	 /* read result of initialization */
	 errorcode = graphresult();
	 if (errorcode != grOk)  /* an error occurred */
	 {
			printf("Graphics error: %s\n", grapherrormsg(errorcode));
			printf("Press any key to halt:");
			getch();
			exit(1); /* terminate with an error code */
	 }

	 load_table("bsptree.pal");

	 if ( load( argv[nt] ) ) exit(0);   /* load file  */

	 x = (float *)malloc(sizeof(float)*(nv+1));
	 y = (float *)malloc(sizeof(float)*(nv+1));
	 visi = (int *)malloc(sizeof(int)*(nf+1));

	 xdisp_center = getmaxx()/2;  /* display center  */
	 ydisp_center = getmaxy()/2;
	 azit = 5;                   /* start values  */
	 elev = 265;
	 /*  get scale  */
	 xmax = ymax = zmax = -1.e30;
	 xmin = ymin = zmin = 1.e30;
	 for ( i=1; i<=nv; i++ ) {  /* get largest dimension */
		 if ( vtx[i].x[0] > xmax ) xmax = vtx[i].x[0];
		 if ( vtx[i].x[0] < xmin ) xmin = vtx[i].x[0];
		 if ( vtx[i].x[1] > ymax ) ymax = vtx[i].x[1];
		 if ( vtx[i].x[1] < ymin ) ymin = vtx[i].x[1];
		 if ( vtx[i].x[2] > zmax ) zmax = vtx[i].x[2];
		 if ( vtx[i].x[2] < zmin ) zmin = vtx[i].x[2];
		 }
	 vtx[0].x[0] = (xmax + xmin)/2;  /* data base center */
	 vtx[0].x[1] = (ymax + ymin)/2;
	 vtx[0].x[2] = (zmax + zmin)/2;
	 for ( i=1; i <= nv; i++ )   /* recenter DB */
		 for ( j=0; j<3; j++ )
			 vtx[i].x[j] -= vtx[0].x[j];
	 /* scaling factor */
	 coef = getmaxx() / (xmax - xmin);
	 coefh = getmaxy() / (ymax - ymin);
	 if ( coef > coefh ) coef = coefh;
	 coefh = getmaxy() / (zmax - zmin);
	 if ( coef > coefh ) coef = coefh;
	 coef *= 0.9;

	 /*  diagonal matrix for scaling */
	 for ( i=0; i < 9; f[i++] = 0.);

	 for(;;) {
		 az = degtorad(azit);
		 el = degtorad(elev);

		 f[0] = f[4] = f[8] = coef;
		 rot3(0,el,g);  /* rotation about elevation */
		 rot3(2,az,h);  /*    "        azimut */
		 mmult(g,h,e,3,3,3); /* Gesamtrotation  */
		 mmult(e,f,matrix[0],3,3,3);
		 /* vertices rotation  */
		 trafo(vtx,nv);
		 for ( i=1; i <= nf; i++ )  /* visibility test */
			 visi[i] = face_visi(&fl[i]);

		 if ( ! stepmode ) act ^= 1;
		 if ( paging ) setactivepage(act);
		 clearviewport();
		 bsprun(1);
		 if ( paging ) setvisualpage(act);

		c = getch();
		if ( c == 0 ) {
			c= getch();
			switch(c)	{
				case 75:	azit -= 5; break;		// left arrow
				case 77:  azit += 5; break;		// right
				case 72:  elev -= 5; break;		// up
				case 80:  elev += 5; break;		// down
				default: break;
				}
			}
		else switch ( c )  {
			 case 's': stepmode ^= 1;  break; /* step mode */
			 case '+': coef *= 1.2; break;   /* zoom */
			 case '-': coef *= 0.9; break;
			 case 27:                /* End with Escape */
				 closegraph();
				 free(x);
				 free(y);
				 free(visi);
				 exit(0);
			 default:  break;
			 }
		 }
	 }


