FUNC BIN2L
* Same as BIN2I() but takes a 32 bit signed integer.
  para str
  priv b0,b1,b2,b3,retval
  b0=asc(str)
  b1=asc(subs(str,2))
  b2=asc(subs(str,3))
  b3=asc(subs(str,4))
  if b3<128
    retval = ( ( (b3*256 + b2)*256 + b1) * 256 + b0)
  else
    b3=255-b3
*Note this is 2's complement, thus 255!
    b2=255-b2
    b1=255-b1
    b0=256-b0
    retval= -( ( (b3*256 + b2)*256 + b1) * 256 + b0)
  endif
retu retval

FUNC BIN2I
*Converts character string formatted as 16 bit signed integer to a numeric
*value.
  ara str
  priv b0,b1,retval
  b0=asc(str)
  b1=asc(subs(str,2))
  if b1<128
    retval=b1 * 256 + b0
  else
*   Note this is 2's complement, thus 255!
    b1=255-b1
    b0=256-b0
    retval= -( (b1 * 256) + b0)
  endif
retu retval

FUNC BIN2W
*BIN2W() Same as BIN2I() but takes a 16 bit unsigned integer.
  para str
  priv b0,b1,retval
  b0=asc(str)
  b1=asc(subs(str,2))
  retval=b1 * 256 + b0
retu retval

FUNC L2BIN
  para num
  priv x,b,i,b0,b1,b2,b3,t,neg
  if num<0
    x=int(-num)
    neg=.t.
  else
    x=int(num)
    neg=.f.
  endif
  *Can't use arrays cuz clipper and FP use diff syntax
  for i=3 to 0 step -1
    t=chr(48+i)
    b=in(x/(256^i))
    b&t=iif(neg,iif(i=0,256,255) -b, b)
    x=x-b*(256^i)
  endfor
  if neg
    if b0=256
      b0=0
      b1=b1+1
    endif
    if b1=256
      b1=0
      b2=b2+1
    endif
    if b2=256
      b2=0
      b3=b3+1
    endif
  endif
retu chr(b0)+chr(b1)+chr(b2)+chr(b3)

FUNC I2BIN
  para num
  priv b0,b1,mretval
  if num>=0
    x=int(num)
    b1=int(x/256)
    b0=mod(x,256)
  else
    x=int(-num)
    b1=255-int(x/256)
    b0=256-mod(x,256)
    if b0=256
      b0=0
      b1=b1+1
    endif
  endif
  retu chr(b0)+chr(b1)