#include<stdio.h>
#include<fcntl.h>
#include<bios.h>

struct header_s
	{
	unsigned char mfgr;
	unsigned char version;
	unsigned char encoding;
	unsigned char bppix;
	unsigned short xmin;
	unsigned short ymin;
	unsigned short xmax;
	unsigned short ymax;
	unsigned short hdpi;
	unsigned short vdpi;
	unsigned char cmap[48];
	unsigned char reserved;
	unsigned char nplanes;
	unsigned short bypl;
	unsigned short paltinf;
	unsigned short hscrnsz;
	unsigned short vscrnsz;
	unsigned char filler[54];
	};

struct header_s header;

unsigned char buf[17280], bybuf[216], fbuf[8192];

main(argc, argv)
	int argc;
	char **argv;
	{
	int ifd, vsiz, totbyts, n, curbyt, lptnum, fbufn;
	int i, icnt, j, nbyts, totbpl, vdstate, hdstate, fbufindex, stripen;
	unsigned char c, nlo, nhi, imask, jmask, bitmask;
	if(argc!=3)
		{
		fprintf(stderr, "USAGE: bjfaxpcx <lpt #> <file>\n");
		exit(1);
		}
	if(sscanf(argv[1], "%d", &lptnum)!=1)
		{
		fprintf(stderr, "Bad scan of LPT number.\n");
		exit(10);
		}
	lptnum--;
	if((ifd=open(argv[2], O_RDONLY|O_BINARY))==-1)
		{
		fprintf(stderr, "Couldn't open %s for read.\n", argv[2]);
		exit(2);
		}
	read(ifd, &header, 128);
	fprintf(stderr, "Got header OK.\n");
	if(header.encoding!=1)
		{
		fprintf(stderr, "Bad type of encoding declared in header.\n");
		exit();
		}
	if(header.nplanes!=1)
		{
		fprintf(stderr, "Only one plane allowed.\n");
		exit();
		}
	if(header.bppix!=1)
		{
		fprintf(stderr, "Grayscale.\n");
		exit();
		}
	if((header.xmax-header.xmin)!=1727)
		{
		printf("Wrong width.\n");
		exit();	
		}
	fprintf(stderr, "All checks OK.\n");
	vsiz=header.ymax-header.ymin+1;
	totbpl=header.bypl;
	totbyts=totbpl*vsiz;
	curbyt=n=vdstate=hdstate=stripen=0;
	bitmask=0x80;
	for(i=0;i<17280;++i)
		buf[i]=0;
	fbufindex=fbufn=0;
	for(;;)
		{
		if(fbufindex>=fbufn)
			{
			fbufn=read(ifd, fbuf, 8192);
			fbufindex=0;
			}
		c=fbuf[fbufindex++];
		if((c & (unsigned char) 0xc0)== (unsigned char) 0xc0)
			{
			i = c & (unsigned char) 0x3f;
			if(fbufindex>=fbufn)
				{
				fbufn=read(ifd, fbuf, 8192);
				fbufindex=0;
				}
			c=fbuf[fbufindex++];
			while(i--)
				bybuf[n++]=c;
			}
		else
			bybuf[n++]=c;
		if(n>=totbpl)
			{
			if(n!=totbpl)
				{
				fprintf(stderr, "Mismatch.\n");
				exit();
				}
			if(vdstate)
				{
				for(i=0,j=0,jmask=0x80,hdstate=0,icnt=216;icnt;i++,icnt--)
					for(imask=0x80;imask;imask>>=1)
						{
						if(bybuf[i]&imask)
							;
						else
							buf[j+curbyt]|=bitmask;
						j+=6;
						if(hdstate)
							{
							if(bybuf[i]&imask)
								;
							else
								buf[j+curbyt]|=bitmask;
							j+=6;
							}
						if(hdstate++==2)
							hdstate=0;
						}
				if((!(bitmask>>=1))||(totbyts==n))
					{
					bitmask=0x80;
					if((++curbyt==6)||(totbyts==n))
						{
						fprintf(stderr, "Sending stripe %d\n", ++stripen);
						nbyts=17280+1;
						nlo=nbyts%256;
						nhi=nbyts/256;
						c='\033';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c='[';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c='g';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						_bios_printer(_PRINTER_WRITE, lptnum, nlo);
						_bios_printer(_PRINTER_WRITE, lptnum, nhi);
						c=16;
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						for(i=0,icnt=17280;icnt;i++,icnt--)
							_bios_printer(_PRINTER_WRITE, lptnum, buf[i]);
						c='\r';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c='\034';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c='C';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c='J';
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c=0;
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						c=24;
						_bios_printer(_PRINTER_WRITE, lptnum, c);
						curbyt=0;
						for(i=0,icnt=17280;icnt;++i,--icnt)
							buf[i]=0;
						}
					}
				}
			if(vdstate++==3)
				vdstate=0;
			for(i=0,j=0,jmask=0x80,hdstate=0,icnt=216;icnt;i++,icnt--)
				for(imask=0x80;imask;imask>>=1)
					{
					if(bybuf[i]&imask)
						;
					else
						buf[j+curbyt]|=bitmask;
					j+=6;
					if(hdstate)
						{
						if(bybuf[i]&imask)
							;
						else
							buf[j+curbyt]|=bitmask;
						j+=6;
						}
					if(hdstate++==2)
						hdstate=0;
					}
			if((!(bitmask>>=1))||(totbyts==n))
				{
				bitmask=0x80;
				if((++curbyt==6)||(totbyts==n))
					{
					fprintf(stderr, "\rSending stripe %d\n", ++stripen);
					nbyts=17280+1;
					nlo=nbyts%256;
					nhi=nbyts/256;
					c='\033';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c='[';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c='g';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					_bios_printer(_PRINTER_WRITE, lptnum, nlo);
					_bios_printer(_PRINTER_WRITE, lptnum, nhi);
					c=16;
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					for(i=0,icnt=17280;icnt;i++,icnt--)
						_bios_printer(_PRINTER_WRITE, lptnum, buf[i]);
					c='\r';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c='\034';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c='C';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c='J';
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c=0;
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					c=24;
					_bios_printer(_PRINTER_WRITE, lptnum, c);
					curbyt=0;
					for(i=0,icnt=17280;icnt;++i,icnt--)
						buf[i]=0;
					}
				}
			totbyts-=n;
			if(!totbyts)
				{
				close(ifd);
				c='\n';
				_bios_printer(_PRINTER_WRITE, lptnum, 0x0c);
				fprintf(stderr, "\nFinished correctly.\n");
				exit();
				}
			n=0;
			}
		}
	}
