/* Copyright (C) 1993 Peter Edward Cann */

#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>
#include<stdlib.h>
#include<malloc.h>
#include<signal.h>
#include<bios.h>
#include<dos.h>
#include"port.h"
#include"tperday.h"


unsigned long tick;

void (interrupt far *oldtick)();

void interrupt far tickhndl()
	{
	tick++;
	}

sendchar(c)
	unsigned char c;
	{
	while(!((inp(basereg+STATREG)&TXMTMASK)&&(inp(basereg+MSTATREG)&CTSMASK)));
	outp(basereg, c);
	}

#define VBUFSIZ 65408 /* leave random amount of room for alloc overhead */
#define MAXVBUFS 8

unsigned char *(bufbuf[MAXVBUFS]);
unsigned vbufi;
int bufbufi, nvbufs; /* n may be < MAX 'cause we alloc dynamically */

int putbyte(c)
	unsigned char c;
	{
	if(vbufi>=VBUFSIZ)
		{
		vbufi=0;
		if((++bufbufi)>=nvbufs)
			return(-1);
		}
	bufbuf[bufbufi][vbufi++]=c;
	return(0);
	}

int follow;

quit()
	{
	sendchar('X'&31);
	while(!(inp(basereg+STATREG)&TXSHMTMASK));
	cleanup(0);
	exit(129);
	}

sendstr(str)
	char *str;
	{
	int i;
	for(i=0;str[i]!='\0';++i)
		sendchar(str[i]);
	}

int follow;

#define NSCANS 3
unsigned char scans[NSCANS][16]={"CONNECT\r\n", "ERROR\r\n", "VCON\r\n"};
#define SCANTIMEOUT 16

int scan()
	{
	time_t timestamp;
	int i, j, scani[NSCANS];
	timestamp=time(NULL);
	for(i=0;i<NSCANS;++i)
		scani[i]=0;
	while(1)
		{
		while(follow==index)
			{
			if(kbhit())
				getch();
			if((time(NULL)-timestamp)>SCANTIMEOUT)
				{
				for(j=0;j<NSCANS;j++)
					scani[j]=0;
				return(-1);
				}
			}
		putch(buf[follow]);
		for(i=0;i<NSCANS;i++)
			if(scans[i][scani[i]]==buf[follow])
				{
				scani[i]++;
				if(scans[i][scani[i]]=='\0')
					{
					for(j=0;j<NSCANS;j++)
						scani[j]=0;
					follow++;
					follow%=TBUFSIZ;
					return(i);
					}
				}
			else
				scani[i]=0;
		follow++;
		follow%=TBUFSIZ;
		}
	}

main(argc, argv)
	int argc;
	char **argv;
	{
	int dleflag, i, fd, tflag;
	unsigned char c;
	long start, stop;
	if((argc!=4)&&(argc!=6))
		{
		printf("USAGE: ramrec <comnum> <speed> <file> [<start> <stop>]\n");
		printf("\n<start> is number of ticks to wait after a DTMF report before starting.\n");
		printf("<stop> is number of ticks after the tone report to end.\n");
		printf("\nNormal exit code is 128.\n");
		exit(140);
		}
	if((fd=open(argv[3], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf("Unable to open voice file %s for write.\n", argv[3]);
		exit(150);
		}
	for(nvbufs=0;nvbufs<MAXVBUFS;nvbufs++)
		if((bufbuf[nvbufs]=malloc(VBUFSIZ))==NULL)
			break;
	printf("Allocated %d sub-buffers.\n", nvbufs);
	if(!nvbufs)
		exit(246);
	if(argc==6)
		{
		tflag=1;
		start=atol(argv[4]);
		stop=atol(argv[5]);
		}
	else
		tflag=0;
	vbufi=bufbufi=0;
	comnum=atoi(argv[1])-1;
	speed=atoi(argv[2]);
	databits='8';
	parity='n';
	stopbits='1';
	setport();
	readset();
	follow=index=0;
	printf("Recording voice. Any char to end; Control-C to nuke.\n");
	oldtick=_dos_getvect(0x1c);
	signal(SIGINT, quit);
	_dos_setvect(0x1c, tickhndl);
	setup();
	if(tflag)
		{
		while(1)
			{
			while(index==follow)
				if(_bios_keybrd(_KEYBRD_READY))
					{
					_bios_keybrd(_KEYBRD_READ);
					cleanup(0);
					_dos_setvect(0x1c, oldtick);
					exit(0);
					}
			c=buf[follow++];
			if(follow>=TBUFSIZ)
				follow=0;
			if(((c>='0')&&(c<='9'))||(c=='*')||(c=='#'))
				break;
			}
		tick=0L;
		while(1)
			{
			if(_bios_keybrd(_KEYBRD_READY))
				{
				_bios_keybrd(_KEYBRD_READ);
				cleanup(0);
				_dos_setvect(0x1c, oldtick);
				exit(0);
				}
			if(tick>=start)
				break;
			}
		}
	sendstr("AT#VRX\r");
	switch(scan())
		{
		case -1:
			cleanup(0);
			printf("Timeout waiting for CONNECT.\n");
			_dos_setvect(0x1c, oldtick);
			exit(130);
			break;
		case 0:
			break;
		case 1:
			cleanup(0);
			printf("Modem rejected play command.\n");
			_dos_setvect(0x1c, oldtick);
			exit(131);
			break;
		default:
			cleanup(0);
			printf("Impossible error; unrecognized scan() return.\n");
			_dos_setvect(0x1c, oldtick);
			exit(132);
			break;
		}
	dleflag=0;
	while(1)
		{
		while(follow==index)
			{
			if(_bios_keybrd(_KEYBRD_READY))
				{
				sendchar('\r'); /*kick modem & cross fingers*/
				if((_bios_keybrd(_KEYBRD_READ)&0xff)==0x03)
					quit();
				}
			if(tflag)
				{
				if(tick>stop)
					{
					sendchar('\r');
					/* Modem doesn't like huge mess */
					/* of key abort characters.     */
					if(tick>=36)
						tick-=36;
					else
						tick=0;
					}
				}
			}
		c=buf[follow++];
		if(follow>=TBUFSIZ)
			follow=0;
		if(c==0x10)
			{
			if(dleflag)
				{
				putbyte(0x10);
				putbyte(0x10);
				dleflag=0;
				}
			else
				dleflag=1;
			}
		else if(!dleflag)
			{
			/* Open-coded putbute() */
			if(vbufi>=VBUFSIZ)
				{
				vbufi=0;
				if((++bufbufi)>=nvbufs)
					return(-1);
				}
			bufbuf[bufbufi][vbufi++]=c;
			}
		else if(c==0x03)
			{
			putbyte(0x10);
			putbyte(0x03);
			scan(); /* Wait for VCON or whatever */
			cleanup(0);
			for(i=0;i<bufbufi;i++)
				if(((unsigned)write(fd, bufbuf[i], VBUFSIZ))!=((unsigned)VBUFSIZ))
					{
					printf("Disk buffer flush error.\n");
					_dos_setvect(0x1c, oldtick);
					exit(160);
					}
			if(write(fd, bufbuf[bufbufi], vbufi)!=vbufi)
				{
				printf("Disk buffer flush error.\n");
				_dos_setvect(0x1c, oldtick);
				exit(160);
				}
			_dos_setvect(0x1c, oldtick);
			exit(128);
			}
		else
			dleflag=0; /* ignore shielded codes */
		}
	printf("Programming error; fell through endless while loop!\n");
	cleanup(0);
	_dos_setvect(0x1c, oldtick);
	exit(250);
	}
