#include<stdio.h>
#include<fcntl.h>
#include<sys\types.h>
#include<sys\stat.h>

#define BSIZ 2048

unsigned char putbuf[BSIZ], getbuf[BSIZ];

int infd, outfd, putptr, getptr, gettop;

putbyte(byte)
	{
	putbuf[putptr++]=byte;
	if(putptr>=BSIZ)
		if(write(outfd, putbuf, BSIZ)!=BSIZ)
			{
			printf("Write error.\n");
			exit(10);
			}
		else
			putptr=0;
	}

unsigned char getbyte()
	{
	if(getptr>=gettop)
		{
		if((gettop=read(infd, getbuf, BSIZ))==-1)
			{
			printf("Read error.\n");
			exit(11);
			}
		getptr=0;
		}
	return(getbuf[getptr++]);
	}

putstr(str)
	unsigned char *str;
	{
	char *cptr;
	for(cptr=str;*cptr;cptr++)
		putbyte(*cptr);
	}

unsigned char bassack[256];

main(argc, argv)
	int argc;
	char **argv;
	{
	unsigned char c, otherc;
	int page, i;
	page=0;
	if(argc!=3)
		{
		printf("USAGE: sfxtorfx <sfx file> <rfx file>\nInclude suffixes.\n\n");
		exit(1);
		}
	if((infd=open(argv[1], O_RDONLY|O_BINARY))==-1)
		{
		printf("Error opening %s for read.\n", argv[1]);
		exit(2);
		}
	if((outfd=open(argv[2], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, S_IWRITE))==-1)
		{
		printf("Error opening %s for write.\n", argv[2]);
		exit(3);
		}
	for(i=0;i<256;++i)
		for(bassack[i]=0,c=0x01,otherc=0x80;c;c<<=1,otherc>>=1)
			if(c&i)
				bassack[i]|=otherc;
	putptr=getptr=gettop=0;
	putstr("\r\n+FCON\r\n\r\n+FTSI: \"PCCP SFXTORFX HACK  \"\r\n");
	putstr("\r\n+FDCS: 1,3,0,2,0,0,0,0\r\n\r\nOK\r\n");
	putstr("\r\n+FCFR\r\n\r\n+FDCS: 1,3,0,2,0,0,0,0\r\n");
	putstr("\r\nCONNECT\r\n");
	printf("Page %d...", ++page);
	while(1)
		{
		if((c=getbyte())==0x10)
			if((c=getbyte())==0x10)
				putbyte(0x08);
			else if(c==0x03)
				{
				printf("\nPage %d...", ++page);
				putbyte(0x10);
				putbyte(0x03);
				putstr("\r\n+FPTS: 1,2219,0,0\r\n");
				putstr("\r\n+FET: 0\r\n");
				putstr("\r\nOK\r\n\r\n+FDR\r\n");
				putstr("\r\n+FDCS: 1,3,0,2,0,0,0,0\r\n");
				putstr("\r\nCONNECT\r\n");
				}
			else if(c==0x04)
				break;
			else
				{
				printf("Bogus shielded character hex %02x.\n", c);
				exit(20);
				}
		else if(c==0x08)
			{
			putbyte(0x10);
			putbyte(0x10);
			}
		else
			putbyte(bassack[c]);
		}
	putbyte(0x10);
	putbyte(0x03);
	putstr("\r\n+FPTS: 1,2219,0,0\r\n");
	putstr("\r\n+FET: 2\r\n\r\nOK\r\n\r\n+FHNG: 0\r\n\r\nOK\r\n");
	if(putptr)
		if(write(outfd, putbuf, putptr)!=putptr)
			{
			printf("Write error in flush.\n");
			exit(13);
			}
	printf("\n\nAll done.\n");
	}