/*  ==================================================================	*
 *				Editor mined				*
 *			Command and character set mappings		*
 *  ==================================================================	*/

#include "mined.h"

#define iso_latin_1

#ifdef msdos
#undef iso_latin_1
#undef dec_sup
#define pc_charset
#endif

/*  ==================================================================	*
 *			8 bit character constant stuff			*
 *  ==================================================================	*/

#ifdef pc_charset
char TABdefault = 250;
char SHIFT_MARK = 175;		/* Char indicating that line continues */
uchar ring = 248;
#else
char TABdefault = '';
char SHIFT_MARK = '';		/* Char indicating that line continues */
uchar ring = '';
#endif

int
idfchar (ch)
  uchar ch;
{
  return ('0' <= ch && ch <= '9') ||
	 ('A' <= ch && ch <= 'Z') ||
	 ('a' <= ch && ch <= 'z') ||
#ifdef pc_charset
	 ((uchar) '\200' <= ch && ch <= (uchar) '\232') ||
	 ((uchar) '\240' <= ch && ch <= (uchar) '\245') ||
	 ((uchar) '\340' <= ch && ch <= (uchar) '\353') ||
#ifdef cp850
/* Whoever wishes to include an automatic and complete (?!) handling 
   of Microsoft's rotten codepage chaos, is invited to do so. */
	 ((uchar) '\265' <= ch && ch <= (uchar) '\267') ||
	 ((uchar) '\320' <= ch && ch <= (uchar) '\330') ||
	 (ch == (uchar) '\233') ||
	 (ch == (uchar) '\235') ||
	 (ch == (uchar) '\306') ||
	 (ch == (uchar) '\307') ||
	 (ch == (uchar) '\336') ||
	 (ch == (uchar) '\354') ||
	 (ch == (uchar) '\355') ||
#endif
#else
	 ((uchar) '\300' <= ch && ch != (uchar) '' && ch != (uchar) '') ||
	 (ch == (uchar) '') ||
#endif
	 (ch == '_');
}

/*  ==================================================================	*
 *		MSDOS Video mode switching table			*
 *  ==================================================================	*/

struct {
	int mode, cols, lins;
} modetab [] =
{ /* list of available modes, unsorted, terminated by a '-1' mode */
  /* the entries contain:
	a video mode number (restriction to text modes preferable),
	the numbers of columns and of lines which can be displayed 
		in that mode if a font of height 16 is used */
  {42, 100, 40},
  {38, 80, 60},
  {36, 132, 28},
  {35, 132, 25},
  {34, 132, 44},
  { 3, 80, 25},
  { 1, 40, 25},
  {-1, 0, 0}
};

/*  ==================================================================	*
 *			Character set coding				*
 *  ==================================================================	*/

/*
 * Determine a default diacritic character value for _readchar ().
 * The characters are given literally except for the MSDOS version in order
 * not to depend on the function of a character set translator.
 * For all non-MSDOS platforms, ISO-Latin1 or the very similar 
 * DEC-Supplemental are assumed.
 * For MSDOS, characters for the "International Codepage" ("850") are 
 * generated which includes the real letters (not all graphic and Greek 
 * characters) of the old IBM codepage ("437") (which, by the way, some 
 * time ago someone must have designed in an attack of mental sickness).
 */
uchar
diacritic (c)
  uchar c;
{
  /*	the following characters cannot be inserted by this function:
	 (ISO-Latin-1) and MSDOS graphics characters */
  switch (c) {
#ifdef pc_charset
	case 'C' : return 128;
	case 'c' : return 135;
	case 'N' : return 165;
	case 'n' : return 164;
	case 's' : return 225;
	case '!' : return 173;
	case '$' : return 189;
	case '/' : return 189;
	case 'l' : return 156;
	case 'L' : return 156;
	case 'Y' : return 190;
	case '+' : return 241;
	case '?' : return 168;
	case '0' : return 248;
	case '1' : return 251;
	case '2' : return 253;
	case '3' : return 252;
	case '<' : return 174;
	case '>' : return 175;
	case ':' : return 246;
	case 'x' : return 158;
	case 'f' : return 159;
	case 'D' : return 209;
	case 'd' : return 208;
	case 'P' : return 232;
	case 'p' : return 231;
	case 'i' : return 213;
	case '|' : return 221;
	case '&' : return 244;
	case '\\' : return 170;
	case '_' : return 238;
	case '-' : return 196;
	case 'm' : return 230;
	case '=' : return 242;
	case '#' : return 245;
	case '.' : return 250;
	case ',' : return 247;
	case '\'' : return 239;
	case 'X' : return 207;
#else
	case 'C' : return '';
	case 'c' : return '';
	case 'N' : return '';
	case 'n' : return '';
	case 's' : return '';
	case '!' : return '';
	case '$' : return '';
	case '/' : return '';
	case 'l' : return '';
	case 'L' : return '';
	case 'Y' : return '';
	case '+' : return '';
	case '?' : return '';
	case '0' : return '';
	case '2' : return '';
	case '<' : return '';
	case '>' : return '';
	case 'D' : return '';
	case 'd' : return '';
	case 'P' : return '';
	case 'p' : return '';
	case '|' : return '';
	case '&' : return '';
	case '\\' : return '';
	case '_' : return '';
	case '-' : return '';
	case 'm' : return '';
	case '#' : return '';
	case '.' : return '';
	case '*' : return '';
	case ',' : return '';
	case '\'' : return '';
	case '1' : return '';
	case '3' : return '';
#ifdef iso_latin_1
	case 'X' : return '';
	case '"' : return '';
	case 'x' : return '';
	case ':' : return '';
#endif
#ifdef dec_sup
	case 'X' : return ''; /*  */
#endif
#endif
	default: return c;
  }
}

uchar
grave (ch)
  uchar ch;
{
	switch (ch) {
#ifdef pc_charset
		case 'A' : return 183;
		case 'E' : return 212;
		case 'I' : return 222;
		case 'O' : return 227;
		case 'U' : return 235;
		case 'a' : return 133;
		case 'e' : return 138;
		case 'i' : return 141;
		case 'o' : return 149;
		case 'u' : return 151;
#else
		case 'A' : return '';
		case 'E' : return '';
		case 'I' : return '';
		case 'O' : return '';
		case 'U' : return '';
		case 'a' : return '';
		case 'e' : return '';
		case 'i' : return '';
		case 'o' : return '';
		case 'u' : return '';
#endif
		default : return diacritic (ch);
	}
}
uchar
circumflex (ch)
  uchar ch;
{
	switch (ch) {
#ifdef pc_charset
		case 'A' : return 182;
		case 'E' : return 210;
		case 'I' : return 215;
		case 'O' : return 226;
		case 'U' : return 234;
		case 'a' : return 131;
		case 'e' : return 136;
		case 'i' : return 140;
		case 'o' : return 147;
		case 'u' : return 150;
#else
		case 'A' : return '';
		case 'E' : return '';
		case 'I' : return '';
		case 'O' : return '';
		case 'U' : return '';
		case 'a' : return '';
		case 'e' : return '';
		case 'i' : return '';
		case 'o' : return '';
		case 'u' : return '';
#endif
		default : return diacritic (ch);
	}
}
uchar
acute (ch)
  uchar ch;
{
	switch (ch) {
#ifdef pc_charset
		case 'A' : return 181;
		case 'E' : return 144;
		case 'I' : return 214;
		case 'O' : return 224;
		case 'U' : return 233;
		case 'a' : return 160;
		case 'e' : return 130;
		case 'i' : return 161;
		case 'o' : return 162;
		case 'u' : return 163;
		case 'Y' : return 237;
		case 'y' : return 236;
		case ' ' : return 239;
#else
		case 'A' : return '';
		case 'E' : return '';
		case 'I' : return '';
		case 'O' : return '';
		case 'U' : return '';
		case 'a' : return '';
		case 'e' : return '';
		case 'i' : return '';
		case 'o' : return '';
		case 'u' : return '';
		case ' ' : return '';
#ifdef iso_latin_1
		case 'Y' : return '';
		case 'y' : return '';
#endif
#endif
		default : return diacritic (ch);
	}
}
uchar
diaeresis (ch)
  uchar ch;
{
	switch (ch) {
#ifdef pc_charset
		case 'A' : return 142;
		case 'E' : return 211;
		case 'I' : return 216;
		case 'O' : return 153;
		case 'U' : return 154;
		case 'a' : return 132;
		case 'e' : return 137;
		case 'i' : return 139;
		case 'o' : return 148;
		case 'u' : return 129;
		case 'y' : return 152;
		case ' ' : return 249;
#else
		case 'A' : return '';
		case 'E' : return '';
		case 'I' : return '';
		case 'O' : return '';
		case 'U' : return '';
		case 'a' : return '';
		case 'e' : return '';
		case 'i' : return '';
		case 'o' : return '';
		case 'u' : return '';
#ifdef iso_latin_1
		case ' ' : return '';
		case 'y' : return '\377'; /* '' aborts sun compiler */
#endif
#ifdef dec_sup
		case 'Y' : return ''; /* capital  */
		case 'y' : return ''; /*  */
#endif
#endif
		default : return diacritic (ch);
	}
}
uchar
tilde (ch)
  uchar ch;
{
	switch (ch) {
#ifdef pc_charset
		case 'A' : return 199;
		case 'O' : return 229;
		case 'a' : return 198;
		case 'o' : return 228;
#else
		case 'A' : return '';
		case 'O' : return '';
		case 'a' : return '';
		case 'o' : return '';
#ifdef dec_sup
		case 'E' : return ''; /* OE */
		case 'e' : return ''; /* oe */
#endif
#endif
		default : return diacritic (ch);
	}
}
uchar
angstrom (ch)
  uchar ch;
{
	switch (ch) {
#ifdef pc_charset
		case 'A' : return 143;
		case 'E' : return 146;
		case 'O' : return 157;
		case 'a' : return 134;
		case 'e' : return 145;
		case 'o' : return 155;
		case 'R' :
		case 'r' : return 169;
		case 'C' :
		case 'c' : return 184;
#else
		case 'A' : return '';
		case 'E' : return '';
		case 'O' : return '';
		case 'a' : return '';
		case 'e' : return '';
		case 'o' : return '';
#endif
		default : return diacritic (ch);
	}
}

/*  ==================================================================	*
 *		key and function key -> command mapping			*
 *  ==================================================================	*/

/* The mapping between input codes and functions */

#ifdef unix
#define NULLcmd BAD
#define BSPcmd MLF
#endif
#ifdef msdos
#define NULLcmd FUNKEY	/* since FUNcmd is 0 */
#define BSPcmd DPC
#endif
#ifdef vms
#define NULLcmd ESCAPE
#define BSPcmd MLF
#endif

void (* key_map [256]) () =
{	/* characters to functions map */
   /* 000-017 */ NULLcmd, MPW, DCC, PD, MRT, MUP, MNW, GOTO,
		 BSPcmd, S, S, DLN, HOP, SNL, RS, LIB,
   /* 020-037 */ PT, HOP, PU, MLF, DNW, DT, CTRl, SU,
		 MDN, YA, SD, ESCAPE, CANCEL, MARK, DPW, BAD,
   /* 040-057 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 060-077 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 100-117 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 120-137 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 140-157 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 160-177 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, DPC,
#ifdef msdos
   /* 200-217 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 220-237 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
#else
   /* 200-217 */ FUNKEY, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 220-237 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
#endif
   /* 240-257 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 260-277 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 300-317 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 320-337 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 340-357 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
   /* 360-377 */ S, S, S, S, S, S, S, S, S, S, S, S, S, S, S, S,
};

void (* ws_key_map [32]) () =
{	/* characters to functions map */
   /* 000-017 */ NULLcmd, MPW, JUS, PD, MRT, MUP, MNW, DCC,
		 MLF, S, S, ctrlK, RS, SNL, LIB, ctrlO,
   /* 020-037 */ CTRl, ctrlQ, PU, MLF, DNW, BAD, TOGINS, SU,
		 MDN, DLINE, SD, ESCAPE, CANCEL, BAD, BAD, BAD,
};

/*
function keys deliver NUL and the following codes:
Block1: RGISOQHKPM
Block2: GHIKMOPQRS	Pos1 Up PgUp Left Center Right End Down PdDn Ins
Cntrl:	st <-/->
Cntrl:	wu Pos1/End
	v PgUp / PgDn	<- for MSDOS: first char is  (a-with-")
F1-F10: ;<=>?@ABCD
shift:	TUVWXYZ[\]
cntrl:	^_`abcdefg
alt:	hijklmnopq
*/

void
HELPF ()
{ status_msg ("       F2 write  F3 edit  F6 \357  F7 \371  F8 search     F9 next       F10 hop"); }
void
HELPS ()
{ status_msg ("shift- F2 write!          F6 `  F7 ~  F8 search rev F9 next       F10 hop"); }
void
HELPC ()
{ status_msg ("cntrl- F2 exit   F3 view  F6 ^  F7 \370  F8 search nxt F9 cycle lns  F10 hop"); }
void
HELPA ()
{ status_msg ("alt-   F2 write buffer                F8 search rev F9 switch lns F10 hop"); }

void (* pc_key_map [256]) () =
{	/* function characters to functions map */
/* The codes for F1..F10 start at the entry HELPF, shifted at HELPS etc. */
   /* 000-017 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 020-037 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 040-057 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 060-077 */ I, I, I, I, I, I, I, I, I, I, I, HELPF, WT, EDIT, I, I,
   /* 100-117 */ (voidfunc) acute, (voidfunc) diaeresis, SFW, RS, 
		 GOTO, I, I, MARK, MUP, PU, I, MLF, HOP, MRT, I, YA,
   /* 120-137 */ MDN, PD, PT, DCC, 
		 HELPS, WTU, I, I, I, (voidfunc) grave, (voidfunc) tilde, SRV, 
		 RS, GOTO, HELPC, EXED,
   /* 140-157 */ VIEW, I, I, (voidfunc) circumflex, 
		 (voidfunc) angstrom, RS, LNCI, GOTO, 
		 HELPA, WB, I, I, I, I, I, SRV,
   /* 160-177 */ LNSW, GOTO, I, MPW, MNW, DT, SD, HOP, I, I, I, I, I, I, I, I,
   /* 200-217 */ I, I, I, I, SU, I, I, I, I, I, I, I, I, MUP, I, HOP,
   /* 220-237 */ I, MDN, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 240-257 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 260-277 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 300-317 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 320-337 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 340-357 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I,
   /* 360-377 */ I, I, I, I, I, I, I, I, I, I, I, I, I, I, I, I
};

#ifndef msdos

/* The mapping between function key sequences and functions */

struct {
	char * fk;
	void (* fp) ();
} keycode [] =
{	/* Escape-key sequences of function keys */
	/* VT100 and SUN */
	{"\033[A",	MUP},	/* move cursor up	*/
	{"\033[B",	MDN},	/* more cursor down	*/
	{"\033[C",	MRT},	/* more cursor right	*/
	{"\033[D",	MLF},	/* more cursor left	*/
	/* SUN raw keycodes */
	{"\033[215z",	MUP},	/* move cursor up	*/
	{"\033[221z",	MDN},	/* more cursor down	*/
	{"\033[219z",	MRT},	/* more cursor right	*/
	{"\033[217z",	MLF},	/* more cursor left	*/
	/* VT100 */
	{"\033[6~",	PD},	/* Next Screen	*/
	{"\033[5~",	PU},	/* Prev Screen	*/
	{"\033[4~",	MARK},	/* Select	*/
	{"\033[3~",	DT},	/* Remove	*/
	{"\033[2~",	PT},	/* Insert Here	*/
	{"\033[1~",	SFW},	/* Find		*/
	{"\033[29~",	YA},	/* Do		*/
	{"\033[28~",	HELP},	/* Help		*/
	{"\033[17~",	(voidfunc) diaeresis}, /* F6	*/
	{"\033[18~",	(voidfunc) diaeresis}, /* F7	*/
	{"\033[19~",	SFW},	/* F8	*/
	{"\033[20~",	RS},	/* F9	*/
	{"\033[21~",	I},	/* F10	*/
	{"\033[23~",	I},	/* F11	*/
	{"\033[24~",	I},	/* F12	*/
	{"\033[25~",	I},	/* F13	*/
	{"\033[26~",	I},	/* F14	*/
	{"\033[31~",	I},	/* F17	*/
	{"\033[32~",	I},	/* F18	*/
	{"\033[33~",	I},	/* F19	*/
	{"\033[34~",	I},	/* F20	*/
	{"\033OP",	HOP},	/* PF1	*/
	{"\033OQ",	SU},	/* PF2	*/
	{"\033OR",	SD},	/* PF3	*/
	{"\033OS",	I},	/* PF4	*/
	/* SUN */
	{"\033[208z",	(voidfunc) grave},	/* R1 */
	{"\033[209z",	(voidfunc) circumflex},	/* R2 */
	{"\033[210z",	(voidfunc) acute},	/* R3 */
	{"\033[211z",	(voidfunc) diaeresis},	/* R4 */
	{"\033[212z",	(voidfunc) tilde},	/* R5 */
	{"\033[213z",	(voidfunc) angstrom},	/* R6 */
	{"\033[214z",	SU},	/* R7	*/
	{"\033[216z",	PU},	/* R9	*/
	{"\033[218z",	HOP},	/* R11	*/
	{"\033[220z",	SD},	/* R13	*/
	{"\033[222z",	PD},	/* R15	*/
	{"\033[254z",	GOMA},	/* - */
	{"\033[253z",	MARK},	/* + */
	{"\033[250z",	YA},	/* Enter */
	{"\033[249z",	DT},	/* Del */
	{"\033[247z",	PT},	/* Ins */
	{"\033[2z",	PT},	/* Ins (NeWS) */
	{"\033[192z",	MARK},	/* Stop */
	{"\033[193z",	I},	/* Again */
	{"\033[194z",	FS},	/* Props */
	{"\033[195z",	I},	/* Undo */
	{"\033[197z",	YA},	/* Copy */
	{"\033[199z",	PT},	/* Paste */
	{"\033[200z",	RS},	/* Find */
	{"\033[201z",	DT},	/* Cut */
	{"\033[196z",	HELP},	/* Help */
	{"\033[225z",	WT},	/* F2 */
	{"\033[226z",	EDIT},	/* F3 */
	{"\033[227z",	I},	/* F4 */
	{"\033[228z",	I},	/* F5 */
	{"\033[229z",	PU},	/* F6 */
	{"\033[230z",	PD},	/* F7 */
	{"\033[231z",	SFW},	/* F8 */
	{"\033[232z",	RS},	/* F9 */
	{"\033[233z",	I},	/* F10 */
	{"\033[234z",	I},	/* F11 */
	{"\033[235z",	I},	/* F12 */
	/* Iris */
	{"\033[209q",	MARK},	/* Print Screen */
	{"\033[213q",	YA},	/* Scroll Lock */
/*	{"\033[217q",	I}, */	/* Pause */
	{"\033[139q",	PT},	/* Insert, Ins */
	{"\033[P",	DT},	/* Del */
	{"\033[H",	SU},	/* Home */
	{"\033[150q",	PU},	/* PgUp */
	{"\033[146q",	SD},	/* End */
	{"\033[154q",	PD},	/* PgDn */
	{"\033[000q",	HOP},	/* 5 */
	{"\033[001q",	HELP},	/* F1 */
	{"\033[002q",	WT},	/* F2 */
	{"\033[005q",	I},	/* F5 */
	{"\033[006q",	I},	/* F6 */
	{"\033[007q",	I},	/* F7 */
	{"\033[008q",	SFW},	/* F8 */
	{"\033[009q",	RS},	/* F9 */
	{"\033[022q",	(voidfunc) grave},	/* Shift-F10 */
	{"\033[023q",	(voidfunc) circumflex},	/* Shift-F11 */
	{"\033[024q",	(voidfunc) acute},	/* Shift-F12 */
	{"\033[010q",	(voidfunc) diaeresis},	/* F10 */
	{"\033[011q",	(voidfunc) tilde},	/* F11 */
	{"\033[012q",	(voidfunc) angstrom},	/* F12 */
	/* VT100 emulator at IBM-PC */
	{"\033M",	PU},	/* Pg Up */
	{"\033D",	PD},	/* Pg Dn */
/*	{"\033[H",	SU}, */	/* Home	, same at Iris */
	{"\033[24;1H",	SD},	/* End	*/
	{"\0331",	HOP},	/* Ins	*/
		/* cursor keys and F1-4 same as VT100 */
	/* crttool */
	{"\033m",	DIRECT},	/* direct cursor address */
	NIL_PTR
};

#define MAXCODELEN 7 /* max. length of function key sequence to be detected, 
			depending on the keycode table => used in mined1.c */

#endif

/*  ==================================================================	*
 *				End					*
 *  ==================================================================	*/
