// BUBBLES.C
// Jeff Bowermaster
// (c) 1994, Splat! Graphics


#include <stdio.h>
#include <conio.h>
#include <math.h>
#include <graphics.h>
#include <alloc.h>
#include <stdlib.h>

typedef struct {
	float x,  /*  current             */
			y,  /*  bubblet             */
			z,  /*  location            */
			r,  /*  radius              */
			v,  /*  upward velocity     */
			p,  /*  oscillation period  */
			a;  /*  amplitude           */
	}Bubble;

void DefineScreen()
{
	int g_driver=9, g_mode=2, d;         /* VGA 640 x 480, 16 color */
	if(registerbgidriver(EGAVGA_driver) < 0) exit(1);
	initgraph(&g_driver,&g_mode,"");     /* Set up screen size */
}


void Set_the_palette()
{
	int i;
	int Col[16][3] =
	{ {  5,  5,  5 },
	  { 22,  0,  0 },
	  { 36,  0,  0 },
	  { 50,  0,  0 },
	  { 63,  0,  0 },
	  { 63, 23,  0 },
	  { 63, 32,  0 },
	  { 63, 47,  0 },
	  { 63, 63,  0 },
	  {  2, 51, 21 },
	  {  0, 50, 40 },
	  {  0, 30, 60 },
	  { 20, 10, 42 },
	  { 30,  0, 37 },
	  { 35,  0, 31 },
	  { 32, 32, 32 } };

	for (i=0; i<16; i++){
		setpalette(i,i);
		setrgbpalette(i,Col[i][0],Col[i][1],Col[i][2]);
	}
}

void main()
{
	int n, count=500;

	Bubble *c,*co;

	if( (c = (Bubble *)malloc(count*sizeof(Bubble)))==NULL) {
		exit(1);
	}

	if((co = (Bubble *)malloc(count*sizeof(Bubble)))==NULL) {
		exit(1);
	}

	DefineScreen();
	Set_the_palette();

	for(n=0;n<count;n++) {
	  c[n].x = 0.02*(float)rand();
	  c[n].y = 0.015*(float)rand();
	  c[n].z = 0.01*(float)rand();
	  c[n].r = 1+0.00015*(float)rand();
	  c[n].v = -1*c[n].r;
	  c[n].a = 0.5*c[n].r;
	  c[n].p = 0.000002*(float)rand();
	  co[n].x=c[n].x;
	  co[n].y=c[n].y;
	  co[n].z=c[n].z;
	}

	while(!kbhit()){
		for(n=0;n<count;n++) {
			setcolor(0);
			circle((int)co[n].x,(int)co[n].y,(int)c[n].r);

			c[n].y = c[n].y + c[n].v;

			c[n].x = c[n].x + c[n].a * sin(c[n].p * c[n].y);
			if (c[n].y < 0.0)
				c[n].y = c[n].y + 480.0;

			setcolor(n%16);
			circle((int)c[n].x,(int)c[n].y,(int)c[n].r);
			co[n].x = c[n].x;
			co[n].y = c[n].y;
			co[n].z = c[n].z;
		}
	}
	closegraph();
}

