######################################################################
## MSC 7.0
## C++ Makefile for
## DiskTutor class library
## Verification Test Suite
######################################################################
## Usage Notes:
## To build test suite:
##     nmake /fmsc70.mak
##          or
##     nmake /fmsc70.mak all
##
## To run test suite
##     nmake /fmsc70.mak verify
##
## To clean intermediate *.obj files:
##     nmake /fmsc70.mak clean
######################################################################



######################################################################
CCDEBUG = /Od /Zi
LNKDEBUG = /CO
MODEL = S       # C small memory model
USR_INCLUDE_DIR =   ..\include
USR_LIB_DIR     =   ..\lib
##I = c:\c700\include   ## Environment variables used instead
USRLIB=dt.lib

CC = cl
LNK = link
CFLAGS = $(CCDEBUG) /A$(MODEL) /Gs /I$(USR_INCLUDE_DIR)
LFLAGS = $(LNKDEBUG)
######################################################################
## Meaning of CFLAGS for MSC 7.0 Compiler
## /AS      small memory model
## /Gs      turn off run-time stack checking
## /Od      turn off all optimizations (use with /Zi for debugging)
## /Zi      include symbolic debug information in obj files
## /Ipath   dir indicates additional path to search for #include
######################################################################

######################################################################
## Meaning of LFLAGS for MSC 7.0 Linker
## /CO      include symbolic debug information in exe files
######################################################################


######################################################################
## Rules
######################################################################
.obj.exe:
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

.cpp.obj:
    $(CC) /c $(CFLAGS) $<



######################################################################
## Default targets
######################################################################
all:    \
        xarray.exe \
        xbag.exe \
        xidentdi.exe \
        xlist.exe \
        xordcltn.exe \
        xpoint.exe \
        xqueue.exe \
        xrect.exe \
        xset.exe \
        xsortclt.exe \
        xstack.exe \


######################################################################
## Target dependencies
######################################################################
xarray.exe: xarray.obj

xbag.exe: xbag.obj

xidentdi.exe: xidentdi.obj

xlist.exe: xlist.obj

xordcltn.exe: xordcltn.obj

xpoint.exe: xpoint.obj

xqueue.exe: xqueue.obj

xrect.exe: xrect.obj

xsortclt.exe: xsortclt.obj

xstack.exe: xstack.obj

xrandom.exe: xrandom.obj

xset.exe: xset.obj

xtime.exe: xtime.obj
                        

######################################################################
## Verification Test Suite
######################################################################
## For some unknown reason, under DOS, output can not
## be piped into diff using |.  Normally diff.exe does accept
## piped input if the first argument is - instead
## of a filename.  But the combination of nmake and DOS will
## occasionally cause the pipe to generate the error 
## message: 'Bad command or file name.' 
##
## The following test suite has been used under various UNIX shells
## and, with the minor adaptation described above, works under
## DOS 5.0 as well.  The suite assumes diff.exe is in this directory
## or somewhere in command path.  A suitable version of diff.exe is
## provided with this library.
##
## NOTE:    The last test (xstack) should print an error message
##          to stderr when pop is performed on an empty stack.
######################################################################
verify:
    -xset >out.v
        -diff out.v set.v
    -xarray >out.v
        -diff out.v array.v
    -xbag >out.v
        -diff out.v bag.v
    -xidentdi >out.v
        -diff out.v identdic.v2
    -xlist >out.v
        -diff out.v list.v
    -xordcltn >out.v
        -diff out.v ordcltn.v
    -xpoint >out.v
        -diff out.v point.v
    -xqueue >out.v
        -diff out.v queue.v
    -xrect >out.v
        -diff out.v rect.v
    -xsortclt >out.v
        -diff out.v sortcltn.v2
    -xstack >out.v
        -diff out.v stack.v
    -del out.v

verifyOLD:
    -sh -c xset | diff - set.v
    -sh -c xarray | diff - array.v
    -sh -c xbag | diff - bag.v
    -sh -c xidentdi | diff - identdic.v
    -sh -c xlist | diff - list.v
    -sh -c xordcltn | diff - ordcltn.v
    -sh -c xpoint | diff - point.v
    -sh -c xqueue | diff - queue.v
    -sh -c xrect | diff - rect.v
    -sh -c xsortclt | diff - sortcltn.v
    -sh -c xstack | diff - stack.v

clean:
    del *.obj


