#include "dict.h"
#include "integer.h"
#include "strclass.h"

void printXplusY(Object& x, Object& y)      // polymorphic function
{
    cout << x << "+" << y << "=";
    if ((x.isSpecies(class_Integer)) &&     // Integers were passed
        (y.isSpecies(class_Integer)))
    {
        cout << ((Integer&)x).value() + ((Integer&)y).value();
    }
    else if ((x.isSpecies(class_String)) && // Strings were passed
        (y.isSpecies(class_String)))
    {
        cout << ((String&)x) + ((String&)y);
    }
    else
    {
        cout <<"unknown";
    }
    cout << "\n";
}

main()
{
    cout << "\nDictionary as a polymorphic symbol table\n";
    Dictionary aDictionary;
    
    // Mixed type values with String keys
    aDictionary.addAssoc((*new String("key1")), (*new String("one")));
    aDictionary.addAssoc((*new String("key2")), *new Integer(2));
    aDictionary.addAssoc((*new String("key3")), (*new String("three")));
    
    // Add Integer values for keys x and y
    aDictionary.addAssoc((*new String("x")), *new Integer(100));
    aDictionary.addAssoc((*new String("y")), *new Integer( 45));
    
    // Print dictionary contents
    cout << "aDictionary contents\n" << aDictionary << "\n";
    
    // Call polymorphic function with Integer args
    printXplusY(*(aDictionary.atKey(String("x"))),
                *(aDictionary.atKey(String("y"))));

    // Call polymorphic function with String args
    printXplusY(*(aDictionary.atKey(String("key1"))),
                *(aDictionary.atKey(String("key3"))));

    // Replace y with new value
    aDictionary.atKey(String("y"), *new Integer(46));
    printXplusY(*(aDictionary.atKey(String("x"))),
                *(aDictionary.atKey(String("y")))); 

    // Replace Integer values with String values
    aDictionary.atKey(String("x"), (*new String("abc")));
    aDictionary.atKey(String("y"), (*new String("def")));

    printXplusY(*(aDictionary.atKey(String("x"))),
                *(aDictionary.atKey(String("y"))));
    return 0;
}



