;windispl  --  copies the active image to the specified windows image
;
;syntax: windispl h #
;        h - windows image 
;        # = display modifier:
;             1: load grey value LUT
;             2: load pseudo colour LUT
;             3: load bitplane LUT: bitpl. 1 = red
;             4: load bitplane LUT: bitpl. 1 = red, 2 = green, 3 = blue
;        # = 16:   16 col. windows display - use dithering
;        # = 16+8: 16 col. windows display - no dithering
;        # = 256: 256 col. windows display
;

#include timdefs.h
;#define LUTMASK         7
;#define DISPL_MASK 0xfff8

parms
  file imag            ;Win-image to fill
  int imode   
endparms

if (((improp imag) & WIN_BIT) !=  WIN_BIT) stop

switch (imode & LUTMASK)	;isolate LUT info
  case WINLUT1			;load greyvalue LUT
	/winlut 1
;  case WINLUT2			;load pseudocolour LUT
;	lut 3 2
  case WINLUT3
	/winlut 3			;load bitplane LUT: bitpl. 1 = red
  case WINLUT4			;load bitplane LUT: bitpl. 1 = red, 2 = green, 3 = blue
	/winlut 4
endsw

switch (imode & DISPL_MASK)  ;remove LUT info
  case 0
    stop
  case NO_DITHER
    stop             ;for NO_DITHER attr. with no image copy (0)
  case COL16
    sdot imag  (imode & BITMASK)      ;copy image using dithering
  default
    save imag        ;copy image as is (also for COL16+NO_DITHER)
endsw

stop
