@(debug,off)
@(-) --------------------------------------------------------------------
@(-)                DCLA_LSP.TPL -- template for generation of .lsp files
@(-)                                using DCL files
@(-)                                responding to user input
@(-) --------------------------------------------------------------------
@(-)
@(time)
@(-)
@(form,fd,"%d")
@(form,fu,"%u")
@(form,f02u,"%02u")
@(form,f3u,"%3u")
@(form,f03u,"%03u")
@(form,fs,"%s")
@(form,ff,"%4.2f")
@(-)
;***********************************************************************/
;** @(tab,20) @(fs,file_name).lsp @(tab,71)**/
;** @(tab,20) generated at @(fu,day).@(f02u,month).@(fu,year), @(fu,hour):@(f02u,minute):@(f02u,second) @(tab,71)**/
;***********************************************************************/


(setq dim_pos '(-1 -1))
;  ----------------------------------------------------------------------
(defun C:dlg_@(fs,dlg) ()

  (setq @(fs,Prefix)_dcl_id (load_dialog "@(fs,file_name).DCL"))
  (if (< @(fs,Prefix)_dcl_id 0) (exit))

  (if (not (new_dialog "@(fs,Prefix)_@(fs,dlg_name)" @(fs,Prefix)_dcl_id)) (exit))

@(loop)
@(if,is_callback)
  (action_tile "@(fs,Key)" @(tab,45) "(@(fs,Key)_cb $value)")
@(endif)
@(endloop)

  ; ---------------------------------------------------------------
  ;          >>>> hier eigene Initialisierung codieren <<<<
  ; ---------------------------------------------------------------

  (start_dialog)
  (unload_dialog @(fs,Prefix)_dcl_id)
)


;***********************************************************************
;**                        call back functions                        **
;***********************************************************************
@(loop)
@(if,is_callback)


; ---------------------------------------------------------------------
;  @(fs,Prefix)_@(f03u,control_id)  @(fs,control_name)
;          key             "@(fs,Key)"
@(if,is_default)
;          is_default
@(endif)
@(if,is_cancel)
;          is_cancel
@(endif)
@(if,is_help)
;          is help
@(endif)
@(if,is_topic)
;          is_topic
@(endif)
@(if,is_info)
;          is info
@(endif)
@(if,has_label)
;          label           "@(fs,label)"
@(endif)
@(-) ------------------------------------------
@(if,has_value)
@(ifnot,slider)
;          value           "@(fs,value)"
@(endif)
@(if,slider)
;          min_value       @(fd,min_value)
;          value           @(fd,slider_value)
;          max_value       @(fd,max_value)
;          big_increment   @(fd,big_increment)
;          small_increment @(ff,small_increment)
@(endif)
@(endif)
@(-) ------------------------------------------
@(if,edit_box)
@(if,has_edit_limit)
;          edit_limit      @(f3u,edit_limit)
@(endif)
@(ifnot,has_edit_limit)
;          edit_limit      TILE_STR_LIMIT (default)
@(endif)
@(endif)
@(if,has_slide)
;          slide_name      "@(fs,slide_name)"
@(endif)
@(if,is_help)
;          help_file       "@(fs,help_file)"
@(endif)
@(if,is_topic)
;          help_topic      "@(fs,help_topic)"
@(endif)
@(if,is_info)
;          info_name       "@(fs,info_name)"
@(endif)
@(if,has_label)
;          has_label
@(endif)
@(if,has_value)
;          has_value
@(endif)
@(if,has_edit_limit)
;          has_edit_limit
@(endif)
@(if,has_slide)
;          has_slide
@(endif)
@(if,is_default)
;          is_default
@(endif)
@(if,is_cancel)
;          is_cancel
@(endif)
@(if,is_help)
;          is_help
@(endif)
@(if,is_topic)
;          is_topic
@(endif)
@(if,is_info)
;          is_info
@(endif)
@(if,is_callback)
;          is_callback
@(endif)
@(if,edit_box)
@(if,is_string)
;          is_string
@(endif)
@(if,is_short)
;          is_short
@(endif)
@(if,is_integer)
;          is_integer
@(endif)
@(if,is_long)
;          is_long
@(endif)
@(if,is_ads_real)
;          is_ads_real
@(endif)
@(if,is_2D_point)
;          is_2D_point
@(endif)
@(if,is_3D_point)
;          is_3D_point
@(endif)
@(endif)
; ---------------------------------------------------------------------
(defun @(fs,Key)_cb (value)
@(if,has_label)
  (princ "\nYou have clicked at @(fs,control_name) \"@(fs,label)\".")
@(endif)
@(  ifnot,has_label)
  (princ " \nYou have clicked at the @(fs,control_name) @(fs,Prefix)_@(f03u,control_id).")
@(  endif)
@(  if,is_cancel)
  (setq dim_pos (done_dialog 0))
@(  endif)
@(  if,is_default)
  (setq dim_pos (done_dialog 1))
@(  endif)
@(ifnot,is_default)
@(  endif)
)
; ---------------------------------------------------------------------
@(endif)
@(endloop)
@(-) --------------------------------------------------------------------
@(-)                          end of template for generation of .lsp file
@(-) --------------------------------------------------------------------
