//***************************************************************************
// Stephen. A. Edwards. December 1993
//
// Example for use of Sounds class.
//
// A simple example to demonstrate the use of the Sounds class.
// As the first argument to the program use the directory and filename
// of a valid VOC format sound file.
//

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>

#include "sounds.h";

//**************************************************************************
// main program

main(int argc, char * argv[] )
{
Sounds * 	mysound;

enum IRQ  	irq  = IRQ5;
enum SIZE 	size = BUF8K;
enum BASE 	base = BASE220;

long int	Status;
char *		error;
int			confirm;

clrscr();
printf("Sounds Class Example Program\n\n");
printf("This example assumes the following: \n");
printf("  1) You have a Sound Blaster or Sound Blaster Compatible card. \n");
printf("  2) This example uses IRQ5 for the sound card. \n");
printf("  3) This examples assumes the base address for the card is 0x220.\n");
printf("\n");
printf("If your sound card does not use IRQ5 or does not have \n");
printf("a Base Address of 0x220 change this program accordingly.\n");
printf("Otherwise you can expect to see some error messages instead \n");
printf("of hearing the sound file.\n");
printf("\n");
printf("Are we ready ? ( type Y or N ) ");

confirm = getch();
if ( confirm == 'Y' || confirm == 'y' )
	{
	if ( argc > 1 )
		{
		mysound = new Sounds( irq, base, size);

		if( (Status = mysound->Play( argv[1] )) != 1 )
			{
			printf("*** Error *** Status is %li \n", Status);
			mysound->Error( Status, &error );
			printf("%s \n", error );
			}

		while( !mysound->Finished );

		delete mysound;

		printf("\n");
		printf("Finished - Later Dude \n");
		}
	else
		{
		printf("\n");
		printf("I was expecting the name of a VOC format sound file. \n");
		printf("Please try again with the name of a VOC file. \n");
		printf("Thank You.\n");
		}

	} // endif chickened out
else
	{
	clrscr();
	printf("\n\n\n");
	printf("A wise decision.\n");
	printf("Please modify this program to use the correct IRQ \n");
	printf("and/or Base Address. Please note that registered users \n");
	printf("will receive an upgraded version of this software with \n");
	printf("many new useful funtions as well as the ability \n");
	printf("to auto-detect the IRQ and Base Address. All for the very \n");
	printf("low price of $15, what a bargain!\n\n");
	printf("Have a nice day.\n");
	}
}