#ifndef HP3D_H
#define HP3D_H

//      Objects instantiated from this class may be used to plot z=f(x,y) in
// in three dimensions on an HP LaserJet 3 printer (with sufficient memory).

//      This class uses the abstract class "plot3d" (3D plot) which in turn uses 
// the template "varray" (one dimensional virtual array) and the class
// "titillat" (to let the user know the code is running).  This class also uses
// "varray".

#include "varray.h"
#include "plot3d.h"

typedef char * char_ptr;

// graphics constants
#define PIXELS_PER_INCH    300
#define WIDTH_IN_INCHES    7.5
#define LENGTH_IN_INCHES   10.6
#define PIXELS_PER_STROKE  1    /* 300/PIXELS_PER_INCH */
#define NUM_X_BYTES        397  /* (int) (LENGTH_IN_INCHES*PIXELS_PER_INCH/8) */
#define X_BYTE_MAX         396  /* NUM_X_BYTES-1 */
#define NUM_X_PIXELS       3176 /* 8*NUM_X_BYTES */
#define X_PIXEL_MAX        3175 /* NUM_X_PIXELS-1 */
#define NUM_Y_PIXELS       2250 /* (int) (WIDTH_IN_INCHES*PIXELS_PER_INCH) */
#define Y_PIXEL_MAX        2249 /* NUM_Y_PIXELS-1 */
#define ASPECT_RATIO       1.0

typedef struct
          {
            unsigned char column [NUM_X_BYTES];
          } row_rec; // line of graphics to be sent to the printer


class hp3d : public plot3d
  {
    private:

      varray<row_rec> *row_array;
                       // page of graphics to be sent to the printer
      int             row_array_allocated;
                       // TRUE if and only if "row_array" allocated

    public:

      double aspect_ratio(void) {return ASPECT_RATIO;}
//      (WIDTH_IN_INCHES/((float) NUM_Y_PIXELS))
// /(LENGTH_IN_INCHES/((float) NUM_X_PIXELS)) 

      int    display_initialized(void);
//      Allocate and clear the page of graphics to be sent to the printer.

             hp3d(void);

             ~hp3d(void);

      int    num_x_pixels(void) {return NUM_X_PIXELS;}

      int    num_y_pixels(void) {return NUM_Y_PIXELS;}

      void   pset(int x,int y,int color_num);
//      Use dithering to set the pixel at (x,y).

      int    write_outfile(char *file_name);
//      Write the page of graphics to a file where it can later be copied
// to the printer.  (The /B option *must* be used with the COPY command.)
  };

#endif
