//      This program plots
// z=2.0*cos(7.0*sqrt(x*x+y*y))*cos(7.0*sqrt(x*x+y*y))/(1.0+30.0*(x*x+y*y))
// in three dimensions on an HP LaserJet 3 printer.

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <conio.h>
#include <iostream.h>
#include "titillat.h"
#include "plot3d.h"
#include "hp3d.h"

#ifndef TRUE
#define TRUE -1
#endif
#ifndef FALSE
#define FALSE 0
#endif

static int    external_to_plot(double,double);
static double f(double,double);
       int    main(void);
static int    red(double,double);

extern unsigned _stklen=0x8000;

int main()
    {
      static   int    fatal_error;
      static   double light_x;
      static   double light_y;
      static   double light_z;
      static   double rotation;
      static   double tilt;
      static   hp3d   *hp3d_ptr;

      fatal_error=FALSE;
      hp3d_ptr=new hp3d();
      rotation=(double) 30.0;
      tilt=(double) -30.0;
      light_x=(double) 1.0;
      light_y=(double) -1.0;
      light_z=(double) 1.0;
      if (hp3d_ptr->prepare_plot(f, // function f(x,y) to be plotted
       -1.0,                        // minimum x
       1.0,                         // maximum x
       -1.0,                        // minimum y
       1.0,                         // maximum y
       external_to_plot,            // don't plot -- always FALSE
       red,                         // highlight -- always FALSE
       200,                         // number of x divisions
       200,                         // number of y divisions
       rotation,                    // rotation in degrees
       tilt,                        // tilt in degrees
       light_x,light_y,light_z))    // vector to light source
        {
          if (hp3d_ptr->plot("SPIKE",        // output file name
                              FALSE,         // highlight flagged areas
                              TRUE))         // amuse user while plotting
            cout << "\"COPY /B SPIKE LPT1:\"" << '\n';
        }
      delete hp3d_ptr;
      return(fatal_error);
    }

static int external_to_plot(
  double x,
  double y)
    {
       return FALSE;
    }

static int red(
  double x,
  double y)
    {
       return FALSE;
    }

static double f(
  double x,
  double y)
    {
       double t1=x*x+y*y;
       double t2=cos(7.0*sqrt(t1));
       return 2.0*t2*t2/(1.0+30.0*t1);
    }

