program unuse;
{ Copyright 1991,1993, James Gregg Haley }
{ This program removes directories from the path }

uses DOS;

type
  path_type = string[255];

const
  Block_Marker = $4D;       Zero  = $00;
  Path1 = $50; Path2 = $41; Path3 = $54; Path4 = $48; Path5 = $3D;
  min_mem_loc = 50;
  NormalExit  = 0;
  HelpScreen  = 4;
  NotFound    = 2;


var
  path, newpath, temp_path: path_type;
  param_count, env_seg, path_off, env_len: word;
  env_end, original_path_length: word;
  x, y, ExitCode: word;
  position: byte;
  quiet_mode: boolean;

procedure PrintHelp;
  begin
    Writeln('Deletes directories from the search path.');
    Writeln;
    Writeln('UNUSE [[drive:]path[;...]] [/Q] [/?]');
    Writeln;
    Writeln('Execution of UNUSE without parameters displays the current path.');
    Writeln;
    Writeln('/Q   Quiet, does not display new path.');
    Writeln('/?   Display this help screen.');
    Writeln;
    Writeln;
    Writeln('Version 6.2');
    Halt(HelpScreen);
  end;


function upcase_string (str: pathstr) : pathstr;
  var
    i: byte;

  begin { upcase_string }
    for i := 1 to Length(str) do
      str[i] := UpCase(str[i]);
    upcase_string := str;
  end;  { upcase_string }


procedure find_env(Var env_seg, path_off, env_len: word);
{ This finds the segment, offset of "PATH=", and length of the environment }

  var
    i, j, Prev_Prefix, Com_Prefix, Hold_Prefix: word;
    search_done: boolean;

  begin  { find_env }
    Hold_Prefix := PrefixSeg;
    Com_Prefix  := PrefixSeg;
    repeat                                      { Step Through the }
      Prev_Prefix := Com_Prefix;                { Prefix chain     }
      Com_Prefix := Hold_Prefix;
      Hold_Prefix := memw [ Hold_Prefix : $16 ];
    until Com_Prefix = Hold_prefix;

    env_seg  := Zero;                           { set to zero }
    path_off := Zero;                           { if not found }
    env_len  := Zero;
    for i := Com_Prefix to Prev_Prefix do
      if (Mem[i:0]    = Block_Marker) and       { Env Header }
         (Mem[i:3]    > 9)            and       { Env must be > 160 }
         (Mem[i:4]    < 9)            and       { Env must be < 32768 }
         (Mem[i:(((Mem[i:4]*256)+Mem[i:3] +1) * 16)]  = Block_Marker)   then

        for j := 16 to ((Mem[i:4]*256)+(Mem[i:3] * 16)) - 5 do
          if ((Mem[i:j-1] = Zero) or (j = 16)) and
              (Mem[i:j]   = Path1) and          { Look for PATH= }
              (Mem[i:j+1] = Path2) and
              (Mem[i:j+2] = Path3) and
              (Mem[i:j+3] = Path4) and
              (Mem[i:j+4] = Path5) then
           begin
              env_seg  := i + 1;                { Set Env segment }
              path_off := j - 16;               { set path offset }
              env_len  := (Mem[i:4] * 256 + Mem[i:3]) * 16; {set Env length}
              Exit;
           end;  { env found }

  end;   { find_env }

procedure mod_path(newpath: path_type);
{ This procedure adds the new dirs to the path }

  var
    position: byte;

  begin  { mod_path }
    if newpath <> ';' then                    { See if it's on the path }
      position := Pos(';' + newpath + ';', ';' + path + ';')
    else
      position := 0;

    if (position > 0) and (Length(newpath) > 0) then
      if (position = 1) or (path[position-1] = ';') then
        Begin                                 { Remove it from the path }
          Delete(path, position, Length(newpath) + 1);
          ExitCode := NormalExit;
        end;

    while (path[Length(path)] = ';') do
      Delete(path, Length(path), 1);          { Remove ; from the end of the path }
  end;   { mod_path }



begin  { program unuse }
  path                 := GetEnv('PATH');
  original_path_length := Length(path);
  param_count          := ParamCount;
  ExitCode             := NotFound;
  newpath              := '';
  quiet_mode           := False;

  for x := 1 to ParamCount do                 { read the command line }
    begin
      temp_path := ParamStr(x);               { grab the parameter }
      if temp_path[1] = '/' then              { Any switches? }
        begin
          if (Length(temp_path) > 1) and
             (temp_path[2] in ['H', 'h', '?']) then
            PrintHelp;
          if (Length(temp_path) > 1) and
             (temp_path[2] in ['Q', 'q']) then  { Be quiet! }
            quiet_mode := True;
        end     { switch found }
      else
        begin
          param_count := param_count + 1;
          newpath := newpath + ';' + upcase_string(temp_path);
        end;    { parameter found }
    end; { Scan for parameters and switches }


  if param_count > 0 then                       { There is something to del }
    begin

    while (Length(newpath) > 0) do              { del dirs, one at a time }
      Begin
        position := Pos (';', newpath);
        if (position = 0) then                  { last parameter }
          begin
            temp_path := newpath;
            newpath := '';
          end
        else
          begin
            temp_path := Copy  (newpath, 1, position-1);
            Delete(newpath, 1, position);
          end;

        if temp_path <> '' then
          mod_path (temp_path);
      end; { add dirs to the path }


      path := path + chr(0) + chr(0);
      find_env(env_seg, path_off, env_len);
      env_end := path_off;

      repeat                                    { Look for Nul Nul }
        inc(env_end);
      until (mem[env_seg:env_end] = 0) and (mem[env_seg:env_end+1] = 0);

                                                { Copy rest of environment }
      for y := path_off + original_path_length + 5 to env_end - 1 do
        mem[env_seg:y - original_path_length - 5] := mem[env_seg:y+1];
      y := env_end - original_path_length - 5;
      mem[env_seg:y] := Path1;                  { Copy PATH= }
      inc(y);
      mem[env_seg:y] := Path2;
      inc(y);
      mem[env_seg:y] := Path3;
      inc(y);
      mem[env_seg:y] := Path4;
      inc(y);
      mem[env_seg:y] := Path5;
      for x := 1 to Length(path) do
        mem[env_seg:y + x] := ord(path[x]);     { Copy new path }
    end;  { if param count }

    if not quiet_mode then
      if path = '' then
        writeln('No Path')
      else
        writeln('PATH=',path);

    Halt(ExitCode);

end.   { program use }

