program use;
{  Copyright 1991,1993, James Gregg Haley }
{  This program will append directory names to the path }

uses DOS;

type
  path_type = string[255];

{ Path1-5 are "PATH=", Block_Marker is "M" }
const
  Block_Marker = $4D;       Zero  = $00;
  Path1 = $50; Path2 = $41; Path3 = $54; Path4 = $48; Path5 = $3D;
  min_mem_loc = 50;
  DirAdded    = 0;
  DirMoved    = 1;
  NoChange    = 2;
  HelpScreen  = 4;
  NotAdded    = 5;

var
  path, newpath, temp_path: path_type;
  param_count, env_seg, path_off, env_len, addl_bytes: word;
  env_end, original_path_length: word;
  x, y, ExitCode: word;
  position, Begin_Length, End_Length: byte;
  insert_front, quiet_mode: boolean;

procedure PrintHelp;
  begin
    Writeln('Append new directories to the front of the search path.');
    Writeln;
    Writeln('USE [[drive:]path[;...]] [/E] [/Q] [/?]');
    Writeln;
    Writeln('Execution of USE without parameters displays the current path.');
    Writeln;
    Writeln('/E   Append to end of the path');
    Writeln('/Q   Quiet, does not display new path');
    Writeln('/?   Display this help screen');
    Writeln;
    Writeln('Version 6.2');
    Halt(HelpScreen);
  end;



function string_count (str: pathstr) : byte;
  var
    i,j: byte;

  begin { upcase_string }
    j := Length(str);
    for i := 1 to Length(str) do
      if str[i] = ';' then
        j := j - 1;

    string_count := j;
  end;  { upcase_string }


function upcase_string (str: pathstr) : pathstr;
  var
    i: byte;

  begin { upcase_string }
    for i := 1 to Length(str) do
      str[i] := UpCase(str[i]);
    upcase_string := str;
  end;  { upcase_string }


function Reverse_Order (str: path_type) : path_type;
  var
    position: byte;
    temp_path: path_type;

  begin { Reverse_Order }
    temp_path := '';
    while (Length(str) > 0) do              { Add dirs, one at a time }
      Begin
        position := Pos (';', str);
        if (position = 0) then                  { last parameter }
          begin
            temp_path := str + ';' + temp_path;
            str := '';
          end
        else
          begin
            temp_path := Copy  (str, 1, position-1) + ';' + temp_path;
            Delete(str, 1, position);
          end;
      end; { add dirs to the path }

    Reverse_Order := temp_path;
  end;  { Reverse_order }


procedure find_env(Var env_seg, path_off, env_len: word);
{ This finds the segment, offset of "PATH=", and length of the environment }

  var
    i, j, Prev_Prefix, Com_Prefix, Hold_Prefix: word;
    search_done: boolean;

  begin  { find_env }
    Hold_Prefix := PrefixSeg;
    Com_Prefix  := PrefixSeg;
    repeat                                         { Step Through the }
      Prev_Prefix := Com_Prefix;                   { Prefix chain     }
      Com_Prefix := Hold_Prefix;
      Hold_Prefix := memw [ Hold_Prefix : $16 ];
    until Com_Prefix = Hold_prefix;

    env_seg  := Zero;             { set to zero }
    path_off := Zero;             { if not found }
    env_len  := Zero;
    for i := Com_Prefix to Prev_Prefix do       { Look for the Environment }
      if (Mem[i:0]    = Block_Marker) and       { Env Header }
         (Mem[i:3]    > 9)            and       { Env must be > 160 }
         (Mem[i:4]    < 9)            and       { Env must be < 32768 }
         (Mem[i:(((Mem[i:4]*256)+Mem[i:3] +1) * 16)]  = Block_Marker)   then

        for j := 16 to ((Mem[i:4]*256)+(Mem[i:3] * 16)) - 5 do
          if ((Mem[i:j-1] = Zero) or (j = 16)) and
              (Mem[i:j]   = Path1) and          { Look for "PATH=" }
              (Mem[i:j+1] = Path2) and
              (Mem[i:j+2] = Path3) and
              (Mem[i:j+3] = Path4) and
              (Mem[i:j+4] = Path5) then
           begin
              env_seg  := i + 1;                { Set Env segment }
              path_off := j - 16;               { set path offset }
              env_len  := (Mem[i:4] * 256 + Mem[i:3]) * 16; {set Env length}
              Exit;
           end;  { env found }

  end;   { find_env }


procedure mod_path(newpath: path_type);
{ This procedure adds the new dirs to the path }

  var
    position: byte;


  begin  { mod_path }

    while (newpath[Length(newpath)] = ';') do { Strip ";" off the back }
      Delete(newpath, Length(newpath), 1);

    position := Pos(';' + newpath + ';', ';' + path + ';'); { is it already there? }
    if (position > 0) and (Length(newpath) > 0) then
      if (position = 1) or (path[position-1] = ';') then
        Begin                                 { remove the old path }
          Delete(path, position, Length(newpath) + 1);
        end;

    while (path[Length(path)] = ';') do       { Strip ";" off the back }
      Delete(path, Length(path), 1);

    if insert_front then                      { Insert the new path }
      path := newpath + ';' + path
    else
      path := path + ';' + newpath;

  end;   { mod_path }


begin  { program use }                        { get the current Path }
  path                 := GetEnv('PATH');
  original_path_length := Length(path);
  Begin_Length         := String_Count(path); { Save for comparison later }
  param_count          := 0;
  newpath              := '';
  ExitCode             := NoChange;
  insert_front         := True;               { insert in front of the path }
  quiet_mode           := False;


  for x := 1 to ParamCount do                 { read the command line }
    begin
      temp_path := ParamStr(x);               { grab the parameter }
      if temp_path[1] = '/' then              { Any switches? }
        begin
          if (Length(temp_path) > 1) and
             (temp_path[2] in ['E', 'e', 'B', 'b']) then
            insert_front := False;            { append to end instead }
          if (Length(temp_path) > 1) and
             (temp_path[2] in ['Q', 'q']) then
            quiet_mode := True;               { Be quiet! }
          if (Length(temp_path) > 1) and
             (temp_path[2] in ['H', 'h', '?']) then
            PrintHelp;
        end     { switch found }
      else
        begin
          param_count := param_count + 1;
          newpath := newpath + ';' + upcase_string(temp_path);
        end;    { parameter found }
    end; { Scan for parameters and switches }


  if param_count > 0 then                       { There is something to add }
    begin

    ExitCode := DirAdded;

    newpath := Reverse_Order(newpath);
    while (Length(newpath) > 0) do              { Add dirs, one at a time }
      Begin
        position := Pos (';', newpath);
        if (position = 0) then                  { last parameter }
          begin
            temp_path := newpath;
            newpath := '';
          end
        else
          begin
            temp_path := Copy  (newpath, 1, position-1);
            Delete(newpath, 1, position);
          end;

        if temp_path <> '' then
          mod_path (temp_path);
      end; { add dirs to the path }

      End_Length := String_Count(path);         { See if the path changed }

      path := path + chr(0) + chr(0);           { Put in Nul Nul to be safe }

      if path = ';' then
        path := chr(0) + chr(0);                { Delete the lonely ";" }

      if (path[1] = ';')  and (Length(path) > 1) then
        Delete(path, 1, 1);                     { Strip off ";" off the front }

      addl_bytes := length(path) - original_path_length;
      find_env(env_seg, path_off, env_len);     { Get the address }
      env_end := path_off;

      repeat                                    { Look for Nul Nul }
        inc(env_end);
      until (mem[env_seg:env_end] = 0) and (mem[env_seg:env_end+1] = 0);

      if env_end + addl_bytes < env_len then    { Make sure there is room }
        begin                                   { Copy rest of environment }
          for y := path_off + original_path_length + 5 to env_end - 1 do
            mem[env_seg:y - original_path_length - 5] := mem[env_seg:y+1];
          y := env_end - original_path_length - 5;
          mem[env_seg:y] := Path1;
          inc(y);                               { Copy in PATH= }
          mem[env_seg:y] := Path2;
          inc(y);
          mem[env_seg:y] := Path3;
          inc(y);
          mem[env_seg:y] := Path4;
          inc(y);
          mem[env_seg:y] := Path5;
          for x := 1 to Length(path) do         { Copy in the new path }
            mem[env_seg:y + x] := ord(path[x]);
        end  { env space check }
      else
        begin
          writeln('Out of Environment Space');
          Halt(NotAdded);
        end;
    end;

  if ExitCode = DirAdded then
    if Begin_Length = End_Length then
      ExitCode := DirMoved;

  if not quiet_mode then
    if path = '' then
      writeln('No Path')
    else
      writeln('PATH=',path);

  Halt(ExitCode);

end.   { program use }

