(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:Dimmer (Demo)                                              *)
(* Zweck:Ein- und Ausblenden des Bildschirms                       *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

MODULE DimDemo;

FROM Dimmer IMPORT SetPalette16,SetDemoColors,DimmerIn1to8,DimmerIn9to15,DimmerOut1to8,
                   DimmerOut9to15;
FROM GrafText IMPORT CharInit,CharSize,CharEffect,CharType,PlotStr;
FROM Lib IMPORT Intr,Sound,NoSound,RANDOM;

IMPORT Graph,SYSTEM,Lib,IO;

VAR A:ARRAY [0..44] OF SHORTCARD;
    cpu:SYSTEM.Registers;
    Z:CARDINAL;
    TOM:ARRAY [1..3] OF CHAR;
    X:CARDINAL;

PROCEDURE Loeschen;
BEGIN
  FOR X:=100 TO 350 DO Graph.HLine(10,X,620,0);END;
END Loeschen;


BEGIN
  Graph.InitVGA;
  Graph.GraphMode;
  cpu.AH:=0;
  cpu.AL:=12H;
  Intr(cpu,10H);
  FOR Z:=0 TO 44 DO A[Z]:=0;END;
  SetPalette16(A);
  CharInit;
  CharSize(3,3,-6);
  CharEffect(0,0,0,1,1,0);
  PlotStr(150,170,"Beispiel fr",1,0,49);
  PlotStr(120,220,"Umblendtechnik",9,0,49);
  SetDemoColors;
  DimmerIn1to8(FALSE);
  DimmerIn9to15(TRUE);
  Lib.Delay(1000);
  DimmerOut1to8(TRUE);
  DimmerOut9to15(FALSE);
  Loeschen;
  SetPalette16(A);
  CharEffect(0,0,1,0,0,0);
  CharSize(2,2,-4);
  PlotStr(145,170,"Hier sehen Sie, wie",4,0,17);
  PlotStr(180,200,"Schatteneffekte",4,0,17);
  PlotStr(170,230,"erzeugen knnen!",4,0,17);
  SetDemoColors;
  DimmerIn1to8(FALSE);
  DimmerIn9to15(TRUE);
  Lib.Delay(3000);
  DimmerOut1to8(TRUE);
  DimmerOut9to15(FALSE);
  Loeschen;
  SetPalette16(A);
  CharInit;
  CharSize(3,3,-6);
  CharEffect(0,0,0,1,1,0);
  PlotStr(150,160,"Jetzt andere",12,0,49);
  PlotStr(240,200,"Farben",12,0,49);
  SetDemoColors;
  DimmerIn9to15(FALSE);
  Lib.Delay(1000);
  DimmerOut9to15(FALSE);
  Loeschen;
  SetPalette16(A);
  PlotStr(90,160,"Jetzt mit anderer",15,0,49);
  PlotStr(90,190,"Farbe und anderem",15,0,49);
  PlotStr(50,220,"Wert fr Farbwechsel",8,0,49);
  SetDemoColors;
  DimmerIn1to8(FALSE);
  Lib.Delay(500);
  DimmerIn9to15(TRUE);
  Lib.Delay(200);
  DimmerOut1to8(TRUE);
  Lib.Delay(1200);
  DimmerOut9to15(FALSE);
  Loeschen;
  SetPalette16(A);
  CharEffect(0,0,0,0,0,0);
  PlotStr(305,170,CHR(1),1,0,49);
  CharSize(2,2,-4);
  PlotStr(55,220,"(C) Copyright 1994 by Tronix",7,0,49);
  SetDemoColors;
  DimmerIn1to8(FALSE);
  DimmerIn9to15(TRUE);
  Lib.Delay(1000);
  DimmerOut1to8(TRUE);
  DimmerOut9to15(FALSE);
  Loeschen;
  Graph.TextMode;
END DimDemo.