(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:Zeit                                                       *)
(* Zweck:Parallele Prozesse (Zeitanzeige)                          *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

MODULE ZeitII;

FROM GrafText IMPORT PlotStrFast2,CharInit;
FROM Lib IMPORT Dos,Intr;
IMPORT SYSTEM,Str,IO,Graph;

VAR ZeitStr:ARRAY[1..3] OF CHAR;
    ok:BOOLEAN;
    Secs,AlteZeit,ZeitSek:CARDINAL;
    cpu:SYSTEM.Registers;

BEGIN
  CharInit;
  ZeitSek:=0;
  Graph.InitVGA;
  Graph.GraphMode;
  cpu.AH:=0;
  cpu.AL:=12H;
  Intr(cpu,10H);
  cpu.AH:=2CH;
  Dos(cpu);
  AlteZeit:=CARDINAL(cpu.DH);
  Str.CardToStr(LONGCARD(ZeitSek),ZeitStr,10,ok);
  REPEAT
    cpu.AH:=2CH;
    Dos(cpu);
    Secs:=CARDINAL(cpu.DH);
  UNTIL (Secs>AlteZeit) OR ((Secs=0) AND (AlteZeit>50));
  AlteZeit:=Secs;
  IF ZeitSek<10 THEN PlotStrFast2(300,383,ZeitStr,4,49);
    ELSIF ZeitSek<100 THEN PlotStrFast2(278,383,ZeitStr,4,49);
    ELSE PlotStrFast2(256,383,ZeitStr,4,49);
  END;
  LOOP
    (***********************
      hier wird die andere
      Prozedur eingefgt
     ***********************)
    cpu.AH:=2CH;
    Dos(cpu);
    Secs:=CARDINAL(cpu.DH);
    IF (Secs=0) AND (AlteZeit>50) OR (Secs>AlteZeit) THEN
      Str.CardToStr(LONGCARD(ZeitSek),ZeitStr,10,ok);
      IF ZeitSek<10 THEN PlotStrFast2(300,383,ZeitStr,0,0);
        ELSIF ZeitSek<100 THEN PlotStrFast2(278,383,ZeitStr,0,0);
        ELSE PlotStrFast2(256,383,ZeitStr,0,0);
      END;
      INC(ZeitSek);
      Str.CardToStr(LONGCARD(ZeitSek),ZeitStr,10,ok);
      IF ZeitSek<10 THEN PlotStrFast2(300,383,ZeitStr,4,49);
        ELSIF ZeitSek<100 THEN PlotStrFast2(278,383,ZeitStr,4,49);
        ELSE PlotStrFast2(256,383,ZeitStr,4,49);
      END;
      AlteZeit:=Secs;
    END;
    IF IO.KeyPressed() THEN EXIT;END;
  END;
END ZeitII.