/* Menubox Library Function Copyright 1991 by Chuck Steenburgh 
   This function will draw a box border at the specified coordinates 
   Optionally, a drop shadow can be defined around the box           */
   
#include <stdlib.h>
#include <bios.h>

/* The following data are passed to the function:

	r1, c1:  The row and column location of the upper left-hand
		    corner of the box
	r2, c2:  The row and column location of the lower right-hand
		    corner of the box.
	color:   The color attributes of the box border (see colortext
		    function for explanation)
	boxtype: Single or double line box as indicated below:
	
		  Value                    Type Box
		  =====                    ========
		    1                       Single
		    2                       Double
		    3                       Double Horizontal
		    4                       Double Vertical
		    5                       Thick solid line
		    6                       Medium solid line
		    7                       Shaded solid line (ASCII 176)
		    8                       Shaded solid line (ASCII 177)
		    9                       Shaded solid line (ASCII 178)
		    
	shadow: 0 for no shadow, 1 for dropshadow
	
	shade:  Enter the number of the shading type desired:
	
		  Value                    ASCII Char used for shadow
		  =====                    ==========================
		    1                               176 
		    2                               177
		    3                               178
		    
	The same color is used for the shadow as for box itself.*/
		    
			 
int menubox(int r1, c1, r2, c2, color, boxtype, shadow, shade, max_rows)
{
   int shad_char,count1,tl,tr,bl,br,h,v;
   
   
/*  Input constaints:  Box must be at least 3x3; must be completely within 
    the bounds of the screen; color must be valid; boxtype must be one of
    the nine values listed above.                                         */
    
	if (((r2-r1)<2) || (r1<0) || (r2>max_rows) || ((c2-c1)<2) || (c1<0) || (c2>79) || (color<0) || (color>255) || (boxtype<1) || (boxtype>9)) {
		return 1;
	}

/*  ASCII values of various "pieces" of the box are determined by boxtype */    
	
	switch (boxtype) {
		case 1: {
			tl=218; /* top left corner */
			tr=191; /* top right corner */
			bl=192; /* bottom left corner */
			br=217; /* bottom right corner */
			h=196; /* horizontal side */
			v=179; /* vertical side */
		}
		break;
		case 2: {
			tl=201;
			tr=187;
			bl=200;
			br=188;
			h=205;
			v=186;
		}
		break;
		case 3: {
			tl=213;
			tr=184;
			bl=212;
			br=190;
			h=205;
			v=179;
		}
		break;
		case 4: {
			tl=214;
			tr=183;
			bl=211;
			br=189;
			h=196;
			v=186;
		}
		break;
		case 5: {
			tl=219;
			tr=219;
			bl=219;
			br=219;
			h=219;
			v=219;
		}
		break;
		case 6: {
			tl=220;
			tr=220;
			bl=219;
			br=219;
			h=220;
			v=219;
		}
		break;
		case 7: {
			tl=176;
			tr=176;
			bl=176;
			br=176;
			h=176;
			v=176;
		}
		break;
		case 8: {
			tl=177;
			tr=177;
			bl=177;
			br=177;
			h=177;
			v=177;
		}
		break;
		case 9: {
			tl=178;
			tr=178;
			bl=178;
			br=178;
			h=178;
			v=178;
		}
		break;
	}    
	poscurs(r1,c1); /* position cursor in top left corner */
	writechs(tl,color,1); /* draw top left corner piece */
	poscurs(r1,c1+1); 
	writechs(h,color,c2-c1-1); /* draw top side of box */
	poscurs(r1,c2); /* position cursor in top right corner */
	writechs(tr,color,1); /* draw top right corner piece */
	poscurs(r2,c1); /* position cursor in bottom left corner */
	writechs(bl,color,1); /* draw bottom left piece */
	poscurs(r2,c1+1);
	writechs(h,color,c2-c1-1); /* draw bottom side of box */
	poscurs(r2,c2); /* position cursor in bottom right corner */
	writechs(br,color,1); /* draw bottom right corner piece */
	for (count1=1;count1<(r2-r1);count1++) {
		poscurs(count1+r1,c1);  /* simulaneously draw left and right sides */
		writechs(v,color,1);
		poscurs(count1+r1,c2);
		writechs(v,color,1);
	}
	/* Check for dropshadow */
	if (shadow == 0)
		return 0;
	
	/* Check if space exists for shadow */
	if (((r2-r1)<2) || (r1<0) || (r2>max_rows-2) || ((c2-c1)<2) || (c1<0) || (c2>78) || (color<0) || (color>255) || (shade<1) || (shade>3)) {
		return 2;
	}
	
	/* Shade character is set to ASCII 176,177, or 178 */
	shad_char = shade + 175;
	
	/* The bottom shadow is drawn */
	poscurs(r2+1,c1+2);
	writechs(shad_char,color,c2-c1+1);
	
	/* The right shadow is drawn */
	for (count1=0;count1<(r2-r1);count1++) {
		poscurs(r1+1+count1,c2+1);
		writechs(shad_char,color,2);
	}
	
	return 0;

}
	
