/////////////////////////////////////////////////////////////////////////////
//
//  XDIALOG.c
//
/////////////////////////////////////////////////////////////////////////////
//
//  Written by Douglas Holt 12 March 1994
//
//  This program contains extended dialog functions for IPAS r3.
//
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"
#include "dialog.h"
#include "keys.h"


void feel_ok(Dialog *d, int mouse);
void feel_cancel(Dialog *d, int mouse);
int insert_name_list_sorted(Name_list *namelist, char *name);

/* this value will hold the status of the dialog. It will be set to 1
 * if the user OKed the dialog, 0 otherwise. */
int dlgResult = 0;

// this variable should be set by the ClientStartUp function like this:
// stud_r3 = (studio_version() >= 300);
int stud_r3 = 1;

void feel_cancel(Dialog *d, int mouse){
	/* If this feel function is the result of a mouse click, * then it
		is necessary to make sure the user releases * the mouse inside
		the region of the button. */
	if(mouse)
		if(!(press_button(d)))
			return;
	
	see_button(d);
	gfx_butup();
	
	/* this indicates to the dialog library that the dialog should be
	 * terminated. */
	dialog_done = 1;
	
	/* indicate that the dialog was CANCELled. */
	dlgResult = 0;
}

void feel_ok( Dialog *d, int mouse ){
	/* If this feel function is the result of a mouse click, * then it
		is necessary to make sure the user releases * the mouse inside
		the region of the button. */
	if(mouse)
		if(!(press_button(d)))
			return;
	
	see_button(d);
	gfx_butup();
	
	/* this indicates to the dialog library that the dialog * should be
		terminated. */
	dialog_done = 1;
	
	/* indicate that the dialog was OKed. */
	dlgResult = 1;
}

/////////////////////////////////////////////////////////////////////////////
//                       insert_name_list_sorted
/////////////////////////////////////////////////////////////////////////////
int insert_name_list_sorted(Name_list *namelist, char *name){
Name_list *temp;
Name_list *prev = NULL;
Name_list *new = NULL;

	temp = namelist;
	while(temp && strcmp(name, temp->name) < 0){
		prev = temp;
		temp = temp->next;
	}
	if(temp){
		if((new->name = (char *)malloc(strlen(name) * sizeof(char) + 1)) == NULL)
			return(0);
		strcpy(new->name, name);
		if(prev)
			prev->next = new;
		new->next = temp;
	}
	return(1);
}

