/* Cursor routines */

/* Written by Dave Stampe, August 1992 */

/* Copyright 1992 by Dave Stampe and Bernie Roehl.
   May be freely used to write software for release into the public domain;
   all commercial endeavours MUST contact Bernie Roehl and Dave Stampe
   for permission to incorporate any part of this software into their
   products!
 */

void cursor_move(int x, int y);  // move cursor if visible
int cursor_hide();               // erase cursor
int cursor_forget();             // will be erased by redraw: ignore it!
void cursor_show(int page);      // redisplay cursor
int move_2D(PDRIVER *d, int *x, int *y, unsigned *b);
int move_till_click(PDRIVER *d, unsigned b, int *x, int *y); /* b is button mask */
int can_point_2D();
int move_and_select_2D(PDRIVER *d);
void pointer_to_world(POINTER *p, VIEW *v, long *x, long *y, long *z);
void rotate_to_view( VIEW *v, long *x, long *y, long *z);
int glove_update(PDRIVER *d, POINTER *p, int which); // read glove, update positions
int load_glove_cursor(SEGMENT *body_seg, PDRIVER *gd, char *glove_fname, int which);
int load_3D_cursor(SEGMENT *body_seg, PDRIVER *gd, char *cursor_fname);
int cursor_update3D(PDRIVER *d, POINTER *p); // read pointer, update positions
SEGMENT *manip_data(PDRIVER *d, long *x, long *y, long *z, int which);

#define FREE_DO   0    		// commands to manipulation
#define GRASP_DO  1
#define ROTATE_DO 2
#define SELECT_DO 3

/* End of cursor.h */
