// Copyright 1993, Mark T. Pflaging
#ifndef __RENDGEST_HPP
#define __RENDGEST_HPP

#include "namenumb.hpp"

class RendGestSet : public NumberedGestSet
{
public:
	enum RendGests {
		Up, Down, Left, Right,
		StraightUp, StraightDown, StraightLeft, StraightRight,
		GeneralExtreme, ExtremeUp, ExtremeDown, ExtremeLeft, ExtremeRight,
		TiltUp, TiltDown, TwistCW, TwistCCW,
		Mode1On, Mode1Off, Mode2On, Mode2Off,
		Select, Move, Twist
	};

	Boolean statusBits[Twist + 1];
	Boolean useMode1Off, useMode2Off;

	RendGestSet(char * name = NULL) : NumberedGestSet(name) {}
	RendGestSet(InitFile & ini, int which, char * sectionName = "X.Rend386") {
		sectionName[0] = which + '1';
		Init(ini, sectionName);
	}
	RendGestSet(RendGestSet & arg) {
		*this = arg;
	}
	void addId(char * text, int id) {
		if (text) NumberedGestSet::addId(text, id);
	}
	void Init(InitFile & ini, char * sectionName);
	virtual void Register(Gesture & found, Boolean onOrOff);
	virtual void postCheck();
	int findGest();
};

#endif
